/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.manifest;

import com.atlassian.fisheye.git.GitCache;
import com.atlassian.fisheye.manifest.CommonManifest;
import com.atlassian.fisheye.manifest.CommonManifestDAO;
import com.atlassian.fisheye.manifest.ManifestMergeTestBase;
import com.cenqua.fisheye.Path;
import org.junit.Assert;
import org.junit.Test;

public class ManifestTest
extends ManifestMergeTestBase {
    private Path f1Path = new Path((CharSequence)"f1.txt");
    private Path f2Path = new Path((CharSequence)"f2.txt");
    private Path f3Path = new Path((CharSequence)"f3.txt");

    public ManifestTest() {
        super("manifest");
    }

    @Test
    public void testFirstCommit() throws Exception {
        GitCache cache = (GitCache)this.getCache();
        CommonManifestDAO manifestDAO = cache.getCommonManifestDAO();
        CommonManifest manifest = manifestDAO.load("d64f9cb6a509897e94b27bc96dacfebff74040ab");
        Assert.assertEquals((Object)"d64f9cb6a509897e94b27bc96dacfebff74040ab", (Object)manifest.getPathCommit(this.f1Path));
        Assert.assertEquals((Object)"d64f9cb6a509897e94b27bc96dacfebff74040ab", (Object)manifest.getPathCommit(this.f2Path));
        Assert.assertEquals((Object)"d64f9cb6a509897e94b27bc96dacfebff74040ab", (Object)manifest.getPathCommit(this.f3Path));
    }

    @Test
    public void testSimpleCommit() throws Exception {
        GitCache cache = (GitCache)this.getCache();
        CommonManifestDAO manifestDAO = cache.getCommonManifestDAO();
        CommonManifest manifest = manifestDAO.load("91240ba123ba02cf773b5c1e9e465614b68ad3df");
        Assert.assertEquals((Object)"91240ba123ba02cf773b5c1e9e465614b68ad3df", (Object)manifest.getPathCommit(this.f1Path));
        Assert.assertEquals((Object)"d64f9cb6a509897e94b27bc96dacfebff74040ab", (Object)manifest.getPathCommit(this.f2Path));
        Assert.assertEquals((Object)"d64f9cb6a509897e94b27bc96dacfebff74040ab", (Object)manifest.getPathCommit(this.f3Path));
    }

    @Test
    public void testSilentMergeCommit() throws Exception {
        GitCache cache = (GitCache)this.getCache();
        CommonManifestDAO manifestDAO = cache.getCommonManifestDAO();
        CommonManifest manifest = manifestDAO.load("a3e75abd23f5a552924a1a9ec6f207488086848a");
        Assert.assertEquals((Object)"91240ba123ba02cf773b5c1e9e465614b68ad3df", (Object)manifest.getPathCommit(this.f1Path));
        Assert.assertEquals((Object)"4dfd2dc5c116e6aa1533c3d89fa6cd504dfb03f9", (Object)manifest.getPathCommit(this.f2Path));
        Assert.assertEquals((Object)"d64f9cb6a509897e94b27bc96dacfebff74040ab", (Object)manifest.getPathCommit(this.f3Path));
    }
}

