/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.manifest;

import com.atlassian.fisheye.git.GitScanner;
import com.atlassian.fisheye.git.GitTestHarness;
import com.atlassian.fisheye.manifest.CommonManifest;
import com.atlassian.fisheye.manifest.CommonManifestDAOImpl;
import com.atlassian.fisheye.manifest.ManifestMergeTestBase;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.search.SearchResults;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class DeleteMerge3Test
extends ManifestMergeTestBase {
    public DeleteMerge3Test() {
        super("delmerge3");
    }

    @Test
    public void testTagT1Content() throws Exception {
        Map<String, String> taggedPaths = this.getTaggedPaths("t1");
        this.assertTaggedFile("d1/f1.txt", taggedPaths, true);
        this.assertTaggedFile("d1/f2.txt", taggedPaths, false);
    }

    @Test
    public void testManifest() throws Exception {
        CommonManifestDAOImpl manifestDAO = (CommonManifestDAOImpl)((GitScanner)((GitTestHarness)this.testHarness).getScanner()).getManifestProcessor().getManifestDAO();
        CommonManifest manifest = manifestDAO.load("0a52e6dfd457cc851925f2f40a583f17a1cd1b52");
        String commit = manifest.getPathCommit(new Path((CharSequence)"d1/f2.txt"));
        Assert.assertNotNull((String)"Commit should not be null for d1/f2", (Object)commit);
    }

    @Test
    public void testHeadMarkers() throws Exception {
        String query = "select revisions from dir \"/\" where is head on b1";
        SearchResults collator = ((GitTestHarness)this.testHarness).evaluateQuery("select revisions from dir \"/\" where is head on b1");
        int size = collator.size();
        Assert.assertEquals((String)"Should only be one result", (long)1L, (long)size);
        SearchResults.RevisionResultsIterator results = collator.iterateRevisions(0);
        FileRevision rev = results.nextItem();
        Assert.assertEquals((String)"The one file revision is not the correct path", (Object)"d1/f1.txt", (Object)rev.getPath().getPath());
        Assert.assertEquals((String)"The one file revision is not the correct changeset", (Object)"7a2f381cc7b6467ec833b9e5988e51f8ac66d312", (Object)rev.getChangeSetId());
    }
}

