/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.jira.issue;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.AuthorisationURIGenerator;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.EntityLink;
import com.atlassian.applinks.api.EntityLinkService;
import com.atlassian.applinks.api.application.jira.JiraProjectEntityType;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.EffectiveUserProviderImpl;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.jira.JiraIssue;
import com.atlassian.fisheye.jira.JiraServer;
import com.atlassian.fisheye.jira.JiraServerService;
import com.atlassian.fisheye.jira.RemoteJiraException;
import com.atlassian.fisheye.jira.issue.JiraIssueServiceImpl;
import com.atlassian.fisheye.jira.issue.QueryContext;
import com.atlassian.fisheye.jira.issue.QueryContextImpl;
import com.atlassian.fisheye.jira.issue.RemoteExceptionHandler;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.UserAppLink;
import com.cenqua.crucible.model.managers.UserAppLinkManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class JiraIssueServiceImplTest {
    EffectiveUserProvider userProvider;
    JiraServerService jiraServerService;
    JiraIssueServiceImpl issueService;
    UserAppLinkManager userAppLinkManager;
    RemoteExceptionHandler remoteExceptionHandler;
    EventPublisher eventPublisher;
    EntityLinkService entityLinkService;
    UserAppLink userAppLink;
    JiraServer noIssues;
    JiraServer noIssues2;
    JiraServer hasTst1;
    JiraServer hasTst1AndTst2;
    JiraIssue tst1;
    JiraIssue tst1Duplicate;
    JiraIssue tst2;
    List<ApplicationId> notifiedCredentials;
    List<ApplicationId> notifiedException;
    final Principal TIM = new Principal(){

        public String getUserName() {
            return "tim";
        }

        public String getDisplayName() {
            return "Tim";
        }
    };
    final Principal BECKY = new Principal(){

        public String getUserName() {
            return "becky";
        }

        public String getDisplayName() {
            return "Becky";
        }
    };
    final ApplicationId ID0 = new ApplicationId("aaaaaaaa-aaaa-aaaa-aaaa-aaaaaaaaaaaa");
    final ApplicationId ID1 = new ApplicationId("bbbbbbbb-bbbb-bbbb-bbbb-bbbbbbbbbbbb");
    final ApplicationId ID2 = new ApplicationId("cccccccc-cccc-cccc-cccc-cccccccccccc");
    final ApplicationId ID3 = new ApplicationId("dddddddd-dddd-dddd-dddd-dddddddddddd");

    @Before
    public void setUp() throws Exception {
        this.userProvider = (EffectiveUserProvider)Mockito.mock(EffectiveUserProviderImpl.class);
        this.jiraServerService = (JiraServerService)Mockito.mock(JiraServerService.class);
        this.userAppLinkManager = (UserAppLinkManager)Mockito.mock(UserAppLinkManager.class);
        this.eventPublisher = (EventPublisher)Mockito.mock(EventPublisher.class);
        this.entityLinkService = (EntityLinkService)Mockito.mock(EntityLinkService.class);
        this.remoteExceptionHandler = new RemoteExceptionHandler(){

            public void acceptCredentialsRequired(JiraServer jiraServer, CredentialsRequiredException cre) {
                JiraIssueServiceImplTest.this.notifiedCredentials.add(jiraServer.getApplicationLink().getId());
            }

            public void acceptException(JiraServer jiraServer, Exception e) {
                JiraIssueServiceImplTest.this.notifiedException.add(jiraServer.getApplicationLink().getId());
            }
        };
        this.issueService = new JiraIssueServiceImpl(this.userProvider, this.jiraServerService, this.userAppLinkManager, this.eventPublisher, this.remoteExceptionHandler, this.entityLinkService);
        this.tst1 = (JiraIssue)Mockito.mock(JiraIssue.class);
        this.tst1Duplicate = (JiraIssue)Mockito.mock(JiraIssue.class);
        this.tst2 = (JiraIssue)Mockito.mock(JiraIssue.class);
        this.noIssues = (JiraServer)Mockito.mock(JiraServer.class);
        Mockito.when((Object)this.noIssues.getIssue(org.mockito.Matchers.anyString())).thenReturn(null);
        this.setUpApplicationLink(this.noIssues, this.ID0);
        this.noIssues2 = (JiraServer)Mockito.mock(JiraServer.class);
        Mockito.when((Object)this.noIssues2.getIssue(org.mockito.Matchers.anyString())).thenReturn(null);
        this.setUpApplicationLink(this.noIssues2, this.ID1);
        this.hasTst1 = (JiraServer)Mockito.mock(JiraServer.class);
        Mockito.when((Object)this.hasTst1.getIssue("TST-1")).thenReturn((Object)this.tst1);
        this.setUpApplicationLink(this.hasTst1, this.ID2);
        this.hasTst1AndTst2 = (JiraServer)Mockito.mock(JiraServer.class);
        Mockito.when((Object)this.hasTst1AndTst2.getIssue("TST-1")).thenReturn((Object)this.tst1Duplicate);
        Mockito.when((Object)this.hasTst1AndTst2.getIssue("TST-2")).thenReturn((Object)this.tst2);
        this.setUpApplicationLink(this.hasTst1AndTst2, this.ID3);
        this.notifiedCredentials = new ArrayList<ApplicationId>();
        this.notifiedException = new ArrayList<ApplicationId>();
        this.userAppLink = (UserAppLink)Mockito.mock(UserAppLink.class);
        Mockito.when((Object)this.userAppLinkManager.getUserAppLink((FecruUser)Mockito.anyObject(), (ApplicationLink)Mockito.anyObject())).thenReturn((Object)this.userAppLink);
        Mockito.when((Object)this.userAppLink.isIgnore()).thenReturn((Object)false);
    }

    @Test
    public void testNoJiraServers() {
        this.setJiraServers(new JiraServer[0]);
        this.setEffectivePrincipal(this.TIM);
        Assert.assertNull((Object)this.issueService.getJiraIssue("TST-1"));
        Assert.assertNull((Object)this.issueService.getJiraIssue("TST-2"));
    }

    @Test
    public void testIssueDoesNotExist() {
        this.setJiraServers(this.noIssues, this.noIssues2);
        this.setEffectivePrincipal(this.TIM);
        Assert.assertNull((Object)this.issueService.getJiraIssue("TST-1"));
        Assert.assertNull((Object)this.issueService.getJiraIssue("TST-2"));
    }

    @Test
    public void testContextSpecifiesNoCache() throws Exception {
        this.setJiraServers(this.noIssues, this.noIssues2, this.hasTst1, this.hasTst1AndTst2);
        this.setEffectivePrincipal(this.TIM);
        Assert.assertEquals((Object)this.tst1, (Object)this.issueService.getJiraIssue("TST-1"));
        JiraIssue freshTst1 = (JiraIssue)Mockito.mock(JiraIssue.class);
        Mockito.when((Object)this.hasTst1.getIssue("TST-1")).thenReturn((Object)freshTst1);
        Assert.assertEquals((Object)freshTst1, (Object)this.issueService.getJiraIssue("TST-1", QueryContextImpl.Builder.newInstance((JiraServerService)this.jiraServerService).build()));
    }

    @Test
    public void testIssueCachedButOutOfContextBounds() throws Exception {
        this.setJiraServers(this.noIssues, this.noIssues2, this.hasTst1, this.hasTst1AndTst2);
        this.setEffectivePrincipal(this.TIM);
        Assert.assertEquals((Object)this.tst1, (Object)this.issueService.getJiraIssue("TST-1"));
        QueryContext queryContext = this.limitedQueryContext(true, this.noIssues, this.noIssues2);
        Assert.assertNull((Object)this.issueService.getJiraIssue("TST-1", queryContext));
    }

    @Test
    public void testIssueExistsWithinContextBounds() throws Exception {
        this.setJiraServers(this.noIssues, this.noIssues2, this.hasTst1, this.hasTst1AndTst2);
        this.setEffectivePrincipal(this.TIM);
        QueryContext queryContext = this.limitedQueryContext(true, this.noIssues, this.noIssues2, this.hasTst1AndTst2);
        Assert.assertEquals((Object)this.tst1Duplicate, (Object)this.issueService.getJiraIssue("TST-1", queryContext));
    }

    private QueryContext limitedQueryContext(boolean withCache, JiraServer ... jiraServers) {
        QueryContext queryContext = (QueryContext)Mockito.mock(QueryContext.class);
        ArrayList jiraServerList = Lists.newArrayList((Object[])jiraServers);
        Mockito.when((Object)queryContext.getJiraServers()).thenReturn((Object)jiraServerList);
        Iterable linkIds = Iterables.transform((Iterable)jiraServerList, jiraServer -> jiraServer.getApplicationLink().getId());
        Mockito.when((Object)queryContext.getJiraServerIds()).thenReturn((Object)linkIds);
        return queryContext;
    }

    @Test
    public void testIssueExistsInCacheButUserDoesNotHavePermission() throws Exception {
        this.setJiraServers(this.noIssues, this.noIssues2, this.hasTst1);
        this.setEffectivePrincipal(this.TIM);
        Assert.assertEquals((Object)this.tst1, (Object)this.issueService.getJiraIssue("TST-1"));
        this.setEffectivePrincipal(this.BECKY);
        Mockito.when((Object)this.hasTst1.getIssue("TST-1")).thenReturn(null);
        Assert.assertNull((Object)this.issueService.getJiraIssue("TST-1"));
    }

    @Test
    public void testJiraServerThrowsCredentialsRequiredException() throws Exception {
        this.setJiraServers(this.noIssues, this.noIssues2, this.hasTst1);
        Mockito.when((Object)this.noIssues.getIssue("TST-1")).thenThrow(new Throwable[]{new RemoteJiraException("ARG!")});
        AuthorisationURIGenerator aug = (AuthorisationURIGenerator)Mockito.mock(AuthorisationURIGenerator.class);
        Mockito.when((Object)this.noIssues2.getIssue("TST-1")).thenThrow(new Throwable[]{new CredentialsRequiredException(aug, "BLARG!")});
        this.setEffectivePrincipal(this.TIM);
        Assert.assertNull((Object)this.issueService.getJiraIssue("TST-1"));
        Assert.assertEquals((Object)this.noIssues.getApplicationLink().getId(), (Object)this.notifiedException.iterator().next());
        Assert.assertEquals((Object)this.noIssues2.getApplicationLink().getId(), (Object)this.notifiedCredentials.iterator().next());
    }

    @Test
    public void testJiraServerThrowsException() throws Exception {
        this.setJiraServers(this.noIssues, this.noIssues2, this.hasTst1);
        Mockito.when((Object)this.noIssues.getIssue("TST-1")).thenThrow(new Throwable[]{new RemoteJiraException("ARG!")});
        AuthorisationURIGenerator aug = (AuthorisationURIGenerator)Mockito.mock(AuthorisationURIGenerator.class);
        Mockito.when((Object)this.noIssues2.getIssue("TST-1")).thenThrow(new Throwable[]{new RuntimeException("BLARG!")});
        this.setEffectivePrincipal(this.TIM);
        Assert.assertEquals((Object)this.tst1, (Object)this.issueService.getJiraIssue("TST-1"));
        Assert.assertEquals((Object)this.noIssues.getApplicationLink().getId(), (Object)this.notifiedException.iterator().next());
        Assert.assertFalse((boolean)this.notifiedCredentials.iterator().hasNext());
    }

    @Test
    public void testJiraServerServiceOutOfSync() throws Exception {
        this.setJiraServers(this.noIssues, this.noIssues2, this.hasTst1);
        this.setEffectivePrincipal(this.TIM);
        Assert.assertEquals((Object)this.tst1, (Object)this.issueService.getJiraIssue("TST-1"));
        this.setJiraServers(this.noIssues, this.noIssues2);
        this.setEffectivePrincipal(this.BECKY);
        Assert.assertNull((Object)this.issueService.getJiraIssue("TST-1"));
    }

    @Test
    public void testIgnoreAllJiraServers() throws Exception {
        this.setJiraServers(this.noIssues, this.noIssues2, this.hasTst1);
        this.setEffectivePrincipal(this.TIM);
        Assert.assertEquals((Object)this.tst1, (Object)this.issueService.getJiraIssue("TST-1"));
        this.setEffectivePrincipal(this.BECKY);
        Mockito.when((Object)this.userAppLink.isIgnore()).thenReturn((Object)true);
        Assert.assertNull((Object)this.issueService.getJiraIssue("TST-1"));
    }

    @Test
    public void testIgnoreOneJiraServer() throws Exception {
        this.setJiraServers(this.noIssues, this.noIssues2, this.hasTst1, this.hasTst1AndTst2);
        this.setEffectivePrincipal(this.TIM);
        Assert.assertEquals((Object)this.tst1, (Object)this.issueService.getJiraIssue("TST-1"));
        this.setEffectivePrincipal(this.BECKY);
        this.ignoreJiraServer(this.hasTst1);
        Assert.assertEquals((Object)this.tst1Duplicate, (Object)this.issueService.getJiraIssue("TST-1"));
    }

    @Test
    public void testFindLinkedCrucibleProjects() throws Exception {
        Project project1 = (Project)Mockito.mock(Project.class, (String)"project1");
        Project project2 = (Project)Mockito.mock(Project.class, (String)"project2");
        Project project3 = (Project)Mockito.mock(Project.class, (String)"project3");
        ImmutableList project2links = ImmutableList.of((Object)this.mockEntityLink("JRA"), (Object)this.mockEntityLink("NOTJRA"));
        ImmutableList project3Links = ImmutableList.of((Object)this.mockEntityLink("JRA"));
        Mockito.when((Object)this.entityLinkService.getEntityLinks((Object)project1, JiraProjectEntityType.class)).thenReturn((Object)ImmutableList.of());
        Mockito.when((Object)this.entityLinkService.getEntityLinks((Object)project2, JiraProjectEntityType.class)).thenReturn((Object)project2links);
        Mockito.when((Object)this.entityLinkService.getEntityLinks((Object)project3, JiraProjectEntityType.class)).thenReturn((Object)project3Links);
        Iterable linkedProjects = this.issueService.findLinkedCrucibleProjects((Iterable)ImmutableList.of((Object)project1, (Object)project2, (Object)project3), "JRA");
        Assert.assertThat((Object)linkedProjects, (Matcher)Matchers.contains((Object[])new Project[]{project2, project3}));
    }

    private EntityLink mockEntityLink(String jiraProjectKey) {
        EntityLink entityLink = (EntityLink)Mockito.mock(EntityLink.class, (String)("EntityLink for " + jiraProjectKey));
        Mockito.when((Object)entityLink.getKey()).thenReturn((Object)jiraProjectKey);
        return entityLink;
    }

    private void setUpApplicationLink(JiraServer jiraServer, ApplicationId id) {
        ApplicationLink appLink = (ApplicationLink)Mockito.mock(ApplicationLink.class);
        Mockito.when((Object)appLink.getId()).thenReturn((Object)id);
        Mockito.when((Object)jiraServer.getApplicationLink()).thenReturn((Object)appLink);
    }

    private void noMoreRemoteCalls(JiraServer jiraServer, String ... issueKeys) throws Exception {
        for (String key : issueKeys) {
            Mockito.when((Object)jiraServer.getIssue(key)).thenThrow(new Throwable[]{new AssertionError((Object)("Requested " + key + ", should have hit cache."))});
        }
    }

    private void setEffectivePrincipal(Principal principal) {
        Mockito.when((Object)this.userProvider.getEffectivePrincipal()).thenReturn((Object)principal);
        FecruUser crucibleUser = (FecruUser)Mockito.mock(FecruUser.class);
        Mockito.when((Object)this.userProvider.getEffectiveUser()).thenReturn((Object)crucibleUser);
    }

    private void setJiraServers(JiraServer ... jiraServers) {
        Mockito.reset((Object[])new JiraServerService[]{this.jiraServerService});
        Mockito.when((Object)this.jiraServerService.getJiraServers()).thenReturn((Object)Lists.newArrayList((Object[])jiraServers));
        for (JiraServer jiraServer : jiraServers) {
            ApplicationId id = jiraServer.getApplicationLink().getId();
            Mockito.when((Object)this.jiraServerService.getJiraServer(id)).thenReturn((Object)jiraServer);
        }
    }

    private void ignoreJiraServer(JiraServer jiraServer) {
        UserAppLink ignoredUserAppLink = (UserAppLink)Mockito.mock(UserAppLink.class);
        Mockito.when((Object)ignoredUserAppLink.isIgnore()).thenReturn((Object)true);
        ApplicationLink hasTst1ApplicationLink = jiraServer.getApplicationLink();
        Mockito.when((Object)this.userAppLinkManager.getUserAppLink((FecruUser)Mockito.anyObject(), (ApplicationLink)org.mockito.Matchers.eq((Object)hasTst1ApplicationLink))).thenReturn((Object)ignoredUserAppLink);
    }
}

