/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.jira;

import com.atlassian.fisheye.jira.JiraIssueUtil;
import com.atlassian.fugue.Option;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class JiraIssueUtilTest {
    private static final String MANY_KEYS_MSG = "string containing edge project keys : one A-1 two BB-2 three CCC-3 four DDDD-4 five EEEEE-5  six FFFFFF-6 seven GGGGGGG-7 eight HHHHHHHH-8 nine IIIIIIIII-9 ten JJJJJJJJJJ-10 eleven KKKKK_KKKKK-11 twelve LLL_LLL_LLLL-12 MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM-50 MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM-51";

    @Test
    public void testGetProjectKey() {
        Assert.assertEquals((Object)"CR", (Object)JiraIssueUtil.getProjectKey((String)"CR-435").get());
        Assert.assertEquals((Object)"JRA-CR", (Object)JiraIssueUtil.getProjectKey((String)"JRA-CR-435").get());
        Assert.assertEquals((Object)Option.none(), (Object)JiraIssueUtil.getProjectKey((String)"ZZZZ"));
        Assert.assertEquals((Object)Option.none(), (Object)JiraIssueUtil.getProjectKey((String)"She sell sea shells"));
    }

    @Test
    public void testGetJiraKeysFromString() throws Exception {
        String testMessage = "JIRA-1330: This is a test message containing some JIRA keys CONF-2345 ABC-123 TJP-4 It also contains a code review key that shouldn't be picked up CR-FE-1234 also FECRU-44";
        List jirakeys = JiraIssueUtil.getJiraKeysFromString((String)testMessage);
        Assert.assertEquals((Object)"JIRA-1330", jirakeys.get(0));
        Assert.assertEquals((Object)"CONF-2345", jirakeys.get(1));
        Assert.assertEquals((Object)"ABC-123", jirakeys.get(2));
        Assert.assertEquals((Object)"TJP-4", jirakeys.get(3));
        Assert.assertEquals((Object)"FECRU-44", jirakeys.get(4));
        Assert.assertEquals((String)"Correct number of JIRA keys found in string", (long)5L, (long)jirakeys.size());
        Assert.assertEquals((String)"Empty list returned when null string passed in", (long)0L, (long)JiraIssueUtil.getJiraKeysFromString(null).size());
        Assert.assertEquals((String)"Empty list returned when empty string passed in", (long)0L, (long)JiraIssueUtil.getJiraKeysFromString((String)"").size());
        Assert.assertEquals((String)"Empty list returned when string that is spaces passed in", (long)0L, (long)JiraIssueUtil.getJiraKeysFromString((String)"     ").size());
        Assert.assertEquals((String)"Empty list returned from String containing just a crucible key", (long)0L, (long)JiraIssueUtil.getJiraKeysFromString((String)"CR-FE-123").size());
        testMessage = "JIRA-1330";
        jirakeys = JiraIssueUtil.getJiraKeysFromString((String)testMessage);
        Assert.assertEquals((String)"Correct number of JIRA keys found in string", (long)1L, (long)jirakeys.size());
        Assert.assertEquals((Object)"JIRA-1330", jirakeys.get(0));
        testMessage = "string containing lowercase nick-33 issue key";
        jirakeys = JiraIssueUtil.getJiraKeysFromString((String)testMessage);
        Assert.assertEquals((String)"Correct number of JIRA keys found in string", (long)1L, (long)jirakeys.size());
        Assert.assertEquals((Object)"NICK-33", jirakeys.get(0));
        testMessage = MANY_KEYS_MSG;
        jirakeys = JiraIssueUtil.getJiraKeysFromString((String)testMessage);
        Assert.assertEquals((String)"Correct number of JIRA keys found in string", (long)12L, (long)jirakeys.size());
        Assert.assertEquals((Object)"BB-2", jirakeys.get(0));
        Assert.assertEquals((Object)"CCC-3", jirakeys.get(1));
        Assert.assertEquals((Object)"DDDD-4", jirakeys.get(2));
        Assert.assertEquals((Object)"EEEEE-5", jirakeys.get(3));
        Assert.assertEquals((Object)"FFFFFF-6", jirakeys.get(4));
        Assert.assertEquals((Object)"GGGGGGG-7", jirakeys.get(5));
        Assert.assertEquals((Object)"HHHHHHHH-8", jirakeys.get(6));
        Assert.assertEquals((Object)"IIIIIIIII-9", jirakeys.get(7));
        Assert.assertEquals((Object)"JJJJJJJJJJ-10", jirakeys.get(8));
        Assert.assertEquals((Object)"KKKKK_KKKKK-11", jirakeys.get(9));
        Assert.assertEquals((Object)"LLL_LLL_LLLL-12", jirakeys.get(10));
        Assert.assertEquals((Object)"MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM-50", jirakeys.get(11));
    }

    @Test
    public void testGetJiraKeysFromStringLiberally() throws Exception {
        Assert.assertThat((Object)ImmutableList.of((Object)"BB-2", (Object)"CCC-3", (Object)"DDDD-4", (Object)"EEEEE-5", (Object)"FFFFFF-6", (Object)"GGGGGGG-7", (Object)"HHHHHHHH-8", (Object)"IIIIIIIII-9", (Object)"JJJJJJJJJJ-10", (Object)"KKKKK_KKKKK-11", (Object)"LLL_LLL_LLLL-12", (Object)"MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM-50", (Object[])new String[0]), (Matcher)Matchers.equalTo((Object)JiraIssueUtil.getJiraKeysFromStringLiberally((String)MANY_KEYS_MSG)));
        Assert.assertThat((Object)ImmutableList.of((Object)"FE-123", (Object)"DEV-1", (Object)"THINGS-2", (Object)"THINGS-32"), (Matcher)Matchers.equalTo((Object)JiraIssueUtil.getJiraKeysFromStringLiberally((String)"CR-FE-123, issue/DEV-1-foo-bar, FIX THINGS-2 break-things-32")));
        Assert.assertThat((Object)ImmutableList.of((Object)"FOO-1", (Object)"FOO-2", (Object)"BAR-3"), (Matcher)Matchers.equalTo((Object)JiraIssueUtil.getJiraKeysFromStringLiberally((String)"FOO-1-FOO-2-BAR-3-issue-things-here")));
    }

    @Test
    public void testOldCustomSupportedJiraKeys() throws Exception {
        Assert.assertThat((Object)JiraIssueUtil.getJiraKeysFromString((String)"Ahoj! To je issue: F-1. Ping pong!"), (Matcher)Is.is((Matcher)Matchers.empty()));
        Assert.assertThat((Object)JiraIssueUtil.getJiraKeysFromString((String)"Ahoj! To je issue: FF-1. Ping pong!"), (Matcher)Matchers.contains((Object[])new String[]{"FF-1"}));
        Assert.assertThat((Object)JiraIssueUtil.getJiraKeysFromString((String)"Ahoj! To je issue: F0-1. Ping pong!"), (Matcher)Matchers.contains((Object[])new String[]{"F0-1"}));
        Assert.assertThat((Object)JiraIssueUtil.getJiraKeysFromString((String)"Ahoj! To je issue: F_-1. Ping pong!"), (Matcher)Matchers.contains((Object[])new String[]{"F_-1"}));
        Assert.assertThat((Object)JiraIssueUtil.getJiraKeysFromString((String)"Ahoj! To je issue: 0F-1. Ping pong!"), (Matcher)Is.is((Matcher)Matchers.empty()));
        Assert.assertThat((Object)JiraIssueUtil.getJiraKeysFromString((String)"Ahoj! To je issue: _F-1. Ping pong!"), (Matcher)Is.is((Matcher)Matchers.empty()));
        Assert.assertThat((Object)JiraIssueUtil.getJiraKeysFromString((String)"Ahoj! To je issue: FOO-1. Ping pong!"), (Matcher)Matchers.contains((Object[])new String[]{"FOO-1"}));
        Assert.assertThat((Object)JiraIssueUtil.getJiraKeysFromString((String)"Ahoj! To je issue: PRODUCT_AWESOME-1. Ping pong!"), (Matcher)Matchers.contains((Object[])new String[]{"PRODUCT_AWESOME-1"}));
        Assert.assertThat((Object)JiraIssueUtil.getJiraKeysFromString((String)"Ahoj! To je issue: PRODUCT2013-1. Ping pong!"), (Matcher)Matchers.contains((Object[])new String[]{"PRODUCT2013-1"}));
        Assert.assertThat((Object)JiraIssueUtil.getJiraKeysFromString((String)"Ahoj! To je issue: PRODUCT_2013-1. Ping pong!"), (Matcher)Matchers.contains((Object[])new String[]{"PRODUCT_2013-1"}));
        Assert.assertThat((Object)JiraIssueUtil.getJiraKeysFromString((String)"Ahoj! To je issue: R2D2-1. Ping pong!"), (Matcher)Matchers.contains((Object[])new String[]{"R2D2-1"}));
        Assert.assertThat((Object)JiraIssueUtil.getJiraKeysFromString((String)"Ahoj! To je issue: MY_EXAMPLE_PROJECT-1. Ping pong!"), (Matcher)Matchers.contains((Object[])new String[]{"MY_EXAMPLE_PROJECT-1"}));
        Assert.assertThat((Object)JiraIssueUtil.getJiraKeysFromString((String)"Ahoj! To je issue: 2013PROJECT-1. Ping pong!"), (Matcher)Is.is((Matcher)Matchers.empty()));
        Assert.assertThat((Object)JiraIssueUtil.getJiraKeysFromString((String)"Ahoj! To je issue: PRODUCT-2012-1. Ping pong!"), (Matcher)Matchers.contains((Object[])new String[]{"PRODUCT-2012"}));
        Assert.assertThat((Object)JiraIssueUtil.getJiraKeysFromString((String)"Ahoj! To je issue: ABC_DE-1. Ping pong!"), (Matcher)Matchers.contains((Object[])new String[]{"ABC_DE-1"}));
        Assert.assertThat((Object)JiraIssueUtil.getJiraKeysFromString((String)"Ahoj! To je issue: ABCD100_EF-1. Ping pong!"), (Matcher)Matchers.contains((Object[])new String[]{"ABCD100_EF-1"}));
        Assert.assertThat((Object)JiraIssueUtil.getJiraKeysFromString((String)"Ahoj! To je issue: CR-FE-100. Ping pong!"), (Matcher)Is.is((Matcher)Matchers.empty()));
    }
}

