/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.it.web;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cvsrep.RepSanityTestBase;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.util.ISO8601DateHelper;
import com.cenqua.fisheye.web.CookiePreferences;
import com.cenqua.fisheye.web.FisheyeRepositoryExplorer;
import com.cenqua.fisheye.web.WaybackSpec;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public final class RepositoryExplorerSanity1Test
extends RepSanityTestBase {
    private static final Comparator<FisheyeRepositoryExplorer.FisheyeFileExplorerInfo> EXP_INFO_COMPARATOR = new Comparator<FisheyeRepositoryExplorer.FisheyeFileExplorerInfo>(){

        @Override
        public int compare(FisheyeRepositoryExplorer.FisheyeFileExplorerInfo f1, FisheyeRepositoryExplorer.FisheyeFileExplorerInfo f2) {
            return f1.getLatestRevision().getPath().getName().compareToIgnoreCase(f2.getLatestRevision().getPath().getName());
        }
    };

    @Override
    protected RepositoryHandle whichHandle() throws Exception {
        return TestFishEyeInstances.getSanity1Repos();
    }

    @Test
    public void testDeletedFile() throws DbException {
        FisheyeRepositoryExplorer re = new FisheyeRepositoryExplorer(this.engine, new Path((CharSequence)"/emptytests/deletedfiles"), null, new CookiePreferences());
        List files = re.getFiles();
        Assert.assertEquals((int)1, (int)files.size());
        FisheyeRepositoryExplorer.FisheyeFileExplorerInfo f = (FisheyeRepositoryExplorer.FisheyeFileExplorerInfo)files.get(0);
        Assert.assertEquals((String)"1.6", (String)f.getLatestRevision().getRevision());
        Assert.assertTrue((boolean)f.getLatestRevision().isDead());
    }

    @Test
    public void testUseTrunkRevisionWhereAvailable() throws DbException {
        FisheyeRepositoryExplorer re = new FisheyeRepositoryExplorer(this.engine, new Path((CharSequence)"/test/support/thread1308"), null, new CookiePreferences());
        List files = re.getFiles();
        Collections.sort(files, EXP_INFO_COMPARATOR);
        Assert.assertEquals((int)2, (int)files.size());
        FisheyeRepositoryExplorer.FisheyeFileExplorerInfo f = (FisheyeRepositoryExplorer.FisheyeFileExplorerInfo)files.get(0);
        Assert.assertEquals((String)"readme", (String)f.getPath().getName());
        Assert.assertEquals((String)"1.3", (String)f.getLatestRevision().getRevision());
        Assert.assertEquals((String)"second change", (String)f.getLatestRevision().getComment().trim());
        Assert.assertFalse((boolean)f.getLatestRevision().isDead());
        f = (FisheyeRepositoryExplorer.FisheyeFileExplorerInfo)files.get(1);
        Assert.assertEquals((String)"SourceViewServlet.java", (String)f.getPath().getName());
        Assert.assertEquals((String)"2.2", (String)f.getLatestRevision().getRevision());
        Assert.assertEquals((String)"removed unused imports", (String)f.getLatestRevision().getComment().trim());
        Assert.assertFalse((boolean)f.getLatestRevision().isDead());
    }

    @Test
    public void testDeletedOnBranchButNotOnTrunk() throws DbException {
        FisheyeRepositoryExplorer re = new FisheyeRepositoryExplorer(this.engine, new Path((CharSequence)"/emptytests/empty_on_branch"), null, new CookiePreferences());
        List files = re.getFiles();
        Assert.assertEquals((int)1, (int)files.size());
        FisheyeRepositoryExplorer.FisheyeFileExplorerInfo f = (FisheyeRepositoryExplorer.FisheyeFileExplorerInfo)files.get(0);
        Assert.assertEquals((String)"c.txt", (String)f.getPath().getName());
        Assert.assertEquals((String)"1.2", (String)f.getLatestRevision().getRevision());
        Assert.assertEquals((String)"second revisions", (String)f.getLatestRevision().getComment().trim());
        Assert.assertFalse((boolean)f.getLatestRevision().isDead());
    }

    @Test
    public void testBranchConstraints() throws DbException {
        WaybackSpec wb = new WaybackSpec();
        wb.setBranch("BRANCH_2_2");
        FisheyeRepositoryExplorer re = new FisheyeRepositoryExplorer(this.engine, new Path((CharSequence)"/test/branching"), wb, new CookiePreferences());
        List files = re.getFiles();
        Assert.assertEquals((int)1, (int)files.size());
        FisheyeRepositoryExplorer.FisheyeFileExplorerInfo f = (FisheyeRepositoryExplorer.FisheyeFileExplorerInfo)files.get(0);
        Assert.assertEquals((String)"c.txt", (String)f.getPath().getName());
        Assert.assertEquals((String)"1.2.4.1.2.1", (String)f.getLatestRevision().getRevision());
        Assert.assertEquals((String)"branch on branch", (String)f.getLatestRevision().getComment().trim());
        Assert.assertFalse((boolean)f.getLatestRevision().isDead());
        wb.setBranch("BRANCH_2");
        re = new FisheyeRepositoryExplorer(this.engine, new Path((CharSequence)"/test/branching"), wb, new CookiePreferences());
        files = re.getFiles();
        Assert.assertEquals((int)1, (int)files.size());
        f = (FisheyeRepositoryExplorer.FisheyeFileExplorerInfo)files.get(0);
        Assert.assertEquals((String)"c.txt", (String)f.getPath().getName());
        Assert.assertEquals((String)"1.2.4.1", (String)f.getLatestRevision().getRevision());
        Assert.assertEquals((String)"change on branch2", (String)f.getLatestRevision().getComment().trim());
        Assert.assertFalse((boolean)f.getLatestRevision().isDead());
        wb.setBranch("BRANCH_1");
        re = new FisheyeRepositoryExplorer(this.engine, new Path((CharSequence)"/test/branching"), wb, new CookiePreferences());
        files = re.getFiles();
        Assert.assertEquals((int)4, (int)files.size());
        Collections.sort(files, EXP_INFO_COMPARATOR);
        f = (FisheyeRepositoryExplorer.FisheyeFileExplorerInfo)files.get(0);
        Assert.assertEquals((String)"a.txt", (String)f.getPath().getName());
        Assert.assertEquals((String)"1.2.2.1", (String)f.getLatestRevision().getRevision());
        Assert.assertEquals((String)"another change", (String)f.getLatestRevision().getComment().trim());
        Assert.assertFalse((boolean)f.getLatestRevision().isDead());
        f = (FisheyeRepositoryExplorer.FisheyeFileExplorerInfo)files.get(1);
        Assert.assertEquals((String)"b.txt", (String)f.getPath().getName());
        Assert.assertEquals((String)"1.2.2.1", (String)f.getLatestRevision().getRevision());
        Assert.assertEquals((String)"this is for fix1", (String)f.getLatestRevision().getComment().trim());
        Assert.assertFalse((boolean)f.getLatestRevision().isDead());
        f = (FisheyeRepositoryExplorer.FisheyeFileExplorerInfo)files.get(2);
        Assert.assertEquals((String)"c.txt", (String)f.getPath().getName());
        Assert.assertEquals((String)"1.2.2.1", (String)f.getLatestRevision().getRevision());
        Assert.assertEquals((String)"removed c.txt on branch", (String)f.getLatestRevision().getComment().trim());
        Assert.assertTrue((boolean)f.getLatestRevision().isDead());
        f = (FisheyeRepositoryExplorer.FisheyeFileExplorerInfo)files.get(3);
        Assert.assertEquals((String)"d.txt", (String)f.getPath().getName());
        Assert.assertEquals((String)"1.1.2.2", (String)f.getLatestRevision().getRevision());
        Assert.assertEquals((String)"new file on branch", (String)f.getLatestRevision().getComment().trim());
        Assert.assertFalse((boolean)f.getLatestRevision().isDead());
        wb.setBranch("NOT_A_BRANCH");
        re = new FisheyeRepositoryExplorer(this.engine, new Path((CharSequence)"/test/branching"), wb, new CookiePreferences());
        files = re.getFiles();
        Assert.assertEquals((int)0, (int)files.size());
    }

    @Test
    public void testAuthorConstraints() throws DbException {
        WaybackSpec wb = new WaybackSpec();
        wb.setAuthor("cris");
        FisheyeRepositoryExplorer re = new FisheyeRepositoryExplorer(this.engine, new Path((CharSequence)"/test/funny#dir"), wb, new CookiePreferences());
        List files = re.getFiles();
        Assert.assertEquals((int)4, (int)files.size());
        FisheyeRepositoryExplorer.FisheyeFileExplorerInfo f = (FisheyeRepositoryExplorer.FisheyeFileExplorerInfo)files.get(0);
        Assert.assertEquals((String)"dm_main.dfm", (String)f.getPath().getName());
        Assert.assertEquals((String)"1.12", (String)f.getLatestRevision().getRevision());
        Assert.assertEquals((String)"no message", (String)f.getLatestRevision().getComment().trim());
        Assert.assertFalse((boolean)f.getLatestRevision().isDead());
        wb.setAuthor("bill");
        re = new FisheyeRepositoryExplorer(this.engine, new Path((CharSequence)"/test/funny#dir"), wb, new CookiePreferences());
        files = re.getFiles();
        Assert.assertEquals((int)4, (int)files.size());
        f = (FisheyeRepositoryExplorer.FisheyeFileExplorerInfo)files.get(0);
        Assert.assertEquals((String)"dm_main.dfm", (String)f.getPath().getName());
        Assert.assertEquals((String)"1.12", (String)f.getLatestRevision().getRevision());
        Assert.assertEquals((String)"no message", (String)f.getLatestRevision().getComment().trim());
        Assert.assertFalse((boolean)f.getLatestRevision().isDead());
    }

    @Test
    public void testDateConstraint() throws Exception {
        WaybackSpec wb = new WaybackSpec();
        this.setWbSpecDate(wb, "2004-08-25T00:00:00Z");
        FisheyeRepositoryExplorer re = new FisheyeRepositoryExplorer(this.engine, new Path((CharSequence)"/test/funny#dir"), wb, new CookiePreferences());
        List files = re.getFiles();
        Assert.assertEquals((int)4, (int)files.size());
        Collections.sort(files, EXP_INFO_COMPARATOR);
        FisheyeRepositoryExplorer.FisheyeFileExplorerInfo f = (FisheyeRepositoryExplorer.FisheyeFileExplorerInfo)files.get(0);
        Assert.assertEquals((String)"dm_main.dfm", (String)f.getPath().getName());
        Assert.assertEquals((String)"1.12", (String)f.getLatestRevision().getRevision());
        Assert.assertEquals((String)"no message", (String)f.getLatestRevision().getComment().trim());
        Assert.assertFalse((boolean)f.getLatestRevision().isDead());
        f = (FisheyeRepositoryExplorer.FisheyeFileExplorerInfo)files.get(2);
        Assert.assertEquals((String)"file.txt", (String)f.getPath().getName());
        Assert.assertEquals((String)"1.6", (String)f.getLatestRevision().getRevision());
        Assert.assertEquals((String)"remove training NL", (String)f.getLatestRevision().getComment().trim());
        Assert.assertFalse((boolean)f.getLatestRevision().isDead());
        f = (FisheyeRepositoryExplorer.FisheyeFileExplorerInfo)files.get(3);
        Assert.assertEquals((String)"ss.png", (String)f.getPath().getName());
        Assert.assertEquals((String)"1.2", (String)f.getLatestRevision().getRevision());
        Assert.assertEquals((String)"nochange", (String)f.getLatestRevision().getComment().trim());
        Assert.assertFalse((boolean)f.getLatestRevision().isDead());
    }

    private void setWbSpecDate(WaybackSpec wb, String aug24) throws Exception {
        wb.setDateStr(aug24);
        wb.setDate(ISO8601DateHelper.parseAsUTC((String)aug24).getTime());
    }
}

