/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.it.web;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.EntityLink;
import com.atlassian.applinks.api.EntityLinkService;
import com.atlassian.applinks.api.application.jira.JiraProjectEntityType;
import com.cenqua.crucible.util.DummyEntityLinkService;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.cvsrep.RepSanityTestBase;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.web.util.CheckinCommentFormatter;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Date;
import junit.framework.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public final class CheckinCommentFormatterTest
extends RepSanityTestBase {
    private RepositoryHandle handle;

    @Override
    protected RepositoryHandle whichHandle() throws Exception {
        this.handle = TestFishEyeInstances.getSanity1Repos();
        return this.handle;
    }

    @Test
    public void testCheckinCommentFormatterAutolinksJiraIssueKey() throws Exception {
        URI baseUri = new URI("http://jira.example.com");
        ApplicationLink applicationLinkMock = (ApplicationLink)Mockito.mock(ApplicationLink.class);
        Mockito.when((Object)applicationLinkMock.getDisplayUrl()).thenReturn((Object)baseUri);
        EntityLink entityLinkMock = (EntityLink)Mockito.mock(EntityLink.class);
        Mockito.when((Object)entityLinkMock.getApplicationLink()).thenReturn((Object)applicationLinkMock);
        Mockito.when((Object)entityLinkMock.getKey()).thenReturn((Object)"CLOV");
        EntityLinkService entityLinkServiceMock = (EntityLinkService)Mockito.mock(EntityLinkService.class);
        Mockito.when((Object)entityLinkServiceMock.getEntityLinks(Mockito.any(RepositoryHandle.class), (Class)Mockito.eq(JiraProjectEntityType.class))).thenReturn((Object)ImmutableSet.of((Object)entityLinkMock));
        EntityLinkService entityLinkService = this.getEntityLinkService();
        ((DummyEntityLinkService)entityLinkService).setDelegate(entityLinkServiceMock);
        Assert.assertEquals((String)"<p><span class=\"jira-hover-trigger\"><a href=\"http://jira.example.com/browse/CLOV-123\">CLOV-123</a></span>:</p>", (String)CheckinCommentFormatter.format((RepositoryConfig)this.handle.getCfg(), (String)"CLOV-123:", (Date)new Date()));
    }

    private EntityLinkService getEntityLinkService() {
        return (EntityLinkService)SpringContext.getComponentByClass(EntityLinkService.class);
    }
}

