/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.it.web;

import com.atlassian.fisheye.activity.ActivityItem;
import com.atlassian.fisheye.branch.BranchPreferenceHandler;
import com.atlassian.fisheye.spi.services.CommitterDataService;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.cvsrep.RepSanityTestBase;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.ChangeSetHolder;
import com.cenqua.fisheye.web.ChangelogServlet;
import com.cenqua.fisheye.web.FishEyePathInfo;
import com.cenqua.fisheye.web.filters.DummyHttpServletRequest;
import com.cenqua.fisheye.web.filters.DummyHttpServletResponse;
import com.cenqua.fisheye.web.parameterbeans.BaseActionParams;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public final class ChangelogServletSanity1Test
extends RepSanityTestBase {
    private BaseActionParams mockedActionParams;
    private ChangelogServletDummyRequest mockedRequest;
    private ChangelogServletDummyResponse mockedResponse;
    private MockedOutChangelogServlet changelogServlet;
    private UserManager userManager;
    private BranchPreferenceHandler branchPreferenceHandler;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.userManager = (UserManager)SpringContext.getComponentByClass(UserManager.class);
        this.branchPreferenceHandler = (BranchPreferenceHandler)SpringContext.getComponentByClass(BranchPreferenceHandler.class);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        HibernateUtil.closeSession();
        super.tearDown();
    }

    @Override
    protected RepositoryHandle whichHandle() throws Exception {
        return TestFishEyeInstances.getSanity1Repos();
    }

    @Test
    public void testChangelogShowIdMode() throws IOException, DbException, ServletException {
        String validChangeSetId = "MAIN:brendan:20041014145930";
        this.changelogServlet = new MockedOutChangelogServlet();
        this.mockedActionParams = new MockedBaseActionParams(this.engine);
        this.mockedRequest = new ChangelogServletDummyRequest(new LinkedHashMap<String, String>(){
            {
                this.put("showid", "MAIN:brendan:20041014145930");
            }
        }, "/WEB-INF/jsp/changelogdir.jsp");
        this.mockedResponse = new ChangelogServletDummyResponse();
        this.changelogServlet.setupInternal(this.changelogServlet.getPathInfo(), this.mockedRequest, this.mockedResponse, null, this.mockedActionParams);
        this.changelogServlet.processRequest(this.mockedActionParams);
        Assert.assertFalse((boolean)this.mockedResponse.hasError());
        Assert.assertTrue((boolean)this.mockedRequest.hasPerformedJspDispatch());
        List activityItems = (List)this.mockedRequest.getAttributeMap().get("activityItems");
        Assert.assertEquals((String)"MAIN:brendan:20041014145930", (String)((ChangeSetHolder)activityItems.get(0)).getChangeset().getId());
        String invalidChangeSetId = "INVALID_CHANGESET_ID";
        this.changelogServlet = new MockedOutChangelogServlet();
        this.mockedActionParams = new MockedBaseActionParams(this.engine);
        this.mockedRequest = new ChangelogServletDummyRequest(new LinkedHashMap<String, String>(){
            {
                this.put("showid", "INVALID_CHANGESET_ID");
            }
        }, null);
        this.mockedResponse = new ChangelogServletDummyResponse();
        this.changelogServlet.setupInternal(this.changelogServlet.getPathInfo(), this.mockedRequest, this.mockedResponse, null, this.mockedActionParams);
        this.changelogServlet.processRequest(this.mockedActionParams);
        Assert.assertFalse((boolean)this.mockedResponse.hasError());
        Assert.assertTrue((boolean)this.mockedRequest.hasPerformedJspDispatch());
        activityItems = (List)this.mockedRequest.getAttributeMap().get("activityItems");
        Assert.assertTrue((activityItems.size() > 0 ? 1 : 0) != 0);
        for (ActivityItem activityItem : activityItems) {
            ChangeSet changeSet = ((ChangeSetHolder)activityItem).getChangeset();
            Assert.assertFalse((boolean)changeSet.getId().equals("INVALID_CHANGESET_ID"));
        }
    }

    private static class MockedBaseActionParams
    extends BaseActionParams {
        private MockedBaseActionParams(RepositoryEngine engine) {
            super(engine);
        }
    }

    private static class DummyRequestDispatcher
    implements RequestDispatcher {
        private DummyRequestDispatcher() {
        }

        public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        }

        public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        }
    }

    private static class ChangelogServletDummyResponse
    extends DummyHttpServletResponse {
        private int error;
        private String errorMsg;
        private boolean hasError;

        private ChangelogServletDummyResponse() {
        }

        @Override
        public void sendError(int i, String s) throws IOException {
            this.error = i;
            this.errorMsg = s;
            this.hasError = true;
        }

        public int getError() {
            return this.error;
        }

        public String getErrorMsg() {
            return this.errorMsg;
        }

        public boolean hasError() {
            return this.hasError;
        }
    }

    private static class ChangelogServletDummyRequest
    extends DummyHttpServletRequest {
        private boolean hasDispatchedJsp;
        private Map<String, String> possibleParams;
        private String jspFile;
        private Map<String, Object> attr = new HashMap<String, Object>();

        public ChangelogServletDummyRequest(Map requestMap, String jspFile) {
            this.possibleParams = requestMap;
            this.jspFile = jspFile;
        }

        @Override
        public String getRequestURI() {
            return "";
        }

        @Override
        public String getContextPath() {
            return "";
        }

        @Override
        public String getServletPath() {
            return "";
        }

        @Override
        public String getParameter(String key) {
            if (!this.possibleParams.containsKey(key)) {
                Logs.APP_LOG.error((Object)("key=" + key));
            }
            if (this.possibleParams.get(key) == null) {
                Logs.APP_LOG.error((Object)("null value for key " + key));
            }
            return this.possibleParams.get(key);
        }

        @Override
        public void setAttribute(String k, Object val) {
            this.attr.put(k, val);
        }

        @Override
        public RequestDispatcher getRequestDispatcher(String string) {
            this.hasDispatchedJsp = this.jspFile == null ? true : this.jspFile.equals(string);
            return new DummyRequestDispatcher();
        }

        public boolean hasPerformedJspDispatch() {
            return this.hasDispatchedJsp;
        }

        public Map getAttributeMap() {
            return this.attr;
        }
    }

    private class MockedOutChangelogServlet
    extends ChangelogServlet {
        private MockedOutChangelogServlet() {
            this.committerDataService = (CommitterDataService)Mockito.mock(CommitterDataService.class);
        }

        public HttpServletRequest getRequest() {
            return ChangelogServletSanity1Test.this.mockedRequest;
        }

        public HttpServletResponse getResponse() {
            return ChangelogServletSanity1Test.this.mockedResponse;
        }

        public boolean requiresAuth() {
            return false;
        }

        protected UserManager getUserManager() {
            return ChangelogServletSanity1Test.this.userManager;
        }

        public FishEyePathInfo getPathInfo() {
            return new FishEyePathInfo(ChangelogServletSanity1Test.this.mockedRequest){

                public RepositoryEngine getEngine() {
                    return ChangelogServletSanity1Test.this.engine;
                }
            };
        }

        public void setupInternal(FishEyePathInfo pi, HttpServletRequest req, HttpServletResponse res, ServletContext sctx, BaseActionParams params) {
            super.setupInternal(pi, req, res, sctx, params);
        }

        protected BranchPreferenceHandler getBranchPreferenceHandler() {
            return ChangelogServletSanity1Test.this.branchPreferenceHandler;
        }
    }
}

