/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.it.util;

import com.cenqua.fisheye.util.LongLockMap;
import junit.framework.TestCase;

public class LongLockMapTest
extends TestCase {
    LongLockMap locks = new LongLockMap();

    public void testSimple() throws Exception {
        long ts = 1000L;
        LongLockMapTest.assertTrue((boolean)this.locks.attempt(1L, ts));
        LongLockMapTest.assertTrue((boolean)this.locks.attempt(1L, ts));
        LongLockMapTest.assertTrue((boolean)this.locks.attempt(2L, ts));
        this.locks.release(1L);
        this.locks.release(2L);
        this.locks.release(1L);
    }

    public void testAttemptFails() throws Exception {
        long ts = 1000L;
        LongLockMapTest.assertTrue((boolean)this.locks.attempt(1L, 1000L));
        this.subtestInOtherThread(false, 1, 1000L);
        this.locks.release(1L);
        this.subtestInOtherThread(true, 1, 1000L);
    }

    public void testBlockThenRelease() throws Exception {
        this.locks.acquire(1L);
        int longTS = 10000;
        AttemptInThread t = new AttemptInThread(1L, longTS);
        t.start();
        Thread.sleep(1000L);
        this.locks.release(1L);
        t.join(longTS);
        LongLockMapTest.assertTrue((boolean)t.finishedRun);
        LongLockMapTest.assertTrue((boolean)t.grabbed);
        LongLockMapTest.assertFalse((boolean)t.sawException);
    }

    private void subtestInOtherThread(boolean expectSuccess, int id, long ts) throws InterruptedException {
        AttemptInThread t = new AttemptInThread(id, ts);
        t.start();
        t.join();
        LongLockMapTest.assertTrue((boolean)t.finishedRun);
        LongLockMapTest.assertEquals((boolean)expectSuccess, (boolean)t.grabbed);
        LongLockMapTest.assertFalse((boolean)t.sawException);
    }

    class AttemptInThread
    extends Thread {
        final long id;
        final long ts;
        boolean finishedRun = false;
        boolean grabbed = false;
        boolean sawException = false;

        public AttemptInThread(long id, long ts) {
            this.id = id;
            this.ts = ts;
        }

        @Override
        public void run() {
            try {
                this.grabbed = LongLockMapTest.this.locks.attempt(this.id, this.ts);
            }
            catch (InterruptedException e) {
                this.sawException = true;
            }
            finally {
                this.finishedRun = true;
            }
        }
    }
}

