/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.it.user.action;

import com.atlassian.fecru.user.UserPermissionsTestRule;
import com.atlassian.fisheye.activity.ActivitySearchMonitor;
import com.atlassian.fisheye.user.action.userlistgenerator.GlobalUserListGenerator;
import com.atlassian.fisheye.user.action.userlistgenerator.RepUserListGenerator;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.model.CommitterUserMapping;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.web.FishEyePathInfo;
import com.cenqua.fisheye.web.TableDisplayData;
import com.cenqua.fisheye.web.util.RepositoryUtil;
import java.util.Collections;
import java.util.List;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class UserListGeneratorTest {
    private CommitterUserMappingManager committerMappingManager;
    private UserManager userManager;
    private RepositoryManager repManager;
    private ReviewManager reviewManager;
    private UserPermissionsTestRule userPermissionsTestRule;

    @Before
    public void setUp() throws Exception {
        Disposer.pushThreadInstance();
        TestFishEyeInstances.loadSanity1();
        this.committerMappingManager = (CommitterUserMappingManager)SpringContext.getComponentByClass(CommitterUserMappingManager.class);
        this.userManager = (UserManager)SpringContext.getComponentByClass(UserManager.class);
        this.repManager = (RepositoryManager)SpringContext.getComponentByClass(RepositoryManager.class);
        this.reviewManager = (ReviewManager)SpringContext.getComponentByClass(ReviewManager.class);
        this.userPermissionsTestRule = (UserPermissionsTestRule)((Object)SpringContext.createComponent(UserPermissionsTestRule.class));
        this.userPermissionsTestRule.before();
    }

    @After
    public void tearDown() throws Exception {
        this.userPermissionsTestRule.after();
        HibernateUtil.closeSession();
        Disposer.popThreadInstance();
        TestFishEyeInstances.stop();
    }

    @Test
    public void testGenerator() throws Exception {
        for (String user : this.userManager.getAllEnabledUsernames()) {
            this.userManager.deleteUserFully(user);
        }
        for (CommitterUserMapping mapping : this.committerMappingManager.findAll()) {
            this.committerMappingManager.delete(mapping.getUserName(), mapping.getRepositoryName(), mapping.getCommitterName());
        }
        TableDisplayData.ColumnComparators sortMethod = TableDisplayData.ColumnComparators.DISPLAY_NAME;
        ActivitySearchMonitor monitor = new ActivitySearchMonitor();
        Principal.Anonymous currentUser = Principal.Anonymous.ANON;
        FishEyePathInfo pi = new FishEyePathInfo((String)null);
        List<RepositoryHandle> reps = RepositoryUtil.repositories((Principal)currentUser);
        GlobalUserListGenerator generator = new GlobalUserListGenerator(this.reviewManager, this.userManager, this.committerMappingManager, monitor, (Principal)currentUser, (List)reps, false);
        List people = generator.getEveryone();
        generator.completeUserData(people);
        Collections.sort(people, sortMethod.getComp(false));
        Assert.assertEquals((int)0, (int)people.size());
        pi = new FishEyePathInfo("cvs");
        RepositoryHandle handle = this.repManager.getRepository("cvs");
        reps = Collections.singletonList(handle);
        pi.initEngine(handle);
        generator = new RepUserListGenerator(this.reviewManager, this.userManager, this.committerMappingManager, monitor, (Principal)currentUser, pi, reps, false);
        people = generator.getEveryone();
        generator.completeUserData(people);
        Collections.sort(people, sortMethod.getComp(false));
        Assert.assertEquals((int)21, (int)people.size());
        String username = "testuser";
        this.userPermissionsTestRule.addFisheyeUser("testuser", "Conor MacNeill", "conor@conor");
        this.committerMappingManager.addMapping("testuser", "cvs", "conor");
        generator = new RepUserListGenerator(this.reviewManager, this.userManager, this.committerMappingManager, monitor, (Principal)currentUser, pi, reps, false);
        people = generator.getEveryone();
        generator.completeUserData(people);
        Collections.sort(people, sortMethod.getComp(false));
        Assert.assertEquals((int)21, (int)people.size());
        this.committerMappingManager.addMapping("testuser", "cvs", "matt");
        generator = new RepUserListGenerator(this.reviewManager, this.userManager, this.committerMappingManager, monitor, (Principal)currentUser, pi, reps, false);
        people = generator.getEveryone();
        generator.completeUserData(people);
        Collections.sort(people, sortMethod.getComp(false));
        Assert.assertEquals((int)20, (int)people.size());
        this.userManager.deleteUserFully("testuser");
    }
}

