/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.it.user;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.test.UserPrincipal;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.event.UserRenamedEvent;
import com.atlassian.fisheye.user.DefaultRecentlyVisitedManager;
import com.atlassian.fisheye.user.model.RecentlyVisitedItem;
import com.atlassian.fisheye.user.model.RecentlyVisitedItemFactory;
import com.atlassian.fisheye.user.model.RecentlyVisitedProject;
import com.atlassian.fisheye.user.model.RecentlyVisitedProjectFactory;
import com.atlassian.fisheye.user.model.RecentlyVisitedRepositoryFactory;
import com.atlassian.fisheye.user.model.RecentlyVisitedReview;
import com.atlassian.fisheye.user.model.RecentlyVisitedReviewFactory;
import com.atlassian.fisheye.user.model.RecentlyVisitedSnippetFactory;
import com.atlassian.fisheye.user.model.RecentlyVisitedUserFactory;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.crucible.hibernate.HibernateUtilCurrentSessionProvider;
import com.cenqua.crucible.model.PermaIdFormatException;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.util.DummyReviewManager;
import com.cenqua.dbutils.ModelUtils;
import com.cenqua.fisheye.config.DummyRepositoryManager;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.DummyUserManager;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.admin.actions.jira.DummyProjectManager;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class RecentlyVisitedManagerTest {
    protected DefaultRecentlyVisitedManager uhm;
    private ModelUtils mu;

    @Before
    public void setUp() throws Exception {
        this.mu = new ModelUtils();
        this.mu.createBlankDB();
        this.uhm = new DefaultRecentlyVisitedManager(MoreExecutors.directExecutor(), (CurrentSessionProvider)new HibernateUtilCurrentSessionProvider(), (EventPublisher)Mockito.mock(EventPublisher.class));
        ArrayList<Object> factories = new ArrayList<Object>();
        DummyProjectManager projectManager = new DummyProjectManager(){

            @Override
            public Project getProjectByKey(String key) {
                Project p = new Project();
                p.setProjKey(key);
                return p;
            }
        };
        DummyRepositoryManager repositoryManager = new DummyRepositoryManager(){

            @Override
            public RepositoryHandle getRepository(String name) {
                return new RepositoryHandle(name, null, null, null);
            }
        };
        DummyReviewManager reviewManager = new DummyReviewManager(){

            @Override
            public Review getReviewByPermaId(final String permaId) throws PermaIdFormatException {
                return new Review(){

                    public String getPermaId() {
                        return permaId;
                    }

                    public Project getProject() {
                        return new Project(){

                            public PermissionScheme getPermissionScheme() {
                                return new PermissionScheme();
                            }
                        };
                    }
                };
            }
        };
        DummyUserManager userManager = new DummyUserManager(){

            @Override
            public FecruUser getLicensedUser(String username) {
                return new FecruUser(username);
            }

            @Override
            public boolean hasPermissionToAccess(Principal user, RepositoryHandle handle) {
                return true;
            }
        };
        PermissionManager permissionManager = (PermissionManager)Mockito.mock(PermissionManager.class);
        Mockito.when((Object)permissionManager.isProjectVisible((Principal)Mockito.any(Principal.class), (Project)Mockito.any(Project.class))).thenReturn((Object)true);
        Mockito.when((Object)permissionManager.canPrincipalDoAction((PermissionScheme)Mockito.any(PermissionScheme.class), (Principal)Mockito.any(Principal.class), (FecruUser)Mockito.any(FecruUser.class), Mockito.anyString(), (Review)Mockito.any(Review.class))).thenReturn((Object)true);
        factories.add(new RecentlyVisitedProjectFactory((ProjectManager)projectManager, permissionManager));
        factories.add(new RecentlyVisitedRepositoryFactory((RepositoryManager)repositoryManager, (UserManager)userManager));
        factories.add(new RecentlyVisitedReviewFactory((ReviewManager)reviewManager, permissionManager));
        factories.add(new RecentlyVisitedSnippetFactory((ReviewManager)reviewManager, permissionManager));
        factories.add(new RecentlyVisitedUserFactory((UserManager)userManager));
        this.uhm.setFactories(factories.toArray(new RecentlyVisitedItemFactory[factories.size()]));
    }

    @After
    public void tearDown() throws Exception {
        this.mu.destroyDB();
    }

    @Test
    public void testAddItemToHistory() throws Exception {
        UserPrincipal user = new UserPrincipal("seb", null);
        this.addItemToHistory(RecentlyVisitedItem.Type.PROJECT, (Principal)user, "CR-FE");
        List history = this.uhm.getAllHistory(user.getUserName());
        Assert.assertNotNull((String)"History items should not be null", (Object)history);
        Assert.assertEquals((String)"There should be one history item", (long)1L, (long)history.size());
        RecentlyVisitedItem historyItem = (RecentlyVisitedItem)history.get(0);
        Assert.assertTrue((String)"History item should be of 'RecentlyVisitedProject' class", (boolean)(historyItem instanceof RecentlyVisitedProject));
        Assert.assertEquals((String)"History item entityId is CR-FE", (Object)"CR-FE", (Object)historyItem.getEntityId());
        Assert.assertEquals((String)"History item username is seb", (Object)"seb", (Object)historyItem.getUsername());
        this.addItemToHistory(RecentlyVisitedItem.Type.REVIEW, (Principal)user, "CR-FE-1");
        history = this.uhm.getAllHistory(user.getUserName());
        Assert.assertNotNull((String)"History items should not be null", (Object)history);
        Assert.assertEquals((String)"There should be two history items", (long)2L, (long)history.size());
        historyItem = (RecentlyVisitedItem)history.get(0);
        Assert.assertTrue((String)"History item should be of 'RecentlyVisitedReview' class", (boolean)(historyItem instanceof RecentlyVisitedReview));
        Assert.assertEquals((String)"History item entityId is correct", (Object)"CR-FE-1", (Object)historyItem.getEntityId());
        Assert.assertEquals((String)"History item user is seb", (Object)"seb", (Object)historyItem.getUsername());
    }

    private void addItemToHistory(RecentlyVisitedItem.Type type, Principal principal, String value) throws InterruptedException {
        this.uhm.addItemToHistory(type, principal != null ? new FecruUser(principal.getUserName()) : null, value);
        Thread.sleep(50L);
    }

    @Test
    public void testGetHistoryIsOrdered() throws Exception {
        UserPrincipal seb = new UserPrincipal("seb", null);
        this.addItemToHistory(RecentlyVisitedItem.Type.PROJECT, (Principal)seb, "CR-FE");
        this.addItemToHistory(RecentlyVisitedItem.Type.PROJECT, (Principal)seb, "CR-CLOV");
        this.addItemToHistory(RecentlyVisitedItem.Type.PROJECT, (Principal)seb, "CR-CRUC");
        List items = this.uhm.getHistory(RecentlyVisitedItem.Type.PROJECT, (Principal)seb);
        Assert.assertNotNull((Object)items);
        Assert.assertEquals((long)3L, (long)items.size());
        Assert.assertTrue((String)"Zeroeth history item should be more recent than the first", (((RecentlyVisitedItem)items.get(0)).getLastViewed() > ((RecentlyVisitedItem)items.get(1)).getLastViewed() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Zeroeth history item should be more recent than the second", (((RecentlyVisitedItem)items.get(0)).getLastViewed() > ((RecentlyVisitedItem)items.get(2)).getLastViewed() ? 1 : 0) != 0);
        Assert.assertTrue((String)"First history item should be more recent than the second", (((RecentlyVisitedItem)items.get(1)).getLastViewed() > ((RecentlyVisitedItem)items.get(2)).getLastViewed() ? 1 : 0) != 0);
    }

    @Test
    public void testHistoryThresholding() throws Exception {
        UserPrincipal seb = new UserPrincipal("seb", null);
        this.addItemToHistory(RecentlyVisitedItem.Type.REVIEW, (Principal)seb, "CR-FE-1");
        this.addItemToHistory(RecentlyVisitedItem.Type.REVIEW, (Principal)seb, "CR-FE-2");
        this.addItemToHistory(RecentlyVisitedItem.Type.REVIEW, (Principal)seb, "CR-FE-3");
        this.addItemToHistory(RecentlyVisitedItem.Type.REVIEW, (Principal)seb, "CR-FE-4");
        this.addItemToHistory(RecentlyVisitedItem.Type.REVIEW, (Principal)seb, "CR-FE-5");
        this.addItemToHistory(RecentlyVisitedItem.Type.REVIEW, (Principal)seb, "CR-FE-6");
        this.addItemToHistory(RecentlyVisitedItem.Type.REVIEW, (Principal)seb, "CR-FE-7");
        this.addItemToHistory(RecentlyVisitedItem.Type.REVIEW, (Principal)seb, "CR-FE-8");
        List history = this.uhm.getHistory(RecentlyVisitedItem.Type.REVIEW, (Principal)seb);
        Assert.assertNotNull((Object)history);
        Assert.assertEquals((String)"Should have five review history items", (long)5L, (long)history.size());
        Assert.assertEquals((Object)"CR-FE-8", (Object)((RecentlyVisitedItem)history.get(0)).getEntityId());
        Assert.assertEquals((Object)"CR-FE-7", (Object)((RecentlyVisitedItem)history.get(1)).getEntityId());
        Assert.assertEquals((Object)"CR-FE-6", (Object)((RecentlyVisitedItem)history.get(2)).getEntityId());
        Assert.assertEquals((Object)"CR-FE-5", (Object)((RecentlyVisitedItem)history.get(3)).getEntityId());
        Assert.assertEquals((Object)"CR-FE-4", (Object)((RecentlyVisitedItem)history.get(4)).getEntityId());
    }

    @Test
    public void testGetHistory() throws Exception {
        UserPrincipal seb = new UserPrincipal("seb", null);
        UserPrincipal adam = new UserPrincipal("adam", null);
        this.addItemToHistory(RecentlyVisitedItem.Type.PROJECT, (Principal)seb, "CR-FE");
        this.addItemToHistory(RecentlyVisitedItem.Type.PROJECT, (Principal)seb, "CR-CLOV");
        this.addItemToHistory(RecentlyVisitedItem.Type.PROJECT, (Principal)seb, "CR-CRUC");
        this.addItemToHistory(RecentlyVisitedItem.Type.REVIEW, (Principal)seb, "CR-FE-1");
        this.addItemToHistory(RecentlyVisitedItem.Type.REVIEW, (Principal)seb, "CR-FE-2");
        this.addItemToHistory(RecentlyVisitedItem.Type.REVIEW, (Principal)seb, "CR-FE-3");
        this.addItemToHistory(RecentlyVisitedItem.Type.REVIEW, (Principal)seb, "CR-FE-4");
        this.addItemToHistory(RecentlyVisitedItem.Type.REVIEW, (Principal)seb, "CR-FE-5");
        this.addItemToHistory(RecentlyVisitedItem.Type.REVIEW, (Principal)seb, "CR-FE-6");
        this.addItemToHistory(RecentlyVisitedItem.Type.REVIEW, (Principal)seb, "CR-FE-7");
        this.addItemToHistory(RecentlyVisitedItem.Type.REVIEW, (Principal)seb, "CR-FE-8");
        this.addItemToHistory(RecentlyVisitedItem.Type.SNIPPET, (Principal)seb, "CR-FE-2");
        this.addItemToHistory(RecentlyVisitedItem.Type.SNIPPET, (Principal)seb, "CR-FE-3");
        this.addItemToHistory(RecentlyVisitedItem.Type.REPOSITORY, (Principal)seb, "FE");
        this.addItemToHistory(RecentlyVisitedItem.Type.REPOSITORY, (Principal)seb, "CLOV");
        this.addItemToHistory(RecentlyVisitedItem.Type.REPOSITORY, (Principal)seb, "CRUC");
        this.addItemToHistory(RecentlyVisitedItem.Type.REPOSITORY, (Principal)seb, "CRUM");
        this.addItemToHistory(RecentlyVisitedItem.Type.USER, (Principal)seb, "seb");
        this.addItemToHistory(RecentlyVisitedItem.Type.USER, (Principal)seb, "adam");
        this.addItemToHistory(RecentlyVisitedItem.Type.USER, (Principal)seb, "joe");
        this.addItemToHistory(RecentlyVisitedItem.Type.USER, (Principal)seb, "jason");
        this.addItemToHistory(RecentlyVisitedItem.Type.USER, (Principal)seb, "craig");
        this.addItemToHistory(RecentlyVisitedItem.Type.USER, (Principal)seb, "jake");
        Assert.assertEquals((String)"Seb should have three project history items", (long)3L, (long)this.uhm.getHistory(RecentlyVisitedItem.Type.PROJECT, (Principal)seb).size());
        Assert.assertEquals((String)"Seb should have five review history items", (long)5L, (long)this.uhm.getHistory(RecentlyVisitedItem.Type.REVIEW, (Principal)seb).size());
        Assert.assertEquals((String)"Seb should have two snippet history items", (long)2L, (long)this.uhm.getHistory(RecentlyVisitedItem.Type.SNIPPET, (Principal)seb).size());
        Assert.assertEquals((String)"Seb should have four repository history items", (long)4L, (long)this.uhm.getHistory(RecentlyVisitedItem.Type.REPOSITORY, (Principal)seb).size());
        Assert.assertEquals((String)"Seb should have five user history items", (long)5L, (long)this.uhm.getHistory(RecentlyVisitedItem.Type.USER, (Principal)seb).size());
        Assert.assertEquals((String)"Adam should have zero project history items", (long)0L, (long)this.uhm.getHistory(RecentlyVisitedItem.Type.PROJECT, (Principal)adam).size());
        Assert.assertEquals((String)"Adam should have zero review history items", (long)0L, (long)this.uhm.getHistory(RecentlyVisitedItem.Type.REVIEW, (Principal)adam).size());
        Assert.assertEquals((String)"Adam should have zero snippet history items", (long)0L, (long)this.uhm.getHistory(RecentlyVisitedItem.Type.SNIPPET, (Principal)adam).size());
        Assert.assertEquals((String)"Adam should have zero repository history items", (long)0L, (long)this.uhm.getHistory(RecentlyVisitedItem.Type.REPOSITORY, (Principal)adam).size());
        Assert.assertEquals((String)"Adam should have zero user history items", (long)0L, (long)this.uhm.getHistory(RecentlyVisitedItem.Type.USER, (Principal)adam).size());
        this.addItemToHistory(RecentlyVisitedItem.Type.PROJECT, (Principal)adam, "CR-FE");
        this.addItemToHistory(RecentlyVisitedItem.Type.PROJECT, (Principal)adam, "CR-BAM");
        this.addItemToHistory(RecentlyVisitedItem.Type.REVIEW, (Principal)adam, "CR-FE-203");
        this.addItemToHistory(RecentlyVisitedItem.Type.REPOSITORY, (Principal)adam, "ADAM");
        this.addItemToHistory(RecentlyVisitedItem.Type.USER, (Principal)adam, seb.getUserName());
        Assert.assertEquals((String)"Seb should have three project history items", (long)3L, (long)this.uhm.getHistory(RecentlyVisitedItem.Type.PROJECT, (Principal)seb).size());
        Assert.assertEquals((String)"Seb should have five review history items", (long)5L, (long)this.uhm.getHistory(RecentlyVisitedItem.Type.REVIEW, (Principal)seb).size());
        Assert.assertEquals((String)"Seb should have two snippet history items", (long)2L, (long)this.uhm.getHistory(RecentlyVisitedItem.Type.SNIPPET, (Principal)seb).size());
        Assert.assertEquals((String)"Seb should have four repository history items", (long)4L, (long)this.uhm.getHistory(RecentlyVisitedItem.Type.REPOSITORY, (Principal)seb).size());
        Assert.assertEquals((String)"Seb should have five user history items", (long)5L, (long)this.uhm.getHistory(RecentlyVisitedItem.Type.USER, (Principal)seb).size());
        Assert.assertEquals((String)"Adam should have two project history items", (long)2L, (long)this.uhm.getHistory(RecentlyVisitedItem.Type.PROJECT, (Principal)adam).size());
        Assert.assertEquals((String)"Adam should have one review history item", (long)1L, (long)this.uhm.getHistory(RecentlyVisitedItem.Type.REVIEW, (Principal)adam).size());
        Assert.assertEquals((String)"Adam should have zero snippet history items", (long)0L, (long)this.uhm.getHistory(RecentlyVisitedItem.Type.SNIPPET, (Principal)adam).size());
        Assert.assertEquals((String)"Adam should have one repository history item", (long)1L, (long)this.uhm.getHistory(RecentlyVisitedItem.Type.REPOSITORY, (Principal)adam).size());
        Assert.assertEquals((String)"Adam should have one user history item", (long)1L, (long)this.uhm.getHistory(RecentlyVisitedItem.Type.USER, (Principal)adam).size());
    }

    @Test
    public void testIdenticalHistoryItems() throws Exception {
        UserPrincipal seb = new UserPrincipal("seb", null);
        this.addItemToHistory(RecentlyVisitedItem.Type.PROJECT, (Principal)seb, "CR-FE");
        List recentlyVisitedItems = this.uhm.getHistory(RecentlyVisitedItem.Type.PROJECT, (Principal)seb);
        Assert.assertNotNull((Object)recentlyVisitedItems);
        Assert.assertEquals((long)1L, (long)recentlyVisitedItems.size());
        Long lastViewed = ((RecentlyVisitedItem)recentlyVisitedItems.get(0)).getLastViewed();
        this.addItemToHistory(RecentlyVisitedItem.Type.PROJECT, (Principal)seb, "CR-FE");
        recentlyVisitedItems = this.uhm.getHistory(RecentlyVisitedItem.Type.PROJECT, (Principal)seb);
        Assert.assertNotNull((Object)recentlyVisitedItems);
        Assert.assertEquals((String)"There should be only one history item", (long)1L, (long)recentlyVisitedItems.size());
        Long newerLastViewed = ((RecentlyVisitedItem)recentlyVisitedItems.get(0)).getLastViewed();
        Assert.assertTrue((String)"New history item should have a newer last viewed date", (newerLastViewed > lastViewed ? 1 : 0) != 0);
        lastViewed = newerLastViewed;
        this.addItemToHistory(RecentlyVisitedItem.Type.PROJECT, (Principal)seb, "CR-FE");
        recentlyVisitedItems = this.uhm.getHistory(RecentlyVisitedItem.Type.PROJECT, (Principal)seb);
        Assert.assertNotNull((Object)recentlyVisitedItems);
        Assert.assertEquals((String)"There should be only one history item", (long)1L, (long)recentlyVisitedItems.size());
        newerLastViewed = ((RecentlyVisitedItem)recentlyVisitedItems.get(0)).getLastViewed();
        Assert.assertTrue((String)"New history item should have a newer last viewed date", (newerLastViewed > lastViewed ? 1 : 0) != 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullEntityIdAddition() throws Exception {
        this.addItemToHistory(RecentlyVisitedItem.Type.PROJECT, (Principal)new UserPrincipal("seb", null), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmptyEntityIdAddition() throws Exception {
        this.addItemToHistory(RecentlyVisitedItem.Type.PROJECT, (Principal)new UserPrincipal("seb", null), "");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullUserAddition() throws Exception {
        this.addItemToHistory(RecentlyVisitedItem.Type.PROJECT, null, "CR");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullTypeAddition() throws Exception {
        this.addItemToHistory(null, (Principal)new UserPrincipal("seb", null), "CR");
    }

    @Test
    public void testRemoveHistoryForUser() throws Exception {
        UserPrincipal user = new UserPrincipal("seb", null);
        this.addItemToHistory(RecentlyVisitedItem.Type.PROJECT, (Principal)user, "CR-FE");
        this.addItemToHistory(RecentlyVisitedItem.Type.REVIEW, (Principal)user, "CR-FE-1");
        this.addItemToHistory(RecentlyVisitedItem.Type.REPOSITORY, (Principal)user, "FE");
        this.addItemToHistory(RecentlyVisitedItem.Type.USER, (Principal)user, "seb");
        List history = this.uhm.getAllHistory(user.getUserName());
        Assert.assertNotNull((String)"History items should not be null", (Object)history);
        Assert.assertEquals((String)"There should be four history items", (long)4L, (long)history.size());
        this.uhm.removeHistoryForUser(user.getUserName());
        history = this.uhm.getAllHistory(user.getUserName());
        Assert.assertNotNull((String)"History items should not be null", (Object)history);
        Assert.assertEquals((String)"There should be no history items", (long)0L, (long)history.size());
    }

    @Test
    public void testRenameUser() throws Exception {
        UserPrincipal user = new UserPrincipal("seb", null);
        String newUsername = "bob";
        this.addItemToHistory(RecentlyVisitedItem.Type.PROJECT, (Principal)user, "CR-FE");
        this.addItemToHistory(RecentlyVisitedItem.Type.REVIEW, (Principal)user, "CR-FE-1");
        this.addItemToHistory(RecentlyVisitedItem.Type.REPOSITORY, (Principal)user, "FE");
        this.addItemToHistory(RecentlyVisitedItem.Type.USER, (Principal)user, "seb");
        List history = this.uhm.getAllHistory(user.getUserName());
        Assert.assertNotNull((String)"History items should not be null", (Object)history);
        Assert.assertEquals((String)"There should be four history items", (long)4L, (long)history.size());
        this.uhm.onUserRenamedEvent(new UserRenamedEvent("seb", newUsername));
        history = this.uhm.getAllHistory(user.getUserName());
        Assert.assertNotNull((String)"History items should be null", (Object)history);
        Assert.assertEquals((String)"There should be no history items for seb", (long)0L, (long)history.size());
        history = this.uhm.getAllHistory(newUsername);
        Assert.assertNotNull((String)"History items should not be null", (Object)history);
        Assert.assertEquals((String)"There should be four history items for bob", (long)4L, (long)history.size());
        Assert.assertEquals((Object)"bob", (Object)((RecentlyVisitedItem)history.get(0)).getUsername());
        Assert.assertEquals((Object)"bob", (Object)((RecentlyVisitedItem)history.get(1)).getUsername());
        Assert.assertEquals((Object)"bob", (Object)((RecentlyVisitedItem)history.get(2)).getUsername());
        Assert.assertEquals((Object)"bob", (Object)((RecentlyVisitedItem)history.get(3)).getUsername());
    }

    @Test
    public void testRenameRecentlyVisitedUsers() throws Exception {
        UserPrincipal seb = new UserPrincipal("seb", null);
        UserPrincipal adam = new UserPrincipal("adam", null);
        this.addItemToHistory(RecentlyVisitedItem.Type.USER, (Principal)seb, "seb");
        this.addItemToHistory(RecentlyVisitedItem.Type.USER, (Principal)seb, "adam");
        this.addItemToHistory(RecentlyVisitedItem.Type.USER, (Principal)seb, "jason");
        this.addItemToHistory(RecentlyVisitedItem.Type.USER, (Principal)seb, "joe");
        this.addItemToHistory(RecentlyVisitedItem.Type.USER, (Principal)adam, "seb");
        this.addItemToHistory(RecentlyVisitedItem.Type.USER, (Principal)adam, "adam");
        this.addItemToHistory(RecentlyVisitedItem.Type.USER, (Principal)adam, "jason");
        this.addItemToHistory(RecentlyVisitedItem.Type.USER, (Principal)adam, "joe");
        List history = this.uhm.getAllHistory(seb.getUserName());
        Assert.assertEquals((String)"There should be four history items", (long)4L, (long)history.size());
        Assert.assertEquals((Object)"joe", (Object)((RecentlyVisitedItem)history.get(0)).getEntityId());
        Assert.assertEquals((Object)"jason", (Object)((RecentlyVisitedItem)history.get(1)).getEntityId());
        Assert.assertEquals((Object)"adam", (Object)((RecentlyVisitedItem)history.get(2)).getEntityId());
        Assert.assertEquals((Object)"seb", (Object)((RecentlyVisitedItem)history.get(3)).getEntityId());
        history = this.uhm.getAllHistory(adam.getUserName());
        Assert.assertEquals((String)"There should be four history items", (long)4L, (long)history.size());
        Assert.assertEquals((Object)"joe", (Object)((RecentlyVisitedItem)history.get(0)).getEntityId());
        Assert.assertEquals((Object)"jason", (Object)((RecentlyVisitedItem)history.get(1)).getEntityId());
        Assert.assertEquals((Object)"adam", (Object)((RecentlyVisitedItem)history.get(2)).getEntityId());
        Assert.assertEquals((Object)"seb", (Object)((RecentlyVisitedItem)history.get(3)).getEntityId());
        this.uhm.onUserRenamedEvent(new UserRenamedEvent("jason", "bob"));
        history = this.uhm.getAllHistory(seb.getUserName());
        Assert.assertEquals((String)"There should be four history items", (long)4L, (long)history.size());
        Assert.assertEquals((Object)"joe", (Object)((RecentlyVisitedItem)history.get(0)).getEntityId());
        Assert.assertEquals((Object)"bob", (Object)((RecentlyVisitedItem)history.get(1)).getEntityId());
        Assert.assertEquals((Object)"adam", (Object)((RecentlyVisitedItem)history.get(2)).getEntityId());
        Assert.assertEquals((Object)"seb", (Object)((RecentlyVisitedItem)history.get(3)).getEntityId());
        history = this.uhm.getAllHistory(adam.getUserName());
        Assert.assertEquals((String)"There should be four history items", (long)4L, (long)history.size());
        Assert.assertEquals((Object)"joe", (Object)((RecentlyVisitedItem)history.get(0)).getEntityId());
        Assert.assertEquals((Object)"bob", (Object)((RecentlyVisitedItem)history.get(1)).getEntityId());
        Assert.assertEquals((Object)"adam", (Object)((RecentlyVisitedItem)history.get(2)).getEntityId());
        Assert.assertEquals((Object)"seb", (Object)((RecentlyVisitedItem)history.get(3)).getEntityId());
        this.uhm.onUserRenamedEvent(new UserRenamedEvent("joe", "alice"));
        history = this.uhm.getAllHistory(seb.getUserName());
        Assert.assertEquals((String)"There should be four history items", (long)4L, (long)history.size());
        Assert.assertEquals((Object)"alice", (Object)((RecentlyVisitedItem)history.get(0)).getEntityId());
        Assert.assertEquals((Object)"bob", (Object)((RecentlyVisitedItem)history.get(1)).getEntityId());
        Assert.assertEquals((Object)"adam", (Object)((RecentlyVisitedItem)history.get(2)).getEntityId());
        Assert.assertEquals((Object)"seb", (Object)((RecentlyVisitedItem)history.get(3)).getEntityId());
        history = this.uhm.getAllHistory(adam.getUserName());
        Assert.assertEquals((String)"There should be four history items", (long)4L, (long)history.size());
        Assert.assertEquals((Object)"alice", (Object)((RecentlyVisitedItem)history.get(0)).getEntityId());
        Assert.assertEquals((Object)"bob", (Object)((RecentlyVisitedItem)history.get(1)).getEntityId());
        Assert.assertEquals((Object)"adam", (Object)((RecentlyVisitedItem)history.get(2)).getEntityId());
        Assert.assertEquals((Object)"seb", (Object)((RecentlyVisitedItem)history.get(3)).getEntityId());
    }

    @Test
    public void shouldIgnoreUsernameCase() throws Exception {
        this.uhm.addItemToHistory(RecentlyVisitedItem.Type.USER, new FecruUser("BOB"), "Tom");
        this.uhm.addItemToHistory(RecentlyVisitedItem.Type.USER, new FecruUser("boB"), "FRED");
        List history = this.uhm.getAllHistory("bob");
        List userHistory = this.uhm.getHistory(RecentlyVisitedItem.Type.USER, (Principal)new UserPrincipal("Bob", null));
        this.uhm.removeHistoryForUser("BOb");
        List afterRemoval = this.uhm.getAllHistory("bob");
        MatcherAssert.assertThat((Object)history, (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"username", (Matcher)Matchers.equalTo((Object)"bob"))));
        MatcherAssert.assertThat((Object)history, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.hasProperty((String)"entityId", (Matcher)Matchers.equalTo((Object)"tom")), Matchers.hasProperty((String)"entityId", (Matcher)Matchers.equalTo((Object)"fred"))}));
        MatcherAssert.assertThat((Object)history, (Matcher)Matchers.equalTo((Object)userHistory));
        MatcherAssert.assertThat((Object)afterRemoval, (Matcher)Is.is((Matcher)Matchers.empty()));
    }

    @Test
    public void testRenameShouldIgnoreCase() throws Exception {
        this.uhm.addItemToHistory(RecentlyVisitedItem.Type.USER, new FecruUser("BOB"), "Tom");
        this.uhm.addItemToHistory(RecentlyVisitedItem.Type.USER, new FecruUser("Don"), "bob");
        this.uhm.onUserRenamedEvent(new UserRenamedEvent("Bob", "FRED"));
        List fredHistory = this.uhm.getAllHistory("fred");
        List donHistory = this.uhm.getAllHistory("don");
        List bobHistory = this.uhm.getAllHistory("bob");
        MatcherAssert.assertThat((Object)fredHistory, (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.hasProperty((String)"username", (Matcher)Matchers.equalTo((Object)"fred")), (Matcher)Matchers.hasProperty((String)"entityId", (Matcher)Matchers.equalTo((Object)"tom")))));
        MatcherAssert.assertThat((Object)donHistory, (Matcher)Matchers.contains((Matcher)Matchers.hasProperty((String)"entityId", (Matcher)Matchers.equalTo((Object)"fred"))));
        MatcherAssert.assertThat((Object)bobHistory, (Matcher)Matchers.empty());
    }
}

