/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.it.spi;

import com.atlassian.crucible.spi.services.NotFoundException;
import com.atlassian.crucible.spi.services.NotPermittedException;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.fisheye.user.permissions.GlobalPermissionManager;
import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.atlassian.fisheye.util.UseTestSpringContextTestCase;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.dbutils.ModelUtils;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.user.GroupMembershipManager;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.util.TestUtil;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.collections.BeanMap;

public abstract class ServiceTestBase
extends UseTestSpringContextTestCase {
    private FecruUser currentCrucibleUser;
    protected FecruUser fred;
    protected FecruUser joe;
    private UserLogin currentUser;
    private Principal currentTxUser;
    protected TxTemplate txTemplate;
    protected static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>";
    protected UserManager userManager;
    protected GroupMembershipManager groupMembershipManager;
    protected PermissionManager permissionManager;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        TestFishEyeInstances.stop();
        Disposer.pushThreadInstance();
        TestFishEyeInstances.loadSanity1();
        TestUtil.addFisheyeUser("fred", "Fred Nurk", "fred@test.com");
        TestUtil.addFisheyeUser("joe", "Joe Bloggs", "joe@test.com");
        this.userManager = (UserManager)SpringContext.getComponentByClass(UserManager.class);
        this.userManager.addGroup("team-1");
        this.groupMembershipManager = (GroupMembershipManager)SpringContext.getComponentByClass(GroupMembershipManager.class);
        ((GlobalPermissionManager)SpringContext.getComponentByClass(GlobalPermissionManager.class)).setPermissionsForGroup("team-1", GlobalPermissionType.FISHEYE_AND_CRUCIBLE);
        this.joe = ModelUtils.makeAndSaveUser("joe");
        this.fred = this.currentCrucibleUser = ModelUtils.makeAndSaveUser("fred");
        UserActionManager.resetForTests();
        UserActionManager.getInstance();
        this.permissionManager = (PermissionManager)SpringContext.getComponentByClass(PermissionManager.class);
        this.permissionManager.getDefaultPermissionScheme().removeAnonAction(UserActionManager.ACTION_VIEW);
        this.currentUser = this.createTrustedUserLogin("fred");
        this.currentTxUser = this.currentUser;
        this.txTemplate = (TxTemplate)SpringContext.getComponent((String)"txTemplate");
        this.txTemplate.setEffectivePrincipal((Principal)this.currentUser, this.currentCrucibleUser);
        HibernateUtil.closeSession();
    }

    @Override
    protected void tearDown() throws Exception {
        this.txTemplate.setEffectivePrincipal((Principal)Principal.Anonymous.ANON, null);
        Disposer.popThreadInstance();
        this.currentCrucibleUser = null;
        this.currentTxUser = null;
        this.currentUser = null;
        this.fred = null;
        this.txTemplate = null;
        super.tearDown();
    }

    protected void useAnonUser() {
        this.txTemplate.setEffectivePrincipal((Principal)Principal.Anonymous.ANON, null);
    }

    protected UserLogin createTrustedUserLogin(String username) throws LicensePolicyException {
        this.groupMembershipManager.addUserToGroup("team-1", username);
        return this.userManager.createTrustedUserLogin(username);
    }

    protected void expectDocumentNotFound(Runnable action) {
        try {
            action.run();
            ServiceTestBase.fail((String)"Non-existent document should not have been found.");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    protected void expectPermissionFailureOfAction(Runnable action, String type) {
        try {
            this.useAnonUser();
            action.run();
            ServiceTestBase.fail((String)("anon user should not have been allowed to " + type));
        }
        catch (NotPermittedException notPermittedException) {
            // empty catch block
        }
    }

    protected void assertBeansEqual(Object desired, Object actual) {
        this.assertBeansEqual(desired, actual, new String[0]);
    }

    protected void assertBeansEqual(Object desired, Object actual, String ignore) {
        this.assertBeansEqual(desired, actual, new String[]{ignore});
    }

    protected void assertBeansEqual(Object desired, Object actual, String[] ignore) {
        BeanMap desiredMap = new BeanMap(desired);
        BeanMap actualMap = new BeanMap(actual);
        HashSet<String> ignoreSet = new HashSet<String>(Arrays.asList(ignore));
        for (String key : desiredMap.keySet()) {
            if (ignoreSet.contains(key)) continue;
            ServiceTestBase.assertEquals((String)key, (Object)desiredMap.get((Object)key), (Object)actualMap.get((Object)key));
        }
    }
}

