/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.it.search.query;

import com.cenqua.fisheye.cvsrep.RepSanityTestBase;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.search.SearchResults;
import com.cenqua.fisheye.util.Disposer;
import java.util.Arrays;
import java.util.HashSet;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class PathClauseTest
extends RepSanityTestBase {
    @Override
    protected RepositoryHandle whichHandle() throws Exception {
        return TestFishEyeInstances.getSanity1Repos();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Disposer.pushThreadInstance();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        try {
            Disposer.popThreadInstance();
        }
        finally {
            super.tearDown();
        }
    }

    @Test
    public void testPathEquals() throws Exception {
        this.assertFilesFound("select revisions where path = a.txt", new String[0]);
        this.assertFilesFound("select revisions where path = test/a.txt", "test/a.txt");
        this.assertFilesFound("select revisions where path = test/test/t2/a.txt", "test/test/t2/a.txt");
    }

    @Test
    public void testPathLike() throws Exception {
        this.assertFilesFound("select revisions where path like a.txt", "emptytests/notempty/a.txt", "test/a.txt", "test/branching/a.txt", "test/test/t2/a.txt");
        this.assertFilesFound("select revisions where path like a*.txt", "emptytests/notempty/a.txt", "test/a.txt", "test/branching/a.txt", "test/test/t2/a.txt");
        this.assertFilesFound("select revisions where path like test/**/a.txt", "test/a.txt", "test/branching/a.txt", "test/test/t2/a.txt");
        this.assertFilesFound("select revisions where path like *test*/**/a.txt", "emptytests/notempty/a.txt", "test/a.txt", "test/branching/a.txt", "test/test/t2/a.txt");
    }

    private void assertFilesFound(String q, String ... paths) throws Exception {
        SearchResults q1 = this.doQuery(q);
        HashSet<String> expected = new HashSet<String>(Arrays.asList(paths));
        HashSet<String> notfound = new HashSet<String>(expected);
        SearchResults.RevisionResultsIterator i = q1.iterateRevisions(0);
        while (i.hasNext()) {
            FileRevision f = i.nextItem();
            String msg = f.getRevInfoKey().toString();
            String path = f.getPath().getPath();
            Assert.assertTrue((String)msg, (boolean)expected.contains(path));
            notfound.remove(path);
        }
        Assert.assertTrue((boolean)notfound.isEmpty());
    }
}

