/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.it.search.query;

import com.atlassian.fisheye.it.cvsrep.RepSanity1Test;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cvsrep.RcsUtil;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.search.SearchResults;
import com.cenqua.fisheye.search.query.ReturnClause;
import com.cenqua.fisheye.util.Disposer;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class EyeqlReturnClauseSanityTest {
    private RepositoryEngine engine;

    @Before
    public void setUp() throws Exception {
        TestFishEyeInstances.checkCleanStart();
        Disposer.pushThreadInstance();
        RepositoryHandle handle = TestFishEyeInstances.getSanity1Repos();
        this.engine = handle.acquireEngine();
    }

    @After
    public void tearDown() throws Exception {
        Disposer.popThreadInstance();
        TestFishEyeInstances.stop();
        TestFishEyeInstances.checkCleanStart();
    }

    @Test
    public void testOrderByDirection() throws Exception {
        SearchResults canonical = this.doQuery("select revisions where path like \"/test/support/thread1308/readme\" order by date");
        SearchResults asc = this.doQuery("select revisions where path like \"/test/support/thread1308/readme\" order by date asc");
        SearchResults desc = this.doQuery("select revisions where path like \"/test/support/thread1308/readme\" order by date desc");
        junit.framework.Assert.assertEquals((int)canonical.size(), (int)desc.size());
        junit.framework.Assert.assertEquals((int)canonical.size(), (int)asc.size());
        SearchResults.RevisionResultsIterator ascRevs = asc.iterateRevisions(0);
        SearchResults.RevisionResultsIterator descRevs = desc.iterateRevisions(0);
        SearchResults.RevisionResultsIterator canonicalRevs = canonical.iterateRevisions(0);
        HashSet<Integer> ascRevidset = new HashSet<Integer>();
        HashSet<Integer> descRevidset = new HashSet<Integer>();
        HashSet<Integer> canonicalRevidset = new HashSet<Integer>();
        int[] ascRevids = new int[asc.size()];
        int[] descRevids = new int[desc.size()];
        int counter = 0;
        while (ascRevs.hasNext()) {
            ascRevids[counter] = ascRevs.nextItemId();
            descRevids[descRevids.length - counter - 1] = descRevs.nextItemId();
            ascRevidset.add(ascRevids[counter]);
            descRevidset.add(descRevids[descRevids.length - counter - 1]);
            canonicalRevidset.add(canonicalRevs.nextItemId());
            ++counter;
        }
        int i = 0;
        while (counter < canonical.size()) {
            junit.framework.Assert.assertEquals((int)ascRevids[i], (int)descRevids[i]);
            ++counter;
        }
        for (Integer revid : canonicalRevidset) {
            Assert.assertTrue((boolean)ascRevidset.contains(revid));
            Assert.assertTrue((boolean)descRevidset.contains(revid));
        }
    }

    @Test
    public void testSimple() throws Exception {
        SearchResults results = this.doQuery("select revisions where path like /test/support/thread1308/readme and is head on yoyo return path, revision, author, date, comment, csid, totalLines, linesAdded, linesRemoved, isBinary, isDeleted, isAdded, isCopied, isMoved");
        junit.framework.Assert.assertEquals((int)1, (int)results.size());
        Object[] expected = new Object[]{new Path((CharSequence)"test/support/thread1308/readme"), "1.1.1.1", "matt", new Date(RcsUtil.parseDate((String)"2003.02.14.06.02.23")), "\n", "yoyo:matt:20030214060223", 1, 0, 0, "false", "false", "false", "false", "false"};
        this.assertResultsContain(expected, results);
        results = this.doQuery("select revisions where path like /test/support/thread1308/readme and date < 2003-02-16 and on branch MAIN return path, revision, author, date, comment, csid, totalLines, linesAdded, linesRemoved, isBinary, isDeleted, isAdded, isCopied, isMoved");
        junit.framework.Assert.assertEquals((int)1, (int)results.size());
        expected = new Object[]{new Path((CharSequence)"test/support/thread1308/readme"), "1.1", "matt", new Date(RcsUtil.parseDate((String)"2003.02.14.06.02.23")), "Initial revision\n", "MAIN:matt:20030214060223", 1, 1, 0, "false", "false", "true", "false", "false"};
        this.assertResultsContain(expected, results);
        results = this.doQuery("select revisions where tagged CHALK_t2 return path, revision, tags");
        junit.framework.Assert.assertEquals((int)1, (int)results.size());
        Object[] expectedTags = new String[]{"build-128", "build-129", "build-126", "build-127", "build-124", "build-125", "build-122", "build-123", "PROD_136$BP", "CHALK$BP", "build-135", "build-136", "build-131", "build-132", "build-133", "build-134", "build-130", "CHALK_t2", "CHALK_t3", "CHALK_t1", "JMSIFY_BP", "JMSIFY$BP"};
        Arrays.sort(expectedTags);
        expected = new Object[]{new Path((CharSequence)"test/CleanSweeper.java"), "1.9", expectedTags};
        this.assertResultsContain(expected, results);
    }

    private void assertResultsContain(Object[] expectedRow, SearchResults collator) throws Exception {
        Assert.assertTrue((boolean)collator.hasTabularResults());
        ReturnClause md = collator.getReturnClause();
        junit.framework.Assert.assertEquals((int)md.numFields(), (int)expectedRow.length);
        SearchResults.TabularResultsIterator results = collator.iterateData(0);
        block0: while (results.hasNext()) {
            SearchResults.ResultRow row = results.nextRow();
            for (int i = 0; i < md.numFields(); ++i) {
                boolean eq;
                Object expectedValue = expectedRow[i];
                Object value = row.get(i);
                if (value.getClass().isArray()) {
                    eq = expectedValue != null && Arrays.equals((String[])value, (String[])expectedValue);
                } else {
                    boolean bl = eq = expectedValue != null && expectedValue.equals(value);
                }
                if (!eq) continue block0;
            }
            return;
        }
        junit.framework.Assert.fail((String)"could not find it");
    }

    private SearchResults doQuery(String ql) throws Exception {
        return RepSanity1Test.doQuery(ql, this.engine);
    }
}

