/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.it.rep.upgrade;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fisheye.it.rep.upgrade.AppConfigStub;
import com.atlassian.fisheye.spi.admin.data.HgRepositoryData;
import com.atlassian.fisheye.spi.admin.data.RepositoryData;
import com.atlassian.fisheye.spi.admin.impl.DefaultRepositoryAdminService;
import com.atlassian.fisheye.spi.admin.services.RepositoryAdminService;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.Tag;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import com.google.common.base.Function;
import java.io.File;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@ContextConfiguration(value={"classpath:/com/cenqua/crucible/util/testApplicationContext.xml"})
@DirtiesContext
@RunWith(value=SpringJUnit4ClassRunner.class)
public class HgTipUpgradeTaskTest
implements ApplicationContextAware {
    private static final String REPO = "HgTipUpgradeTaskTest";
    @ClassRule
    public static AppConfigStub appConfigStub = new AppConfigStub();
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    @Autowired
    RepositoryManager repositoryManager;
    @Autowired
    EffectiveUserProvider effectiveUserProvider;
    RepositoryAdminService repositoryAdminService;

    @Before
    public void setUp() throws Exception {
        this.repositoryAdminService = new DefaultRepositoryAdminService(this.repositoryManager, null, (EventPublisher)Mockito.mock(EventPublisher.class), this.effectiveUserProvider, null, null, null);
        this.effectiveUserProvider.pushEffectivePrincipal((Principal)Principal.SuperUser.INSTANCE, null);
        AppConfig.getsConfig().refreshLicenses();
    }

    @Test
    public void testUpgrade() throws Exception {
        String repoPath = this.temp.newFolder().getAbsolutePath();
        HgRepositoryData repoData = new HgRepositoryData(REPO, repoPath);
        repoData.setEnabled(Boolean.valueOf(true));
        this.repositoryAdminService.create((RepositoryData)repoData);
        RepositoryHandle handle = this.repositoryManager.getRepository(REPO);
        File cacheDir = handle.getCfg().getCacheDir();
        IOHelper.unzip((File)new File(FisheyeTestEnv.WORKSPACE_DIR, "test/testfiles/hg/caches/hgtip-cache.zip"), (File)cacheDir);
        this.repositoryManager.runRepository(REPO);
        handle.withEngine((Function)new Function<RepositoryEngine, Object>(){

            public Object apply(RepositoryEngine eng) {
                RevisionCache cache = eng.getRevisionCache();
                Branch defaultBranch = cache.getBranch("default");
                Tag tip = cache.getTag("tip");
                Assert.assertThat((Object)cache.getVersion(), (Matcher)Matchers.equalTo((Object)12));
                Assert.assertThat((Object)defaultBranch.getLatestChangeSetId(), (Matcher)Matchers.equalTo((Object)"8e37c9decb78594d4d277b6e6c038c76411db1bb"));
                Assert.assertThat((Object)tip.getChangesetId(), (Matcher)Matchers.equalTo((Object)"41f4fdeb96c73044083c5192d8a0b17c025a8473"));
                return null;
            }
        });
    }

    @After
    public void tearDown() throws Exception {
        this.repositoryManager.fullShutdown();
        this.effectiveUserProvider.popEffectivePrincipal();
        SpringContext.setApplicationContext(null);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpringContext.setApplicationContext((ApplicationContext)applicationContext);
    }
}

