/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.it.rep.impl;

import com.atlassian.fisheye.rep.BaseTestHarness;
import com.atlassian.fisheye.util.UseTestSpringContextTestCase;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.cache.BaseRevisionCache;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.perforce.P4TestHarness;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.rep.BranchState;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.svn.SvnTestHarness;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Assert;
import org.apache.xmlbeans.XmlException;
import org.junit.Test;

public class UpgradeBranchListTest
extends UseTestSpringContextTestCase {
    private static String[] p4BranchSpecs = new String[]{"head@9", "branch_a@11", "branch_b@12", "branch_c@13", "branch_d@15", "branch_a_a@8"};
    private static String[] svnBranchSpecs = new String[]{"trunk@11", "branch_a@6", "branch_b@7", "branch_a_a@8", "root:@1"};

    @Override
    public void setUp() throws Exception {
        super.setUp();
        AppConfig.setTestMode();
    }

    @Test
    public void testP4Upgrade() throws Exception {
        P4TestHarness harness = new P4TestHarness(){

            @Override
            public void startRepo() {
                UpgradeBranchListTest.this.unzipCache(this.getAppDir(), this.getRepoName());
            }

            @Override
            protected void stopRepo() {
            }

            @Override
            protected void afterEngineStarted() throws DbException {
            }
        };
        this.upgradeAndValidateBranches(harness, "p4upgrade", p4BranchSpecs);
    }

    @Test
    public void testSvnUpgrade() throws Exception {
        SvnTestHarness harness = new SvnTestHarness(){

            @Override
            public void startRepo() {
                UpgradeBranchListTest.this.unzipCache(this.getAppDir(), this.getRepoName());
            }
        };
        this.upgradeAndValidateBranches(harness, "svnupgrade", svnBranchSpecs);
    }

    public void testCvsUpgrade() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeAndValidateBranches(BaseTestHarness<?> harness, String repoName, String[] branchSpecs) throws IOException, RepositoryClientException, ConfigException, XmlException {
        try {
            AppConfig.getsConfig().initCrossRepLuceneIndex();
            harness.setRepoName(repoName);
            harness.createRepoDir();
            harness.createAndStartEngine();
            try {
                harness.getEngine().slurp();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Set<Branch> expected = this.makeBranchSet(branchSpecs);
            this.verifyBranches(harness, expected);
        }
        finally {
            harness.cleanUp();
        }
    }

    private Set<Branch> makeBranchSet(String[] p4BranchSpecs) {
        HashSet<Branch> branchSet = new HashSet<Branch>();
        for (String spec : p4BranchSpecs) {
            String[] bits = spec.split("@");
            branchSet.add(new Branch(bits[0], bits[1], BranchState.ACTIVE));
        }
        return branchSet;
    }

    private void verifyBranches(BaseTestHarness<?> harness, Set<Branch> expected) {
        BaseRevisionCache<?, ?, ?> cache = harness.getCache();
        Set branches = cache.getBranches();
        Assert.assertEquals((String)"Branch sets do not match", expected, (Object)branches);
    }

    private void unzipCache(File appDir, String repoName) {
        try {
            File cacheDir = new File(appDir, "var/cache/" + repoName);
            IOHelper.mkdirs((File)cacheDir);
            String cacheZipName = "test/testfiles/rep/caches/" + repoName + ".zip";
            File cacheZip = new File(FisheyeTestEnv.WORKSPACE_DIR, cacheZipName);
            IOHelper.unzip((File)cacheZip, (File)cacheDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

