/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.it.rep;

import com.atlassian.fecru.user.UserPermissionsTestRule;
import com.atlassian.fisheye.activity.ActivityItem;
import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.atlassian.fisheye.search.SearchSortOrder;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.DefaultCrossRepositorySearcher;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.util.ISO8601DateHelper;
import com.cenqua.fisheye.web.ChangeSetHolder;
import java.util.Iterator;
import java.util.List;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class CrossRepositorySearcherTest {
    private List<ChangeSetHolder> recentChangeSets;
    private UserPermissionsTestRule userPermissionsTestRule;

    @Before
    public void setUp() throws Exception {
        Disposer.pushThreadInstance();
        TestFishEyeInstances.loadSanity1();
        this.userPermissionsTestRule = (UserPermissionsTestRule)((Object)SpringContext.createComponent(UserPermissionsTestRule.class));
        this.userPermissionsTestRule.before();
    }

    @Test
    public void testFindRecentChangeSets() throws Exception {
        DefaultCrossRepositorySearcher searcher = (DefaultCrossRepositorySearcher)SpringContext.createComponent(DefaultCrossRepositorySearcher.class);
        ActivityItemSearchParams.Builder builder = new ActivityItemSearchParams.Builder();
        builder.timeZone((TimeZone)new SimpleTimeZone(0, "GMT"));
        builder.includeFisheye();
        builder.maxItems(10);
        builder.searchDirection(SearchSortOrder.TOWARDS_PAST);
        Iterator it = searcher.findRecentChangeSets(builder.build(), null).iterator();
        this.assertChangeSet((ActivityItem)it.next(), "4", "svnprops");
        this.assertChangeSet((ActivityItem)it.next(), "3", "svnprops");
        this.assertChangeSet((ActivityItem)it.next(), "2", "svnprops");
        this.assertChangeSet((ActivityItem)it.next(), "1", "svnprops");
        this.assertChangeSet((ActivityItem)it.next(), "BRANCH_2_2:matt:20050517064053", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "BRANCH_2:matt:20050323231241", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "BRANCH1:matt:20050113032802", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:matt:20050113032653", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:matt:20050113032614", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:matt:20050106031006", "cvs");
        builder = new ActivityItemSearchParams.Builder();
        builder.timeZone((TimeZone)new SimpleTimeZone(0, "GMT"));
        builder.maxItems(10);
        builder.searchDirection(SearchSortOrder.TOWARDS_FUTURE);
        builder.minDate(ISO8601DateHelper.parseAsUTC((String)"2004-11-16T23:55:24+1100"));
        builder.includeFisheye();
        it = searcher.findRecentChangeSets(builder.build(), null).iterator();
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:matt:20041116234830", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:matt:20041116234847", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "BRANCH_1:matt:20041116234945", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "BRANCH_1:matt:20041116235236", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "BRANCH_1:matt:20041116235307", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "BRANCH_1:matt:20041116235525", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:matt:20041116235525", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "BRANCH_1:matt:20041117000354", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:matt:20041205010425", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:matt:20050106031006", "cvs");
        builder = new ActivityItemSearchParams.Builder();
        builder.timeZone((TimeZone)new SimpleTimeZone(0, "GMT"));
        builder.maxItems(20);
        builder.searchDirection(SearchSortOrder.TOWARDS_PAST);
        builder.maxDate(ISO8601DateHelper.parseAsUTC((String)"2003-02-15T00:00:00+1100"));
        builder.includeFisheye();
        List setHolderList = searcher.findRecentChangeSets(builder.build(), null);
        it = setHolderList.iterator();
        this.assertChangeSet((ActivityItem)it.next(), "yoyo:matt:20030214060223", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:matt:20030214060223", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:anthony:20030214044800", "cvs2");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:anthony:20030214044800", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:anthony:20030211000212", "cvs2");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:anthony:20030211000212", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:leanne:20030204231054", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:anthony:20030114072630", "cvs2");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:anthony:20030114072630", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "reimport:cristi:20030109180224", "cvs");
    }

    @Test
    public void testUserConstrainedChangesets() throws Exception {
        CommitterUserMappingManager manager = (CommitterUserMappingManager)SpringContext.getComponent(CommitterUserMappingManager.class, (String)"committerUserMappingManager");
        this.userPermissionsTestRule.addFisheyeUser("stan", "stan", "stan");
        manager.addMapping("stan", "cvs", "matt");
        manager.addMapping("stan", "cvs2", "anthony");
        DefaultCrossRepositorySearcher searcher = (DefaultCrossRepositorySearcher)SpringContext.createComponent(DefaultCrossRepositorySearcher.class);
        ActivityItemSearchParams.Builder builder = new ActivityItemSearchParams.Builder();
        builder.user("stan");
        builder.timeZone((TimeZone)new SimpleTimeZone(0, "GMT"));
        builder.searchDirection(SearchSortOrder.TOWARDS_PAST);
        builder.includeFisheye();
        builder.maxItems(10);
        this.recentChangeSets = searcher.findRecentChangeSets(builder.build(), null);
        Iterator<Object> it = this.recentChangeSets.iterator();
        this.assertChangeSet((ActivityItem)it.next(), "BRANCH_2_2:matt:20050517064053", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "BRANCH_2:matt:20050323231241", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "BRANCH1:matt:20050113032802", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:matt:20050113032653", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:matt:20050113032614", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:matt:20050106031006", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:matt:20041205010425", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "BRANCH_1:matt:20041117000354", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:matt:20041116235525", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "BRANCH_1:matt:20041116235525", "cvs");
        builder = new ActivityItemSearchParams.Builder();
        builder.user("stan");
        builder.timeZone((TimeZone)new SimpleTimeZone(0, "GMT"));
        builder.includeFisheye();
        builder.maxItems(10);
        builder.searchDirection(SearchSortOrder.TOWARDS_FUTURE);
        builder.minDate(ISO8601DateHelper.parseAsUTC((String)"2004-11-16T23:55:24+1100"));
        it = searcher.findRecentChangeSets(builder.build(), null).iterator();
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:matt:20041116234830", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:matt:20041116234847", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "BRANCH_1:matt:20041116234945", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "BRANCH_1:matt:20041116235236", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "BRANCH_1:matt:20041116235307", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "BRANCH_1:matt:20041116235525", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:matt:20041116235525", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "BRANCH_1:matt:20041117000354", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:matt:20041205010425", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:matt:20050106031006", "cvs");
        builder = new ActivityItemSearchParams.Builder();
        builder.includeFisheye();
        builder.timeZone((TimeZone)new SimpleTimeZone(0, "GMT"));
        builder.maxItems(10);
        builder.user("stan");
        builder.searchDirection(SearchSortOrder.TOWARDS_PAST);
        builder.maxDate(ISO8601DateHelper.parseAsUTC((String)"2003-02-15T00:00:00+1100"));
        List setHolderList = searcher.findRecentChangeSets(builder.build(), null);
        it = setHolderList.iterator();
        this.assertChangeSet((ActivityItem)it.next(), "yoyo:matt:20030214060223", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:matt:20030214060223", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:anthony:20030214044800", "cvs2");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:anthony:20030211000212", "cvs2");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:anthony:20030114072630", "cvs2");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:matt:20021216102031", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:anthony:20021216002439", "cvs2");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:anthony:20021204045947", "cvs2");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:anthony:20021203230408", "cvs2");
        Assert.assertFalse((boolean)it.hasNext());
    }

    private void assertChangeSet(ActivityItem holder, String csid, String repoName) {
        Assert.assertEquals((String)csid, (String)((ChangeSetHolder)holder).getChangeset().getId());
        Assert.assertEquals((String)repoName, (String)((ChangeSetHolder)holder).getContext().getRepoName());
    }

    @After
    public void tearDown() throws Exception {
        this.userPermissionsTestRule.after();
        HibernateUtil.closeSession();
        Disposer.popThreadInstance();
        TestFishEyeInstances.stop();
    }
}

