/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.it.mail;

import com.atlassian.fisheye.spi.data.MailMessageData;
import com.cenqua.fisheye.mail.MailerTestUtils;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.util.GreenMail;
import com.icegreen.greenmail.util.GreenMailUtil;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class MailerIntegrationTest {
    private GreenMail greenmail;
    private static final String SUBJECT_IDENTIFIER = "Subject: ";
    private static final long MAX_WAIT_TIME = 30000L;
    private static final String[] CUSTOM_SUBJECTS = new String[]{"normal subject acbdefg the quick bornw fox jumps", "Subject: repeated f232- t3'4'%# $L'3:$L 3:L4 subject:", "[Crucible] FE:/ 14071 by pmcneil: CRUC-214: Fix report dates to go", ""};
    private static final String[] LINE_SEPERATORS = new String[]{"\n\n", "\r\r", "\n\r\n\r", "\r\n\r\n"};
    private static final String[] BODIES = new String[]{"Email body text 23 123095471982 hkj1 3h4lkj53k45';1324i[]1po", "body that has Subject: in it, with\nlines\nlots of\nlines\ncarriage returns.", "body that has Subject: in it, with\nlines\nlots of\nlines\ncarriage returns.".replace('\n', '\r'), "Subject: body that has Subject: in it, with\nlines\nlots of\nlines\ncarriage returns.", "<html>\n<body>\n<table width=\"100%\">\n <tr>\n  <td><a href=\"https://studio.atlassian.com/fisheye/changelog/FE?cs=14071\"><strong>14071</strong></a></td>\n  <td width=\"30%\" align=\"center\"><strong>pmcneil</strong></td>\n  <td align=\"right\">Sun, 02 March 2008, 18:51:24 -0600</td>\n </tr>\n <tr><td colspan=\"3\">\n  <hr>\n\n  <tt><a href=\"https://studio.atlassian.com/browse/CRUC-214\">CRUC-214</a>: Fix report dates to go from day begin to day end on week correctly</tt>\n <hr>\n </td></tr>\n\n</table>\n<table>\n<tr>\n  <td><a href=\"https://studio.atlassian.com/fisheye/browse/FE/branches/iteration03/src/java/com/cenqua/crucible/view/CommentReportDO.java\">branches/iteration03/src/java/com/cenqua/crucible/view/CommentReportDO.java</a></td>\n  <td><a href=\"https://studio.atlassian.com/fisheye/browse/FE/branches/iteration03/src/java/com/cenqua/crucible/view/CommentReportDO.java?r=14071\">14071</a></td>\n  <td>(+21-20)</td>\n  <td><a href=\"https://studio.atlassian.com/fisheye/browse/FE/branches/iteration03/src/java/com/cenqua/crucible/view/CommentReportDO.java?r1=13900&r2=14071\">diffs</a></td>\n\n</tr>\n<tr>\n  <td><a href=\"https://studio.atlassian.com/fisheye/browse/FE/branches/iteration03/src/java/com/cenqua/fisheye/util/DateHelper.java\">branches/iteration03/src/java/com/cenqua/fisheye/util/DateHelper.java</a></td>\n  <td><a href=\"https://studio.atlassian.com/fisheye/browse/FE/branches/iteration03/src/java/com/cenqua/fisheye/util/DateHelper.java?r=14071\">14071</a></td>\n  <td>(+8-0)</td>\n  <td><a href=\"https://studio.atlassian.com/fisheye/browse/FE/branches/iteration03/src/java/com/cenqua/fisheye/util/DateHelper.java?r1=13912&r2=14071\">diffs</a></td>\n\n</tr>\n<tr>\n  <td><a href=\"https://studio.atlassian.com/fisheye/browse/FE/branches/iteration03/src/java/com/cenqua/crucible/actions/chart/CommentDefectAction.java\">branches/iteration03/src/java/com/cenqua/crucible/actions/chart/CommentDefectAction.java</a></td>\n  <td><a href=\"https://studio.atlassian.com/fisheye/browse/FE/branches/iteration03/src/java/com/cenqua/crucible/actions/chart/CommentDefectAction.java?r=14071\">14071</a></td>\n  <td>(+2-1)</td>\n  <td><a href=\"https://studio.atlassian.com/fisheye/browse/FE/branches/iteration03/src/java/com/cenqua/crucible/actions/chart/CommentDefectAction.java?r1=13900&r2=14071\">diffs</a></td>\n\n</tr>\n<tr>\n  <td><a href=\"https://studio.atlassian.com/fisheye/browse/FE/branches/iteration03/src/java/com/cenqua/crucible/view/ReviewReportDO.java\">branches/iteration03/src/java/com/cenqua/crucible/view/ReviewReportDO.java</a></td>\n  <td><a href=\"https://studio.atlassian.com/fisheye/browse/FE/branches/iteration03/src/java/com/cenqua/crucible/view/ReviewReportDO.java?r=14071\">14071</a></td>\n  <td>(+21-20)</td>\n  <td><a href=\"https://studio.atlassian.com/fisheye/browse/FE/branches/iteration03/src/java/com/cenqua/crucible/view/ReviewReportDO.java?r1=13912&r2=14071\">diffs</a></td>\n\n</tr>\n</table>\n<br>\n<br>\n</body>\n</html>\n"};

    @Before
    public void setUp() throws Exception {
        this.greenmail = MailerTestUtils.getGreenmailServer();
        this.greenmail.setUser("test@test.com", "test", "test");
    }

    @After
    public void tearDown() throws Exception {
        MailerTestUtils.cleanInbox();
    }

    @Test
    public void testSmtp() throws InterruptedException, MessagingException, FolderException {
        MailMessageData message = new MailMessageData();
        message.addRecipient("test@test.com");
        String subject = "sample subject";
        String body = "test body message.";
        message.setSubject(subject);
        message.setBodyText("text/plain; charset=UTF-8", body);
        MailerTestUtils.cleanInbox();
        MailerTestUtils.sendEmail(message);
        Assert.assertTrue((String)"email not received: either took too long or not sent", (boolean)this.greenmail.waitForIncomingEmail(30000L, 1));
        MimeMessage[] messages = this.greenmail.getReceivedMessages();
        Assert.assertEquals((int)1, (int)messages.length);
        Assert.assertEquals((String)subject, (String)messages[0].getSubject());
        Assert.assertEquals((String)body, (String)GreenMailUtil.getBody((Part)messages[0]).trim());
    }

    @Test
    public void testTLSSmtp() throws InterruptedException, MessagingException, FolderException {
        MailMessageData message = new MailMessageData();
        message.addRecipient("test@test.com");
        MailerTestUtils.cleanInbox();
        MailerTestUtils.sendTLSEmail(message);
        Assert.assertTrue((String)"email not received: either took too long or not sent", (boolean)this.greenmail.waitForIncomingEmail(30000L, 1));
    }

    @Test
    public void testCustomSubject() throws MessagingException, FolderException, InterruptedException {
        for (String customSubject : CUSTOM_SUBJECTS) {
            for (String lineSep : LINE_SEPERATORS) {
                for (String body : BODIES) {
                    MailMessageData toSend = MailerTestUtils.makeEmail(true, "original subject", SUBJECT_IDENTIFIER + customSubject + lineSep + body);
                    MailerTestUtils.cleanInbox();
                    MailerTestUtils.sendEmail(toSend);
                    Assert.assertTrue((String)"email not received: either took too long or not sent", (boolean)this.greenmail.waitForIncomingEmail(30000L, 1));
                    MimeMessage[] messages = this.greenmail.getReceivedMessages();
                    Assert.assertTrue((messages.length == 1 ? 1 : 0) != 0);
                    MimeMessage justReceived = messages[0];
                    String receivedSubject = justReceived.getSubject();
                    Assert.assertEquals((String)customSubject, (String)receivedSubject);
                    String receivedBody = GreenMailUtil.getBody((Part)justReceived);
                    MailerTestUtils.assertCharByCharIgnoreEOLEquals(body, receivedBody);
                }
            }
        }
    }

    @Test
    public void testNormalSubject() throws MessagingException, FolderException, InterruptedException {
        String unusedSubject = "original subject";
        for (String customSubject : CUSTOM_SUBJECTS) {
            for (String lineSep : LINE_SEPERATORS) {
                for (String body : BODIES) {
                    MailMessageData toSend = MailerTestUtils.makeEmail(false, "original subject", SUBJECT_IDENTIFIER + customSubject + lineSep + body);
                    MailerTestUtils.cleanInbox();
                    MailerTestUtils.sendEmail(toSend);
                    Assert.assertTrue((String)"email not received: either took too long or not sent", (boolean)this.greenmail.waitForIncomingEmail(30000L, 1));
                    MimeMessage[] messages = this.greenmail.getReceivedMessages();
                    Assert.assertTrue((messages.length == 1 ? 1 : 0) != 0);
                    MimeMessage justReceived = messages[0];
                    String receivedSubject = justReceived.getSubject();
                    Assert.assertEquals((String)"original subject", (String)receivedSubject);
                    String receivedBody = GreenMailUtil.getBody((Part)justReceived);
                    MailerTestUtils.assertCharByCharIgnoreEOLEquals(SUBJECT_IDENTIFIER + customSubject + lineSep + body, receivedBody);
                }
            }
        }
    }

    @Test
    public void testNormalSubjectWithHeaderInBody() throws MessagingException, InterruptedException, FolderException {
        String body = "test email body with\nSubject: fake subject header\ntest\nembedded";
        String subject = "original, uncustomized subject";
        MailMessageData mail = new MailMessageData();
        mail.addRecipient("test@test.com");
        mail.setBodyText("text/plain; charset=UTF-8", body);
        mail.setSubject(subject);
        mail.setAllowCustomBodyHeaders(false);
        MailerTestUtils.cleanInbox();
        MailerTestUtils.sendEmail(mail);
        Assert.assertTrue((String)"email not received: either took too long or not sent", (boolean)this.greenmail.waitForIncomingEmail(30000L, 1));
        MimeMessage[] messages = this.greenmail.getReceivedMessages();
        Assert.assertTrue((messages.length == 1 ? 1 : 0) != 0);
        String actualSubject = messages[0].getSubject();
        MailerTestUtils.assertCharByCharIgnoreEOLEquals(subject, actualSubject);
        String actualbody = GreenMailUtil.getBody((Part)messages[0]);
        MailerTestUtils.assertCharByCharIgnoreEOLEquals(body, actualbody);
    }
}

