/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.it.hibernate;

import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.cvsrep.RepSanityTestBase;
import com.cenqua.fisheye.model.ContentRoot;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import junit.framework.Assert;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class ProjectManagerTest
extends RepSanityTestBase {
    private ProjectManager projectManager;
    private int id1;
    private int id2;
    private int id3;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.projectManager = (ProjectManager)SpringContext.getComponent((String)"projectManager");
    }

    private void removeProject(int id) {
        if (this.projectManager.projectExists(id)) {
            this.projectManager.deleteProject(this.projectManager.getProjectById(id));
        }
    }

    @Override
    protected RepositoryHandle whichHandle() throws Exception {
        return TestFishEyeInstances.getSanity1Repos();
    }

    @Test
    public void testDeletingProjectContentRoot() {
        String rep1 = "repository1";
        String projectKey = "PR1";
        this.id1 = this.projectManager.createProject("project1", projectKey).getId();
        String path = "/test";
        this.projectManager.addPathToProject(this.projectManager.getProjectById(this.id1).getProjKey(), rep1, path);
        this.projectManager.deletePathFromProject(projectKey, rep1, path);
        Assert.assertEquals((String)"Content root should be removed from current session", (int)0, (int)this.projectManager.getProjectById(this.id1).getContentRoots().size());
        HibernateUtil.clearSession();
        Assert.assertEquals((String)"Content root should be removed from other session", (int)0, (int)this.projectManager.getProjectById(this.id1).getContentRoots().size());
    }

    @Test
    public void testProjectManagerContentRoots() {
        String rep1 = "repository1";
        Project project1 = new Project();
        this.id1 = this.projectManager.createProject("project1", "A").getId();
        ContentRoot cr1 = this.projectManager.addPathToProject(this.projectManager.getProjectById(this.id1).getProjKey(), rep1, "/test");
        project1.setId(Integer.valueOf(this.id1));
        project1.addContentRoot(cr1);
        Project project2 = new Project();
        String rep2 = "rep2";
        this.id2 = this.projectManager.createProject("project2", "B").getId();
        project2.setId(Integer.valueOf(this.id2));
        ContentRoot cr2 = this.projectManager.addRepToProject(this.projectManager.getProjectById(this.id2).getProjKey(), rep2);
        project2.addContentRoot(cr2);
        this.id3 = this.projectManager.createProject("project3", "C").getId();
        Project project3 = new Project();
        project3.setId(Integer.valueOf(this.id3));
        String rep3 = "rep3";
        ContentRoot cr3 = this.projectManager.addPathToProject(this.projectManager.getProjectById(this.id3).getProjKey(), rep3, "/test/this");
        project3.addContentRoot(cr3);
        Assert.assertEquals((int)4, (int)this.projectManager.getAllProjects().size());
        Assert.assertTrue((boolean)this.projectManager.projectExists(this.id1));
        Assert.assertEquals((Object)project1, (Object)this.projectManager.getProjectById(this.id1));
        Assert.assertTrue((boolean)this.projectManager.projectExists(this.id2));
        Assert.assertEquals((Object)project2, (Object)this.projectManager.getProjectById(this.id2));
        Assert.assertTrue((boolean)this.projectManager.projectExists(this.id3));
        Assert.assertEquals((Object)project3, (Object)this.projectManager.getProjectById(this.id3));
        ContentRoot cr4 = this.projectManager.addPathToProject(this.projectManager.getProjectById(this.id1).getProjKey(), rep1, "/foo");
        ContentRoot cr5 = this.projectManager.addRepToProject(this.projectManager.getProjectById(this.id1).getProjKey(), rep2);
        List result = this.projectManager.getProjectById(this.id1).getAllContentRootsForRep(rep1);
        Assert.assertTrue((boolean)result.contains(cr4));
        Assert.assertTrue((boolean)result.contains(cr1));
        Assert.assertFalse((boolean)result.contains(cr5));
        Set result2 = this.projectManager.getProjectById(this.id1).getContentRoots();
        Assert.assertTrue((boolean)result2.contains(cr4));
        Assert.assertTrue((boolean)result2.contains(cr1));
        Assert.assertTrue((boolean)result2.contains(cr5));
        this.projectManager.deletePathFromProject(this.projectManager.getProjectById(this.id3).getProjKey(), rep3, "/test/this");
        Assert.assertTrue((boolean)this.projectManager.getProjectById(this.id3).getAllContentRootsForRep(rep3).isEmpty());
        Assert.assertTrue((boolean)this.projectManager.getProjectById(this.id3).getContentRoots().isEmpty());
        HibernateUtil.currentSession().flush();
        HibernateUtil.clearSession();
        this.projectManager.deleteProject(this.projectManager.getProjectById(this.id3));
        this.projectManager.deleteProject(this.projectManager.getProjectById(this.id2));
        this.projectManager.deleteProject(this.projectManager.getProjectById(this.id1));
        Assert.assertFalse((boolean)this.projectManager.projectExists(this.id1));
        Assert.assertFalse((boolean)this.projectManager.projectExists(this.id2));
        Assert.assertFalse((boolean)this.projectManager.projectExists(this.id3));
        Assert.assertEquals((int)1, (int)this.projectManager.getAllProjects().size());
    }

    @Test
    public void testDeletingRepository() throws Exception {
        String rep1 = "repository1";
        String rep2 = "repository2";
        this.id1 = this.projectManager.createProject("project1", "A").getId();
        this.id2 = this.projectManager.createProject("project2", "B").getId();
        HibernateUtil.beginTransaction();
        Project project = this.projectManager.getProjectById(this.id1);
        project.setDefaultRepositoryName(rep1);
        HibernateUtil.commitTransaction();
        HibernateUtil.beginTransaction();
        project = this.projectManager.getProjectById(this.id2);
        project.setDefaultRepositoryName(rep2);
        HibernateUtil.commitTransaction();
        this.projectManager.addPathToProject(this.projectManager.getProjectById(this.id1).getProjKey(), rep1, "/test");
        this.projectManager.addPathToProject(this.projectManager.getProjectById(this.id1).getProjKey(), rep1, "/");
        this.projectManager.addPathToProject(this.projectManager.getProjectById(this.id1).getProjKey(), rep2, "/");
        this.projectManager.addPathToProject(this.projectManager.getProjectById(this.id2).getProjKey(), rep1, "/");
        Assert.assertEquals((String)rep1, (String)this.projectManager.getProjectById(this.id1).getDefaultRepositoryName());
        Assert.assertEquals((int)3, (int)this.projectManager.getProjectById(this.id1).getContentRoots().size());
        Assert.assertEquals((String)rep2, (String)this.projectManager.getProjectById(this.id2).getDefaultRepositoryName());
        Assert.assertEquals((int)1, (int)this.projectManager.getProjectById(this.id2).getContentRoots().size());
        this.projectManager.removeRepositoryMappings(rep1);
        Assert.assertEquals(null, (String)this.projectManager.getProjectById(this.id1).getDefaultRepositoryName());
        Assert.assertEquals((int)1, (int)this.projectManager.getProjectById(this.id1).getContentRoots().size());
        Assert.assertEquals((String)rep2, (String)this.projectManager.getProjectById(this.id2).getDefaultRepositoryName());
        Assert.assertEquals((int)0, (int)this.projectManager.getProjectById(this.id2).getContentRoots().size());
    }

    @Test
    public void testGetDefaultReviewerGroups_shouldReturnNormalizedNames() {
        String key = "A";
        HibernateUtil.beginTransaction();
        this.id1 = this.projectManager.createProject("project1", "A").getId();
        this.projectManager.addProjectDefaultReviewerGroup("A", "group1");
        this.projectManager.addProjectDefaultReviewerGroup("A", "group2");
        this.projectManager.addProjectDefaultReviewerGroup("A", "GROUP3");
        HibernateUtil.commitTransaction();
        HibernateUtil.clearSession();
        Project project = this.projectManager.getProjectById(this.id1);
        MatcherAssert.assertThat((Object)project.getDefaultReviewerGroups(), (Matcher)Matchers.is((Object)ImmutableSet.of((Object)"group1", (Object)"group2", (Object)"group3")));
    }

    @Test
    public void testGetAllowedReviewerGroups_shouldReturnNormalizedNames() {
        String key = "A";
        HibernateUtil.beginTransaction();
        this.id1 = this.projectManager.createProject("project1", "A").getId();
        this.projectManager.addProjectAllowedReviewerGroup("A", "group1");
        this.projectManager.addProjectAllowedReviewerGroup("A", "group2");
        this.projectManager.addProjectAllowedReviewerGroup("A", "GROUP3");
        HibernateUtil.commitTransaction();
        HibernateUtil.clearSession();
        Project project = this.projectManager.getProjectById(this.id1);
        MatcherAssert.assertThat((Object)project.getAllowedReviewerGroups(), (Matcher)Matchers.is((Object)ImmutableSet.of((Object)"group1", (Object)"group2", (Object)"group3")));
    }

    @Override
    @After
    public void tearDown() throws Exception {
        try {
            this.removeProject(this.id1);
            this.removeProject(this.id2);
            this.removeProject(this.id3);
            this.projectManager = null;
        }
        finally {
            HibernateUtil.closeSession();
            super.tearDown();
        }
    }
}

