/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.it.cvsrep.cache;

import com.atlassian.fisheye.rep.RevCountChecker;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.web.FisheyeContextLoader;
import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class ChangeSetTest {
    private RepositoryEngine engine;

    @Before
    public void setUp() throws Exception {
        Disposer.pushThreadInstance();
        RepositoryHandle handle = TestFishEyeInstances.getSanity1Repos();
        this.engine = handle.acquireEngine();
    }

    @After
    public void tearDown() throws Exception {
        FisheyeContextLoader.contextConfigurationResources = null;
        Disposer.popThreadInstance();
        TestFishEyeInstances.stop();
    }

    @Test
    public void testChangesetDetection() throws Exception {
        this.assertChangesetContents("MAIN:matt:20040505045207", new RevInfoKey[]{new RevInfoKey(new Path((CharSequence)"test/changeset/file1.txt"), "1.1"), new RevInfoKey(new Path((CharSequence)"test/changeset/file2.txt"), "1.1"), new RevInfoKey(new Path((CharSequence)"test/changeset/file3.txt"), "1.1")});
        this.assertChangesetContents("MAIN:matt:20040505045435", new RevInfoKey[]{new RevInfoKey(new Path((CharSequence)"test/changeset/file1.txt"), "1.2")});
        this.assertChangesetContents("MAIN:matt:20040505045435:1", new RevInfoKey[]{new RevInfoKey(new Path((CharSequence)"test/changeset/file1.txt"), "1.3")});
        this.assertChangesetContents("BRANCH1:matt:20040505054917", new RevInfoKey[]{new RevInfoKey(new Path((CharSequence)"test/changeset/file1.txt"), "1.3.2.1")});
        this.assertChangesetContents("MAIN:matt:20040505054917", new RevInfoKey[]{new RevInfoKey(new Path((CharSequence)"test/changeset/file1.txt"), "1.4")});
        this.assertChangesetContents("MAIN:matt:20040506034302", new RevInfoKey[]{new RevInfoKey(new Path((CharSequence)"test/changeset/file3.txt"), "1.2")});
        this.assertChangesetContents("MAIN:matt:20040506034413", new RevInfoKey[]{new RevInfoKey(new Path((CharSequence)"test/changeset/file1.txt"), "1.5"), new RevInfoKey(new Path((CharSequence)"test/changeset/file2.txt"), "1.2"), new RevInfoKey(new Path((CharSequence)"test/changeset/file3.txt"), "1.3")});
        this.assertChangesetContents("MAIN:matt:20041116235525", new RevInfoKey[]{new RevInfoKey(new Path((CharSequence)"test/branching/d.txt"), "1.1")});
        this.assertChangesetContents("BRANCH_1:matt:20041117000354", new RevInfoKey[]{new RevInfoKey(new Path((CharSequence)"test/branching/d.txt"), "1.1.2.2")});
        this.assertChangesetContents("BRANCH_1:matt:20041116235525", new RevInfoKey[]{new RevInfoKey(new Path((CharSequence)"test/branching/d.txt"), "1.1.2.1")});
        RevCountChecker.checkRevCounts(this.engine.getInternalRevisionCache());
    }

    private void assertChangesetContents(String csid, RevInfoKey[] expectedKeys) throws Exception {
        ChangeSet cs = this.engine.getRevisionCache().getChangeSet(csid);
        Assert.assertEquals((String)csid, (String)cs.getId());
        Assert.assertEquals((int)expectedKeys.length, (int)cs.getRevisionInfosCount());
        ArrayList<RevInfoKey> expected = new ArrayList<RevInfoKey>(Arrays.asList(expectedKeys));
        for (FileRevision found : cs.getFileRevisions()) {
            assert (expected.contains(found.getRevInfoKey()));
            expected.remove(found.getRevInfoKey());
        }
        Assert.assertTrue((boolean)expected.isEmpty());
    }
}

