/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.it.cvsrep;

import com.cenqua.fisheye.cvsrep.RepSanityTestBase;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.search.SearchResults;
import org.junit.Test;

public final class RepSanity2Test
extends RepSanityTestBase {
    @Override
    protected RepositoryHandle whichHandle() throws Exception {
        return TestFishEyeInstances.reslurpAndGetSanity1Repos2();
    }

    @Test
    public void testTagUpdates() throws Exception {
        this.assertTagsStage0();
        TestFishEyeInstances.advanceSanity1Repos2(1);
        this.assertTagsStage1();
        TestFishEyeInstances.advanceSanity1Repos2(2);
        this.assertTagsStage2();
        TestFishEyeInstances.advanceSanity1Repos2(3);
        this.assertTagsStage3();
    }

    private void assertTagsStage3() throws Exception {
        SearchResults results = this.doQuery("select revisions where path like /CleanSweeper.java and tagged > T1 ");
        this.assertResultsSize(0, results);
        results = this.doQuery("select revisions where path like /CleanSweeper.java and tagged < T1 ");
        this.assertResultsSize(0, results);
        results = this.doQuery("select revisions where path like /CleanSweeper.java and tagged T1 ");
        this.assertResultsSize(0, results);
    }

    private void assertTagsStage2() throws Exception {
        SearchResults results = this.doQuery("select revisions where path like /CleanSweeper.java and tagged > T1 ");
        this.assertResultsSize(0, results);
        results = this.doQuery("select revisions where path like /CleanSweeper.java and tagged < T1 ");
        this.assertResultsSize(9, results);
        this.assertResultsContain("CleanSweeper.java", "1.9", results);
        this.assertResultsContain("CleanSweeper.java", "1.8", results);
        this.assertResultsContain("CleanSweeper.java", "1.7", results);
        this.assertResultsContain("CleanSweeper.java", "1.6", results);
        this.assertResultsContain("CleanSweeper.java", "1.5", results);
        this.assertResultsContain("CleanSweeper.java", "1.4", results);
        this.assertResultsContain("CleanSweeper.java", "1.3", results);
        this.assertResultsContain("CleanSweeper.java", "1.2", results);
        this.assertResultsContain("CleanSweeper.java", "1.1", results);
        results = this.doQuery("select revisions where path like /CleanSweeper.java and tagged > T2 ");
        this.assertResultsSize(3, results);
        this.assertResultsContain("CleanSweeper.java", "1.10", results);
        this.assertResultsContain("CleanSweeper.java", "1.9.6.1", results);
        this.assertResultsContain("CleanSweeper.java", "1.9.6.2", results);
    }

    private void assertTagsStage1() throws Exception {
        SearchResults results = this.doQuery("select revisions where path like /CleanSweeper.java and tagged > T1 ");
        this.assertResultsSize(4, results);
        this.assertResultsContain("CleanSweeper.java", "1.10", results);
        this.assertResultsContain("CleanSweeper.java", "1.9", results);
        this.assertResultsContain("CleanSweeper.java", "1.9.6.1", results);
        this.assertResultsContain("CleanSweeper.java", "1.9.6.2", results);
        results = this.doQuery("select revisions where path like /CleanSweeper.java and tagged < T1 ");
        this.assertResultsSize(7, results);
        this.assertResultsContain("CleanSweeper.java", "1.7", results);
        this.assertResultsContain("CleanSweeper.java", "1.6", results);
        this.assertResultsContain("CleanSweeper.java", "1.5", results);
        this.assertResultsContain("CleanSweeper.java", "1.4", results);
        this.assertResultsContain("CleanSweeper.java", "1.3", results);
        this.assertResultsContain("CleanSweeper.java", "1.2", results);
        this.assertResultsContain("CleanSweeper.java", "1.1", results);
        results = this.doQuery("select revisions where path like /CleanSweeper.java and tagged > T2 ");
        this.assertResultsSize(3, results);
        this.assertResultsContain("CleanSweeper.java", "1.10", results);
        this.assertResultsContain("CleanSweeper.java", "1.9.6.1", results);
        this.assertResultsContain("CleanSweeper.java", "1.9.6.2", results);
    }

    private void assertTagsStage0() throws Exception {
        SearchResults results = this.doQuery("select revisions where path like /CleanSweeper.java and tagged > T1 ");
        this.assertResultsSize(3, results);
        this.assertResultsContain("CleanSweeper.java", "1.9", results);
        this.assertResultsContain("CleanSweeper.java", "1.9.6.1", results);
        this.assertResultsContain("CleanSweeper.java", "1.9.6.2", results);
        results = this.doQuery("select revisions where path like /CleanSweeper.java and tagged < T1 ");
        this.assertResultsSize(7, results);
        this.assertResultsContain("CleanSweeper.java", "1.7", results);
        this.assertResultsContain("CleanSweeper.java", "1.6", results);
        this.assertResultsContain("CleanSweeper.java", "1.5", results);
        this.assertResultsContain("CleanSweeper.java", "1.4", results);
        this.assertResultsContain("CleanSweeper.java", "1.3", results);
        this.assertResultsContain("CleanSweeper.java", "1.2", results);
        this.assertResultsContain("CleanSweeper.java", "1.1", results);
        results = this.doQuery("select revisions where path like /CleanSweeper.java and tagged > T2 ");
        this.assertResultsSize(2, results);
        this.assertResultsContain("CleanSweeper.java", "1.9.6.1", results);
        this.assertResultsContain("CleanSweeper.java", "1.9.6.2", results);
    }
}

