/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.it.cvsrep;

import com.cenqua.fisheye.DiffTestUtils;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.cvsrep.RepSanityTestBase;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.search.SearchResults;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public final class RepSanity1Test
extends RepSanityTestBase {
    @Override
    protected RepositoryHandle whichHandle() throws Exception {
        return TestFishEyeInstances.getSanity1Repos();
    }

    @Test
    public void testCheckDiffs() throws DbException {
        DiffTestUtils.checkDiffs(this.engine.getPathMatcher(), this.engine.getRevisionCache());
    }

    @Test
    public void testFindAuthors() throws Exception {
        RevisionCache cache = this.engine.getRevisionCache();
        List authors = cache.findAuthors(Path.ROOT);
        RepSanity1Test.assertListsEquals(new String[]{"adler", "anthony", "bill", "blah", "brendan", "conor", "cris", "cristi", "daniel", "fharenheit", "jhead", "leanne", "matt", "mikew", "pete", "sberlin", "sdaswani", "stefan", "test user", "tmh", "verdyp"}, authors);
    }

    @Test
    public void testFindAuthorsInDirectory() throws Exception {
        RevisionCache cache = this.engine.getRevisionCache();
        List authors = cache.findAuthors(new Path((CharSequence)"/test/test/t2"));
        RepSanity1Test.assertListsEquals(new String[]{"matt"}, authors);
    }

    @Test
    public void testFindAuthorsInSvn() throws Exception {
        RevisionCache cache = TestFishEyeInstances.getSanity1SvnRepo().acquireEngine().getRevisionCache();
        List authors = cache.findAuthors(Path.ROOT);
        RepSanity1Test.assertListsEquals(new String[]{"czawadka", "ervzijst", "glewandowski", "lukpater", "seb"}, authors);
    }

    @Test
    public void testFindAuthorsInSvnDirectory() throws Exception {
        RevisionCache cache = TestFishEyeInstances.getSanity1SvnRepo().acquireEngine().getRevisionCache();
        List authors = cache.findAuthors(new Path((CharSequence)"/test/"));
        RepSanity1Test.assertListsEquals(new String[]{"seb"}, authors);
    }

    private static void assertListsEquals(String[] expected, List<String> list) {
        Assert.assertEquals(Arrays.asList(expected), list);
    }

    @Test
    public void testSimpleEyeQL() throws Exception {
        SearchResults results = this.doQuery("select revisions where path like /test/support/thread1308/readme and is head on yoyo");
        this.assertResultsSize(1, results);
        this.assertResultsContain("test/support/thread1308/readme", "1.1.1.1", results);
        results = this.doQuery("select revisions where path like /test/support/thread1308/readme and is head");
        this.assertResultsSize(3, results);
        this.assertResultsContain("test/support/thread1308/readme", "1.3", results);
        this.assertResultsContain("test/support/thread1308/readme", "1.1.1.1", results);
        this.assertResultsContain("test/support/thread1308/readme", "1.3.2.1", results);
    }

    @Test
    public void testSelectAllRevisions() throws Exception {
        IntSet expectedResults = this.findAllRevisions();
        this.assertMatchesAllRevisions("select revisions where path like *", expectedResults);
        this.assertMatchesAllRevisions("select revisions", expectedResults);
        this.assertMatchesAllRevisions("select revisions from dir /", expectedResults);
    }

    private void assertMatchesAllRevisions(String ql, IntSet expectedResults) throws Exception {
        SearchResults results = this.doQuery(ql);
        Assert.assertEquals((int)expectedResults.size(), (int)results.size());
        SearchResults.RevisionResultsIterator iter = results.iterateRevisions(0);
        while (iter.hasNext()) {
            int foundId = iter.nextItemId();
            Assert.assertTrue((boolean)expectedResults.contains(foundId));
        }
    }

    private IntSet findAllRevisions() throws Exception {
        IntOpenHashSet result = new IntOpenHashSet();
        this.findAllRevisions(Path.ROOT, (IntSet)result);
        return result;
    }

    private void findAllRevisions(Path path, IntSet result) throws Exception {
        Path[] dirs;
        Path[] files;
        RevisionCache cache = this.engine.getRevisionCache();
        for (Path file : files = cache.listFiles(path)) {
            FileHistory hist = cache.getFileHistory(file);
            for (Object o : hist.getRevisions()) {
                FileRevision fi = (FileRevision)o;
                result.add(fi.getRevID());
            }
        }
        for (Path dir : dirs = cache.listDirs(path)) {
            this.findAllRevisions(dir, result);
        }
    }

    @Test
    public void testNotNotQL() throws Exception {
        this.doQuery("select revisions where not is head and not is dead");
        this.doQuery("select revisions where not is head and not not not is dead");
        this.doQuery("select revisions where not is head or not is dead");
    }

    @Test
    public void testCommentsEyeQL() throws Exception {
        SearchResults results = this.doQuery("select revisions where path like /test/CleanSweeper.java and comment matches 'more'");
        this.assertResultsSize(2, results);
        this.assertResultsContain("test/CleanSweeper.java", "1.6", results);
        this.assertResultsContain("test/CleanSweeper.java", "1.5", results);
        results = this.doQuery("select revisions where path like /test/CleanSweeper.java and comment = 'NONE: remove printlns, new log4j cfg\\n'");
        this.assertResultsSize(1, results);
        this.assertResultsContain("test/CleanSweeper.java", "1.9", results);
        results = this.doQuery("select revisions where path like /test/CleanSweeper.java and comment =~ '^NONE.+queue'");
        this.assertResultsSize(1, results);
        this.assertResultsContain("test/CleanSweeper.java", "1.9.6.1", results);
        results = this.doQuery("select revisions from dir test where comment =~ 'second revisions'");
        this.assertResultsSize(3, results);
        this.assertResultsContain("test/branching/a.txt", "1.2", results);
        this.assertResultsContain("test/branching/b.txt", "1.2", results);
        this.assertResultsContain("test/branching/c.txt", "1.2", results);
        results = this.doQuery("select revisions from dir test where comment matches 'second revisions'");
        this.assertResultsSize(3, results);
        this.assertResultsContain("test/branching/a.txt", "1.2", results);
        this.assertResultsContain("test/branching/b.txt", "1.2", results);
        this.assertResultsContain("test/branching/c.txt", "1.2", results);
    }

    @Test
    public void testOnBranchEyeQL() throws Exception {
        SearchResults results = this.doQuery("select revisions from dir /test/branching where on branch BRANCH_1");
        this.assertResultsSize(9, results);
        this.assertResultsContain("test/branching/a.txt", "1.2", results);
        this.assertResultsContain("test/branching/a.txt", "1.2.2.1", results);
        this.assertResultsContain("test/branching/b.txt", "1.2", results);
        this.assertResultsContain("test/branching/b.txt", "1.2.2.1", results);
        this.assertResultsContain("test/branching/c.txt", "1.2", results);
        this.assertResultsContain("test/branching/c.txt", "1.2.2.1", results);
        this.assertResultsContain("test/branching/d.txt", "1.1", results);
        this.assertResultsContain("test/branching/d.txt", "1.1.2.1", results);
        this.assertResultsContain("test/branching/d.txt", "1.1.2.2", results);
        results = this.doQuery("select revisions from dir /test/branching where modified on branch BRANCH_1");
        this.assertResultsSize(5, results);
        this.assertResultsContain("test/branching/a.txt", "1.2.2.1", results);
        this.assertResultsContain("test/branching/b.txt", "1.2.2.1", results);
        this.assertResultsContain("test/branching/c.txt", "1.2.2.1", results);
        this.assertResultsContain("test/branching/d.txt", "1.1.2.1", results);
        this.assertResultsContain("test/branching/d.txt", "1.1.2.2", results);
        results = this.doQuery("select revisions from dir /test/branching where deleted on branch BRANCH_1");
        this.assertResultsSize(1, results);
        this.assertResultsContain("test/branching/c.txt", "1.2.2.1", results);
        results = this.doQuery("select revisions from dir /test/branching where deleted on branch MAIN");
        this.assertResultsSize(1, results);
        this.assertResultsContain("test/branching/d.txt", "1.1", results);
        results = this.doQuery("select revisions from dir /test/branching where added on branch BRANCH_1");
        this.assertResultsSize(2, results);
        this.assertResultsContain("test/branching/d.txt", "1.1.2.1", results);
        this.assertResultsContain("test/branching/d.txt", "1.1.2.2", results);
        results = this.doQuery("select revisions from dir /test/branching where added on branch MAIN");
        this.assertResultsSize(6, results);
        this.assertResultsContain("test/branching/a.txt", "1.1", results);
        this.assertResultsContain("test/branching/a.txt", "1.2", results);
        this.assertResultsContain("test/branching/b.txt", "1.1", results);
        this.assertResultsContain("test/branching/b.txt", "1.2", results);
        this.assertResultsContain("test/branching/c.txt", "1.1", results);
        this.assertResultsContain("test/branching/c.txt", "1.2", results);
    }

    @Test
    public void testTaggedEyeQL() throws Exception {
        String qstart = "select revisions where path like test/CleanSweeper.java ";
        SearchResults results = this.doQuery(qstart + "and tagged build-114");
        this.assertResultsSize(1, results);
        this.assertResultsContain("test/CleanSweeper.java", "1.8", results);
        results = this.doQuery(qstart + "and tagged = build-114");
        this.assertResultsSize(1, results);
        this.assertResultsContain("test/CleanSweeper.java", "1.8", results);
        results = this.doQuery(qstart + "and tagged == build-114");
        this.assertResultsSize(1, results);
        this.assertResultsContain("test/CleanSweeper.java", "1.8", results);
        results = this.doQuery(qstart + "and tagged != build-114");
        this.assertResultsSize(10, results);
        this.assertResultsContain("test/CleanSweeper.java", "1.1", results);
        this.assertResultsContain("test/CleanSweeper.java", "1.2", results);
        this.assertResultsContain("test/CleanSweeper.java", "1.3", results);
        this.assertResultsContain("test/CleanSweeper.java", "1.4", results);
        this.assertResultsContain("test/CleanSweeper.java", "1.5", results);
        this.assertResultsContain("test/CleanSweeper.java", "1.6", results);
        this.assertResultsContain("test/CleanSweeper.java", "1.7", results);
        this.assertResultsContain("test/CleanSweeper.java", "1.9", results);
        this.assertResultsContain("test/CleanSweeper.java", "1.9.6.2", results);
        this.assertResultsContain("test/CleanSweeper.java", "1.9.6.1", results);
        results = this.doQuery(qstart + "and tagged > build-114");
        this.assertResultsSize(3, results);
        this.assertResultsContain("test/CleanSweeper.java", "1.9", results);
        this.assertResultsContain("test/CleanSweeper.java", "1.9.6.1", results);
        this.assertResultsContain("test/CleanSweeper.java", "1.9.6.2", results);
        results = this.doQuery(qstart + "and tagged >= build-114");
        this.assertResultsSize(4, results);
        this.assertResultsContain("test/CleanSweeper.java", "1.8", results);
        this.assertResultsContain("test/CleanSweeper.java", "1.9", results);
        this.assertResultsContain("test/CleanSweeper.java", "1.9.6.1", results);
        this.assertResultsContain("test/CleanSweeper.java", "1.9.6.2", results);
        results = this.doQuery(qstart + "and tagged < build-114");
        this.assertResultsSize(7, results);
        this.assertResultsContain("test/CleanSweeper.java", "1.7", results);
        this.assertResultsContain("test/CleanSweeper.java", "1.6", results);
        this.assertResultsContain("test/CleanSweeper.java", "1.5", results);
        this.assertResultsContain("test/CleanSweeper.java", "1.4", results);
        this.assertResultsContain("test/CleanSweeper.java", "1.3", results);
        this.assertResultsContain("test/CleanSweeper.java", "1.2", results);
        this.assertResultsContain("test/CleanSweeper.java", "1.1", results);
        results = this.doQuery(qstart + "and tagged <= build-114");
        this.assertResultsSize(8, results);
        this.assertResultsContain("test/CleanSweeper.java", "1.8", results);
        this.assertResultsContain("test/CleanSweeper.java", "1.7", results);
        this.assertResultsContain("test/CleanSweeper.java", "1.6", results);
        this.assertResultsContain("test/CleanSweeper.java", "1.5", results);
        this.assertResultsContain("test/CleanSweeper.java", "1.4", results);
        this.assertResultsContain("test/CleanSweeper.java", "1.3", results);
        this.assertResultsContain("test/CleanSweeper.java", "1.2", results);
        this.assertResultsContain("test/CleanSweeper.java", "1.1", results);
        results = this.doQuery(qstart + "and between tags (build-114, build-115)");
        this.assertResultsSize(0, results);
        results = this.doQuery(qstart + "and between tags (build-114, build-122)");
        this.assertResultsSize(0, results);
        results = this.doQuery(qstart + "and between tags [build-114, build-122)");
        this.assertResultsSize(1, results);
        this.assertResultsContain("test/CleanSweeper.java", "1.8", results);
        results = this.doQuery(qstart + "and between tags (build-114, build-122]");
        this.assertResultsSize(1, results);
        this.assertResultsContain("test/CleanSweeper.java", "1.9", results);
        results = this.doQuery(qstart + "and between tags [build-114, build-122]");
        this.assertResultsSize(2, results);
        this.assertResultsContain("test/CleanSweeper.java", "1.8", results);
        this.assertResultsContain("test/CleanSweeper.java", "1.9", results);
    }

    @Test
    public void testStateEyeQL() throws Exception {
        SearchResults results = this.doQuery("select revisions from dir /test/branching where is added");
        this.assertResultsSize(4, results);
        this.assertResultsContain("test/branching/a.txt", "1.1", results);
        this.assertResultsContain("test/branching/b.txt", "1.1", results);
        this.assertResultsContain("test/branching/c.txt", "1.1", results);
        this.assertResultsContain("test/branching/d.txt", "1.1.2.1", results);
        results = this.doQuery("select revisions from dir /test/branching where is deleted");
        this.assertResultsSize(2, results);
        this.assertResultsContain("test/branching/c.txt", "1.2.2.1", results);
        this.assertResultsContain("test/branching/d.txt", "1.1", results);
    }

    @Test
    public void testDateEyeQL() throws Exception {
        String qlstart = "select revisions where path like /test/support/thread1308/readme and ";
        SearchResults results = this.doQuery("select revisions where path like /test/support/thread1308/readme and date in [2003-02-14T06:02:23Z, 2005-01-13T03:28:02Z]");
        this.assertResultsSize(5, results);
        this.assertResultsContain("test/support/thread1308/readme", "1.1", results);
        this.assertResultsContain("test/support/thread1308/readme", "1.2", results);
        this.assertResultsContain("test/support/thread1308/readme", "1.3", results);
        this.assertResultsContain("test/support/thread1308/readme", "1.1.1.1", results);
        this.assertResultsContain("test/support/thread1308/readme", "1.3.2.1", results);
        results = this.doQuery("select revisions where path like /test/support/thread1308/readme and date in (2003-02-14T06:02:23Z, 2005-01-13T03:28:02Z)");
        this.assertResultsSize(2, results);
        this.assertResultsContain("test/support/thread1308/readme", "1.2", results);
        this.assertResultsContain("test/support/thread1308/readme", "1.3", results);
        results = this.doQuery("select revisions where path like /test/support/thread1308/readme and date in (2003-02-14T06:02:23Z, 2005-01-13T03:28:02Z]");
        this.assertResultsSize(3, results);
        this.assertResultsContain("test/support/thread1308/readme", "1.2", results);
        this.assertResultsContain("test/support/thread1308/readme", "1.3", results);
        this.assertResultsContain("test/support/thread1308/readme", "1.3.2.1", results);
        results = this.doQuery("select revisions where path like /test/support/thread1308/readme and date in [2003-02-14T06:02:23Z, 2005-01-13T03:28:02Z)");
        this.assertResultsSize(4, results);
        this.assertResultsContain("test/support/thread1308/readme", "1.1", results);
        this.assertResultsContain("test/support/thread1308/readme", "1.2", results);
        this.assertResultsContain("test/support/thread1308/readme", "1.3", results);
        this.assertResultsContain("test/support/thread1308/readme", "1.1.1.1", results);
        results = this.doQuery("select revisions where path like /test/support/thread1308/readme and date == 2003-02-14T06:02:23Z");
        this.assertResultsSize(2, results);
        this.assertResultsContain("test/support/thread1308/readme", "1.1", results);
        this.assertResultsContain("test/support/thread1308/readme", "1.1.1.1", results);
        results = this.doQuery("select revisions where path like /test/support/thread1308/readme and date == 2005-01-13T03:26:14Z");
        this.assertResultsSize(1, results);
        this.assertResultsContain("test/support/thread1308/readme", "1.2", results);
        results = this.doQuery("select revisions where path like /test/support/thread1308/readme and date != 2005-01-13T03:26:14Z");
        this.assertResultsSize(4, results);
        this.assertResultsContain("test/support/thread1308/readme", "1.1", results);
        this.assertResultsContain("test/support/thread1308/readme", "1.3", results);
        this.assertResultsContain("test/support/thread1308/readme", "1.1.1.1", results);
        this.assertResultsContain("test/support/thread1308/readme", "1.3.2.1", results);
        results = this.doQuery("select revisions where path like /test/support/thread1308/readme and date < 2005-01-13T03:26:14Z");
        this.assertResultsSize(2, results);
        this.assertResultsContain("test/support/thread1308/readme", "1.1", results);
        this.assertResultsContain("test/support/thread1308/readme", "1.1.1.1", results);
        results = this.doQuery("select revisions where path like /test/support/thread1308/readme and date <= 2005-01-13T03:26:14Z");
        this.assertResultsSize(3, results);
        this.assertResultsContain("test/support/thread1308/readme", "1.1", results);
        this.assertResultsContain("test/support/thread1308/readme", "1.2", results);
        this.assertResultsContain("test/support/thread1308/readme", "1.1.1.1", results);
        results = this.doQuery("select revisions where path like /test/support/thread1308/readme and date > 2005-01-13T03:26:14Z");
        this.assertResultsSize(2, results);
        this.assertResultsContain("test/support/thread1308/readme", "1.3", results);
        this.assertResultsContain("test/support/thread1308/readme", "1.3.2.1", results);
        results = this.doQuery("select revisions where path like /test/support/thread1308/readme and date >= 2005-01-13T03:26:14Z");
        this.assertResultsSize(3, results);
        this.assertResultsContain("test/support/thread1308/readme", "1.2", results);
        this.assertResultsContain("test/support/thread1308/readme", "1.3", results);
        this.assertResultsContain("test/support/thread1308/readme", "1.3.2.1", results);
    }

    @Test
    public void testContentsEyeQL() throws Exception {
        String qlstart = "select revisions where ";
        SearchResults results = this.doQuery("select revisions where path like /test/IdeaBuilder.java and content matches IdeaBuilder");
        this.assertResultsSize(1, results);
        this.assertResultsContain("test/IdeaBuilder.java", "1.9", results);
        results = this.doQuery("select revisions where content matches IdeaBuilder");
        this.assertResultsSize(1, results);
        this.assertResultsContain("test/IdeaBuilder.java", "1.9", results);
        results = this.doQuery("select revisions where path like /test/IdeaBuilder.java and content matches notfoundatall");
        this.assertResultsSize(0, results);
    }
}

