/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.it.cvsrep;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.rep.AncestorLink;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.util.Disposer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class CommonDaoSanity1Test {
    private RepositoryEngine engine;

    @Before
    public void setUp() throws Exception {
        TestFishEyeInstances.checkCleanStart();
        Disposer.pushThreadInstance();
        RepositoryHandle handle = TestFishEyeInstances.getSanity1Repos();
        this.engine = handle.acquireEngine();
    }

    @After
    public void tearDown() throws Exception {
        Disposer.popThreadInstance();
        TestFishEyeInstances.stop();
        TestFishEyeInstances.checkCleanStart();
    }

    @Test
    public void testBasicProperties() throws Exception {
        RevisionCache cache = this.engine.getRevisionCache();
        FileHistory hist = cache.getFileHistory(new Path((CharSequence)"test/CleanSweeper.java"));
        Assert.assertNotNull((Object)hist);
        FileRevision ri = hist.getRevision("1.9");
        Assert.assertNotNull((Object)ri);
        Assert.assertTrue((boolean)ri.isTrunkLike());
        this.assertSameContent(new String[]{"PROD_136", "CHALK", "JMSIFY"}, ri.getBranchPoints());
        this.assertSameContent(new String[]{"build-136", "build-135", "build-134", "build-133", "build-132", "build-131", "build-130", "build-129", "build-128", "build-127", "build-126", "build-125", "build-124", "build-123", "build-122", "CHALK_t3", "CHALK_t2", "CHALK_t1", "JMSIFY_BP", "PROD_136$BP", "CHALK$BP", "JMSIFY$BP"}, ri.getTags());
        ri = hist.getRevision("1.8");
        Assert.assertNotNull((Object)ri);
        Assert.assertTrue((boolean)ri.isTrunkLike());
        this.assertSameContent(new String[0], ri.getBranchPoints());
        this.assertSameContent(new String[]{"build-121", "build-120", "build-119", "build-118", "build-117", "build-116", "build-115", "build-114", "build-113", "build-112", "build-111", "build-110", "build-109", "build-108"}, ri.getTags());
        ri = hist.getRevision("1.9.6.1");
        Assert.assertNotNull((Object)ri);
        Assert.assertFalse((boolean)ri.isTrunkLike());
        ri = hist.getRevision("1.9.6.2");
        Assert.assertNotNull((Object)ri);
        Assert.assertFalse((boolean)ri.isTrunkLike());
    }

    @Test
    public void testAncestorLinks() throws Exception {
        this.assertAncestorNull("test/branching/c.txt", "1.1");
        this.assertAncestorEquals("test/branching/c.txt", "1.2", "test/branching/c.txt", "1.1", AncestorLink.Type.DIRECT);
        this.assertAncestorEquals("test/branching/c.txt", "1.2.2.1", "test/branching/c.txt", "1.2", AncestorLink.Type.BRANCHPOINT);
        this.assertAncestorEquals("test/branching/c.txt", "1.2.4.1", "test/branching/c.txt", "1.2", AncestorLink.Type.BRANCHPOINT);
        this.assertAncestorEquals("test/branching/c.txt", "1.2.4.1.2.1", "test/branching/c.txt", "1.2.4.1", AncestorLink.Type.BRANCHPOINT);
    }

    private void assertAncestorNull(String path, String rev) throws DbException {
        RevisionCache cache = this.engine.getRevisionCache();
        FileRevision ri = cache.getFileRevision(new RevInfoKey(new Path((CharSequence)path), rev));
        Assert.assertNull((Object)ri.getAncestorLink());
    }

    private void assertAncestorEquals(String path, String rev, String expectedAncestorPath, String expectedAncestorRev, AncestorLink.Type expectedAncestorType) throws DbException {
        RevisionCache cache = this.engine.getRevisionCache();
        FileRevision ri = cache.getFileRevision(new RevInfoKey(new Path((CharSequence)path), rev));
        AncestorLink link = ri.getAncestorLink();
        Assert.assertNotNull((Object)link);
        RevInfoKey expectedAncestorKey = new RevInfoKey(new Path((CharSequence)expectedAncestorPath), expectedAncestorRev);
        FileRevision expectedAncestor = cache.getFileRevision(expectedAncestorKey);
        Assert.assertNotNull((Object)expectedAncestor);
        List ancestorRevs = ri.getAncestors();
        Assert.assertEquals((int)1, (int)ancestorRevs.size());
        Assert.assertEquals((Object)expectedAncestorKey, ancestorRevs.get(0));
        Assert.assertEquals((int)1, (int)link.getRevids().size());
        Assert.assertEquals((int)expectedAncestor.getRevID(), (int)link.getRevids().getInt(0));
        Assert.assertEquals((Object)expectedAncestorType, (Object)link.getType());
    }

    private void assertSameContent(Object[] expected, Collection c) {
        Assert.assertEquals(new TreeSet<Object>(Arrays.asList(expected)), new TreeSet(c));
        Assert.assertEquals((int)expected.length, (int)c.size());
    }
}

