/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.it.cvsrep;

import com.cenqua.fisheye.diff.Diff;
import com.cenqua.fisheye.diff.DiffInfo;
import com.cenqua.fisheye.diff.DiffOpts;
import com.cenqua.fisheye.diff.DiffSequences;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.diff.HunkList;
import com.cenqua.fisheye.diff.LineComparator;
import com.cenqua.fisheye.diff.Section;
import com.cenqua.fisheye.diff.TextFileDiffSequences;
import com.cenqua.fisheye.diff.view.FileDiffExplorer;
import com.cenqua.fisheye.io.IndexedLineReader;
import com.cenqua.fisheye.io.StreamIndexedLineReader;
import com.cenqua.fisheye.syntax.SyntaxDefinition;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class CRU1085Test
extends TestCase {
    private static final String FILE1 = "test/testfiles/CRU1085/frxDisplay.tag.9370";
    private static final String FILE2 = "test/testfiles/CRU1085/frxDisplay.tag.9374";

    public void testSanity() throws Exception {
        this.assertSanity("test/testfiles/CRU1085/small.a.txt", "test/testfiles/CRU1085/small.b.txt");
        this.assertSanity(FILE1, FILE2);
    }

    public void testCBL597() throws Exception {
        String file1 = "test/testfiles/CBL597/HTTPUploader.java.1.215";
        String file2 = "test/testfiles/CBL597/HTTPUploader.java.1.215.12.1";
        this.assertSanity(file1, file2);
        this.assertSanity(file2, file1);
    }

    private void assertSanity(String filename1, String filename2) throws Exception {
        this.assertSanity(filename1, filename2, (LineComparator)LineComparator.IDENTICAL);
        this.assertSanity(filename1, filename2, LineComparator.fromDiffOption((DiffOpts)new DiffOpts("w")));
        this.assertSanity(filename1, filename2, LineComparator.fromDiffOption((DiffOpts)new DiffOpts("b")));
        this.assertSanity(filename1, filename2, LineComparator.fromDiffOption((DiffOpts)new DiffOpts("B")));
        this.assertSanity(filename1, filename2, LineComparator.fromDiffOption((DiffOpts)new DiffOpts("Bb")));
        this.assertSanity(filename1, filename2, LineComparator.fromDiffOption((DiffOpts)new DiffOpts("Bw")));
        this.assertSanity(filename1, filename2, LineComparator.fromDiffOption((DiffOpts)new DiffOpts("Bwb")));
    }

    private void assertSanity(String filename1, String filename2, LineComparator lc) throws Exception {
        File file1 = new File(FisheyeTestEnv.WORKSPACE_DIR, filename1);
        File file2 = new File(FisheyeTestEnv.WORKSPACE_DIR, filename2);
        StreamIndexedLineReader lineReader1 = new StreamIndexedLineReader(file1);
        StreamIndexedLineReader lineReader2 = new StreamIndexedLineReader(file2);
        HunkList hunks = Diff.diff((DiffSequences)new TextFileDiffSequences((IndexedLineReader)lineReader1, (IndexedLineReader)lineReader2, lc));
        lineReader1.seekLine(0);
        lineReader2.seekLine(0);
        DiffOpts opts = new DiffOpts();
        opts.setSideBySide(false);
        opts.setSoftWrap(false);
        FileDiffExplorer de = new FileDiffExplorer((IndexedLineReader)lineReader1, (IndexedLineReader)lineReader2, hunks, new DiffInfo("testrep", file1.getName(), file1.getAbsolutePath(), "9370", file2.getAbsolutePath(), "9374"), SyntaxDefinition.PASS_THRU, opts);
        int maxlines = Math.max(lineReader1.getTotalLines(), lineReader2.getTotalLines());
        for (int context = -1; context <= maxlines * 2; ++context) {
            de.setContextLines(context);
            this.assertSanity(de.getSections());
        }
        lineReader1.close();
        lineReader2.close();
    }

    private void assertSanity(List<Section> sections) {
        int toLineno = 0;
        int fromLineno = 0;
        for (Section s : sections) {
            CRU1085Test.assertTrue((String)(toLineno + " vs " + s.getToStart()), (toLineno <= s.getToStart() ? 1 : 0) != 0);
            toLineno = s.getToStart() + s.getToLength();
            CRU1085Test.assertTrue((String)(fromLineno + " vs " + s.getFromStart()), (fromLineno <= s.getFromStart() ? 1 : 0) != 0);
            fromLineno = s.getFromStart() + s.getFromLength();
            if (!s.isCommonSubsequence()) continue;
            CRU1085Test.assertEquals((int)s.getFromLength(), (int)s.getToLength());
        }
    }

    public void testContext() throws Exception {
        String fa = "test/testfiles/CRU1085/small.a.txt";
        String fb = "test/testfiles/CRU1085/small.b.txt";
        LineComparator lc = LineComparator.fromDiffOption((DiffOpts)new DiffOpts("Bw"));
        ArrayList<Object> expected = new ArrayList<Section>();
        CRU1085Test.addAdd(expected, 1, 1, 1);
        CRU1085Test.addDel(expected, 2, 3, 3);
        CRU1085Test.addAdd(expected, 5, 4, 5);
        this.subtestDiff(expected, lc, fa, fb, 0);
        expected = new ArrayList();
        CRU1085Test.addAdd(expected, 1, 1, 1);
        CRU1085Test.addCom(expected, 1, 1, 2, 2);
        CRU1085Test.addDel(expected, 2, 3, 3);
        CRU1085Test.addCom(expected, 4, 4, 3, 3);
        CRU1085Test.addAdd(expected, 5, 4, 5);
        CRU1085Test.addCom(expected, 5, 6, 6, 7);
        CRU1085Test.addAdd(expected, 7, 8, 10, true);
        CRU1085Test.addCom(expected, 7, 15, 11, 19);
        CRU1085Test.addAdd(expected, 16, 20, 22, true);
        CRU1085Test.addCom(expected, 16, 23, 23, 30);
        this.subtestDiff(expected, lc, fa, fb, -1);
        expected = new ArrayList();
        CRU1085Test.addAdd(expected, 1, 1, 1);
        CRU1085Test.addCom(expected, 1, 1, 2, 2);
        CRU1085Test.addDel(expected, 2, 3, 3);
        CRU1085Test.addCom(expected, 4, 4, 3, 3);
        CRU1085Test.addAdd(expected, 5, 4, 5);
        CRU1085Test.addCom(expected, 5, 6, 6, 7);
        CRU1085Test.addAdd(expected, 7, 8, 10, true);
        CRU1085Test.addCom(expected, 7, 7, 11, 11);
        this.subtestDiff(expected, lc, fa, fb, 1);
        expected = new ArrayList();
        CRU1085Test.addAdd(expected, 1, 1, 1);
        CRU1085Test.addCom(expected, 1, 1, 2, 2);
        CRU1085Test.addDel(expected, 2, 3, 3);
        CRU1085Test.addCom(expected, 4, 4, 3, 3);
        CRU1085Test.addAdd(expected, 5, 4, 5);
        CRU1085Test.addCom(expected, 5, 6, 6, 7);
        CRU1085Test.addAdd(expected, 7, 8, 10, true);
        CRU1085Test.addCom(expected, 7, 8, 11, 12);
        this.subtestDiff(expected, lc, fa, fb, 2);
        expected = new ArrayList();
        CRU1085Test.addAdd(expected, 1, 1, 1);
        CRU1085Test.addCom(expected, 1, 1, 2, 2);
        CRU1085Test.addDel(expected, 2, 3, 3);
        CRU1085Test.addCom(expected, 4, 4, 3, 3);
        CRU1085Test.addAdd(expected, 5, 4, 5);
        CRU1085Test.addCom(expected, 5, 6, 6, 7);
        CRU1085Test.addAdd(expected, 7, 8, 10, true);
        CRU1085Test.addCom(expected, 7, 9, 11, 13);
        this.subtestDiff(expected, lc, fa, fb, 3);
        expected = new ArrayList();
        CRU1085Test.addAdd(expected, 1, 1, 1);
        CRU1085Test.addCom(expected, 1, 1, 2, 2);
        CRU1085Test.addDel(expected, 2, 3, 3);
        CRU1085Test.addCom(expected, 4, 4, 3, 3);
        CRU1085Test.addAdd(expected, 5, 4, 5);
        CRU1085Test.addCom(expected, 5, 6, 6, 7);
        CRU1085Test.addAdd(expected, 7, 8, 10, true);
        CRU1085Test.addCom(expected, 7, 15, 11, 19);
        CRU1085Test.addAdd(expected, 16, 20, 22, true);
        CRU1085Test.addCom(expected, 16, 19, 23, 26);
        this.subtestDiff(expected, lc, fa, fb, 4);
    }

    public void testNormalDiff() throws Exception {
        ArrayList<Section> expected = new ArrayList<Section>();
        CRU1085Test.addCom(expected, 39, 41, 39, 41);
        CRU1085Test.addDif(expected, 42, 42, 42, 42);
        CRU1085Test.addCom(expected, 43, 45, 43, 45);
        CRU1085Test.addCom(expected, 121, 123, 121, 123);
        CRU1085Test.addDif(expected, 124, 128, 124, 124);
        CRU1085Test.addCom(expected, 129, 131, 125, 127);
        CRU1085Test.addDif(expected, 132, 133, 128, 143);
        CRU1085Test.addCom(expected, 134, 134, 144, 144);
        CRU1085Test.addDel(expected, 135, 143, 145);
        CRU1085Test.addCom(expected, 144, 144, 145, 145);
        CRU1085Test.addDel(expected, 145, 152, 146);
        CRU1085Test.addCom(expected, 153, 153, 146, 146);
        CRU1085Test.addDif(expected, 154, 180, 147, 156);
        CRU1085Test.addCom(expected, 181, 181, 157, 157);
        CRU1085Test.addDel(expected, 182, 192, 158);
        CRU1085Test.addCom(expected, 193, 195, 158, 160);
        CRU1085Test.addCom(expected, 219, 221, 184, 186);
        CRU1085Test.addDel(expected, 222, 222, 187);
        CRU1085Test.addCom(expected, 223, 225, 187, 189);
        this.subtestDiff(expected, (LineComparator)LineComparator.IDENTICAL, FILE1, FILE2, 3);
    }

    public void testWsDiff() throws Exception {
        ArrayList<Section> expected = new ArrayList<Section>();
        CRU1085Test.addCom(expected, 121, 123, 121, 123);
        CRU1085Test.addDif(expected, 124, 128, 124, 124);
        CRU1085Test.addCom(expected, 129, 131, 125, 127);
        CRU1085Test.addDel(expected, 132, 134, 128);
        CRU1085Test.addCom(expected, 135, 136, 128, 129);
        CRU1085Test.addDif(expected, 137, 141, 130, 130);
        CRU1085Test.addCom(expected, 142, 143, 131, 132);
        CRU1085Test.addDel(expected, 144, 144, 133, true);
        CRU1085Test.addCom(expected, 145, 146, 133, 134);
        CRU1085Test.addDif(expected, 147, 148, 135, 136);
        CRU1085Test.addCom(expected, 149, 149, 137, 137);
        CRU1085Test.addDel(expected, 150, 150, 138);
        CRU1085Test.addCom(expected, 151, 153, 138, 140);
        CRU1085Test.addDif(expected, 154, 177, 141, 142);
        CRU1085Test.addCom(expected, 178, 178, 143, 143);
        CRU1085Test.addDel(expected, 179, 180, 144);
        CRU1085Test.addCom(expected, 181, 181, 144, 144);
        CRU1085Test.addAdd(expected, 182, 145, 146);
        CRU1085Test.addCom(expected, 182, 184, 147, 149);
        this.subtestDiff(expected, LineComparator.fromDiffOption((DiffOpts)new DiffOpts("Bw")), FILE1, FILE2, 3);
    }

    private void subtestDiff(List expected, LineComparator lc, String filename1, String filename2, int context) throws IOException {
        File file1 = new File(FisheyeTestEnv.WORKSPACE_DIR, filename1);
        File file2 = new File(FisheyeTestEnv.WORKSPACE_DIR, filename2);
        StreamIndexedLineReader lineReader1 = new StreamIndexedLineReader(file1);
        StreamIndexedLineReader lineReader2 = new StreamIndexedLineReader(file2);
        HunkList hunks = Diff.diff((DiffSequences)new TextFileDiffSequences((IndexedLineReader)lineReader1, (IndexedLineReader)lineReader2, lc));
        lineReader1.seekLine(0);
        lineReader2.seekLine(0);
        DiffOpts opts = new DiffOpts();
        opts.setSideBySide(false);
        opts.setSoftWrap(false);
        FileDiffExplorer de = new FileDiffExplorer((IndexedLineReader)lineReader1, (IndexedLineReader)lineReader2, hunks, new DiffInfo("testrep", file1.getName(), file1.getAbsolutePath(), "9370", file2.getAbsolutePath(), "9374"), SyntaxDefinition.PASS_THRU, opts);
        de.setContextLines(context);
        List sections = de.getSections();
        for (int i = 0; i < sections.size(); ++i) {
            Section s = (Section)sections.get(i);
            Section e = (Section)expected.get(i);
            System.out.println(e + " vs " + s);
            this.assertSectionEquals(e, s);
        }
        CRU1085Test.assertEquals((int)expected.size(), (int)sections.size());
    }

    private static void addDif(List<Section> sections, int leftStart, int leftEnd, int rightStart, int rightEnd) {
        Section s = new Section(false, new Hunk(leftStart - 1, rightStart - 1, leftEnd - leftStart + 1, rightEnd - rightStart + 1));
        sections.add(s);
    }

    private static void addDel(List<Section> sections, int leftStart, int leftEnd, int rightStart) {
        CRU1085Test.addDel(sections, leftStart, leftEnd, rightStart, false);
    }

    private static void addDel(List<Section> sections, int leftStart, int leftEnd, int rightStart, boolean ignored) {
        Section s = new Section(false, new Hunk(leftStart - 1, rightStart - 1, leftEnd - leftStart + 1, 0));
        s.getHunk().setIgnored(ignored);
        sections.add(s);
    }

    private static void addAdd(List<Section> sections, int leftStart, int rightStart, int rightEnd) {
        CRU1085Test.addAdd(sections, leftStart, rightStart, rightEnd, false);
    }

    private static void addAdd(List<Section> sections, int leftStart, int rightStart, int rightEnd, boolean ignored) {
        Section s = new Section(false, new Hunk(leftStart - 1, rightStart - 1, 0, rightEnd - rightStart + 1));
        s.getHunk().setIgnored(ignored);
        sections.add(s);
    }

    private static void addCom(List<Section> sections, int leftStart, int leftEnd, int rightStart, int rightEnd) {
        Section s = new Section(true, new Hunk(leftStart - 1, rightStart - 1, leftEnd - leftStart + 1, rightEnd - rightStart + 1));
        sections.add(s);
    }

    private void assertSectionEquals(Section a, Section b) {
        CRU1085Test.assertEquals((boolean)a.isCommonSubsequence(), (boolean)b.isCommonSubsequence());
        CRU1085Test.assertEquals((boolean)a.isDiff(), (boolean)b.isDiff());
        CRU1085Test.assertEquals((int)a.getFromStart(), (int)b.getFromStart());
        CRU1085Test.assertEquals((int)a.getFromLength(), (int)b.getFromLength());
        CRU1085Test.assertEquals((int)a.getToStart(), (int)b.getToStart());
        CRU1085Test.assertEquals((int)a.getToLength(), (int)b.getToLength());
        CRU1085Test.assertEquals((boolean)a.getHunk().isIgnored(), (boolean)b.getHunk().isIgnored());
        CRU1085Test.assertEquals((String)a.getHunk().toString(), (String)b.getHunk().toString());
    }
}

