/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.it.csindex;

import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.csindex.ActivityCalendar;
import com.cenqua.fisheye.csindex.ChangesetStatsCalculator;
import com.cenqua.fisheye.cvsrep.RepSanityTestBase;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import java.util.TimeZone;
import junit.framework.Assert;
import org.junit.Test;

public final class SearcherCvsTest
extends RepSanityTestBase {
    @Override
    protected RepositoryHandle whichHandle() throws Exception {
        return TestFishEyeInstances.getSanity1Repos();
    }

    @Test
    public void testActivityCalendar() throws Exception {
        try {
            ActivityItemSearchParams activityStreamParams = ActivityItemSearchParams.builder().maxItems(10).timeZone(TimeZone.getDefault()).includeCrucible().repository(this.whichHandle().getName()).build();
            this.runCalendarTest(activityStreamParams, this.expectedActivityCalendar());
            activityStreamParams = ActivityItemSearchParams.builder().maxItems(10).timeZone(TimeZone.getDefault()).includeCrucible().setCompulsoryCommitter("anthony").repository(this.whichHandle().getName()).build();
            this.runCalendarTest(activityStreamParams, this.expectedActivityCalendarAnthony());
            activityStreamParams = ActivityItemSearchParams.builder().maxItems(10).timeZone(TimeZone.getDefault()).includeCrucible().setCompulsoryCommitter("anthony").path(this.whichHandle().getName(), new Path((CharSequence)"test")).build();
            this.runCalendarTest(activityStreamParams, this.expectedActivityCalendarAnthonyTest());
        }
        catch (DbException e) {
            Logs.APP_LOG.debug((Object)"Error creating activity calendar", (Throwable)e);
        }
    }

    private void runCalendarTest(ActivityItemSearchParams activityStreamParams, ActivityCalendar expectedActivityCalendar) throws Exception {
        ChangesetStatsCalculator calculator = new ChangesetStatsCalculator(activityStreamParams);
        ActivityCalendar activityCalendar = new ActivityCalendar();
        calculator.activityCalendar(this.engine.getCrossRepLuceneConnection(), activityCalendar);
        Assert.assertEquals((Object)expectedActivityCalendar, (Object)activityCalendar);
    }

    private ActivityCalendar expectedActivityCalendar() {
        ActivityCalendar cal = new ActivityCalendar();
        cal.addResult("200110", 1);
        cal.addResult("200202", 10);
        cal.addResult("200203", 1);
        cal.addResult("200206", 4);
        cal.addResult("200207", 2);
        cal.addResult("200212", 4);
        cal.addResult("200301", 3);
        cal.addResult("200302", 9);
        cal.addResult("200303", 8);
        cal.addResult("200304", 8);
        cal.addResult("200305", 6);
        cal.addResult("200307", 2);
        cal.addResult("200308", 2);
        cal.addResult("200309", 3);
        cal.addResult("200310", 6);
        cal.addResult("200311", 6);
        cal.addResult("200312", 25);
        cal.addResult("200401", 30);
        cal.addResult("200402", 43);
        cal.addResult("200403", 78);
        cal.addResult("200404", 12);
        cal.addResult("200405", 23);
        cal.addResult("200406", 9);
        cal.addResult("200407", 69);
        cal.addResult("200408", 40);
        cal.addResult("200409", 32);
        cal.addResult("200410", 23);
        cal.addResult("200411", 9);
        cal.addResult("200412", 1);
        cal.addResult("200501", 4);
        cal.addResult("200503", 1);
        cal.addResult("200505", 1);
        return cal;
    }

    private ActivityCalendar expectedActivityCalendarAnthony() {
        ActivityCalendar cal = new ActivityCalendar();
        cal.addResult("200212", 3);
        cal.addResult("200301", 1);
        cal.addResult("200302", 2);
        cal.addResult("200303", 1);
        cal.addResult("200304", 6);
        cal.addResult("200305", 2);
        return cal;
    }

    private ActivityCalendar expectedActivityCalendarAnthonyTest() {
        ActivityCalendar cal = new ActivityCalendar();
        cal.addResult("200212", 3);
        cal.addResult("200301", 1);
        cal.addResult("200302", 2);
        cal.addResult("200303", 1);
        return cal;
    }
}

