/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.it.bucket;

import com.atlassian.fisheye.bucket.BlameGenerationTestBase;
import com.atlassian.fisheye.bucket.BucketDataCollectionTotalled;
import com.atlassian.fisheye.bucket.ParameterSetQuery;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import java.util.TimeZone;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class BlameGenerationTest
extends BlameGenerationTestBase {
    private TimeZone tzOrig = TimeZone.getDefault();
    private TimeZone tzDefault = TimeZone.getTimeZone("Australia/Perth");

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.bucketGraph = this.engine.getBucketGraph();
        RootConfig rootConfig = AppConfig.getsConfig();
        this.tzOrig = rootConfig.getTimezone();
        rootConfig.getConfig().setTimezone(this.tzDefault.getID());
        rootConfig.reload();
        this.bucketGraph.reindex(this.engine.getLinecountCalculator(), this.engine.getStatus());
    }

    @Override
    @After
    public void tearDown() throws Exception {
        try {
            this.deleteAllBucketGraphData();
            this.engine.getDatabaseHandle().commit();
            AppConfig.getsConfig().getConfig().setTimezone(this.tzOrig.getID());
        }
        finally {
            super.tearDown();
        }
    }

    @Override
    protected RepositoryHandle whichHandle() throws Exception {
        return TestFishEyeInstances.getSanity1Repos();
    }

    @Test
    public void testBlame() throws Exception {
        BucketDataCollectionTotalled data = this.bucketGraph.getBuckets(new ParameterSetQuery(Path.ROOT, "__TRUNKLIKE__", "__ALL_EXTENSIONS__", "sberlin"));
        Assert.assertEquals((String)"{(trunk)={0={12395=[806(+806),3(+3)], 12400=[50(-756),3(+0)], 12683=[0(-50),4(+1)]}}}", (String)data.toString());
        Assert.assertEquals((String)"{(trunk)={0={12414=[47(+47),1(+1)], 12424=[36(-11),1(+0)], 12437=[7(-29),1(+0)]}}}", (String)this.bucketGraph.getBuckets(new ParameterSetQuery(Path.ROOT, "__TRUNKLIKE__", "__ALL_EXTENSIONS__", "bill")).toString());
    }

    @Test
    public void testBlameReslurp() throws Exception {
        this.bucketGraph.reindex(this.engine.getLinecountCalculator(), this.engine.getStatus());
        Assert.assertEquals((String)"{(trunk)={0={12395=[806(+806),3(+3)], 12400=[50(-756),3(+0)], 12683=[0(-50),4(+1)]}}}", (String)this.bucketGraph.getBuckets(new ParameterSetQuery(Path.ROOT, "__TRUNKLIKE__", "__ALL_EXTENSIONS__", "sberlin")).toString());
        Assert.assertEquals((String)"{(trunk)={0={12414=[47(+47),1(+1)], 12424=[36(-11),1(+0)], 12437=[7(-29),1(+0)]}}}", (String)this.bucketGraph.getBuckets(new ParameterSetQuery(Path.ROOT, "__TRUNKLIKE__", "__ALL_EXTENSIONS__", "bill")).toString());
    }
}

