/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.it.api;

import com.atlassian.fisheye.it.api.MockContext;
import com.cenqua.fisheye.api.BaseApiHandler;
import com.cenqua.fisheye.api.XmlRpcApiHandler;
import com.cenqua.fisheye.util.ISO8601DateHelper;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

public class XmlRpcMockContext
extends MockContext {
    private final boolean encloseStringsInString;
    private StringWriter req = new StringWriter();
    private boolean hasParams = false;
    private BufferedReader reader = null;

    public XmlRpcMockContext(boolean encloseStringsInString) {
        this.encloseStringsInString = encloseStringsInString;
    }

    @Override
    public BaseApiHandler makeApi() {
        return new XmlRpcApiHandler();
    }

    @Override
    public void setupCall(String cmd) {
        super.setupCall(cmd);
        this.hasParams = false;
        this.reader = null;
        this.req.getBuffer().setLength(0);
        this.req.write("<methodCall><methodName>");
        this.req.write(cmd);
        this.req.write("</methodName>\n");
    }

    @Override
    public void addStringParam(String name, String value) throws IOException {
        this.paramsBegin();
        this.req.write(" <param><value>");
        if (this.encloseStringsInString) {
            this.req.write("<string>");
        }
        ExpressionUtil.escapeString((CharSequence)value, (Writer)this.req);
        if (this.encloseStringsInString) {
            this.req.write("</string>");
        }
        this.req.write("</value></param>\n");
    }

    @Override
    public void addDateParam(String name, long date) {
        this.paramsBegin();
        this.req.write(" <param><value><dateTime.iso8601>");
        this.req.write(ISO8601DateHelper.toXmlRpcDate((long)date));
        this.req.write("</dateTime.iso8601></value></param>\n");
    }

    @Override
    public void addIntParam(String name, int value) throws IOException {
        this.paramsBegin();
        this.req.write(" <param><value><i4>");
        this.req.write(String.valueOf(value));
        this.req.write("</i4></value></param>\n");
    }

    private void paramsBegin() {
        if (!this.hasParams) {
            this.req.write("<params>\n");
        }
        this.hasParams = true;
    }

    @Override
    public BufferedReader getReader() throws IOException {
        if (this.reader == null) {
            if (this.hasParams) {
                this.req.write("</params>\n");
            }
            this.req.write("</methodCall>");
            this.reader = new BufferedReader(new StringReader(this.req.toString()));
        }
        return this.reader;
    }
}

