/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.it.api;

import com.atlassian.crucible.spi.rpc.data.LoginResult;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.fisheye.api.BaseApiHandler;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.LoginCookie;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserTestHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import junit.framework.Assert;

public abstract class MockContext
implements BaseApiHandler.Context {
    protected String cmd;
    private StringWriter sw = new StringWriter();
    String lastAuthToken;
    UserLogin lastAuthLogin;
    String lastAuthUser;
    String lastAuthPassword;

    public void setupCall(String cmd) {
        this.cmd = cmd;
        this.sw.getBuffer().setLength(0);
    }

    public abstract void addStringParam(String var1, String var2) throws IOException;

    public abstract void addDateParam(String var1, long var2);

    public abstract void addIntParam(String var1, int var2) throws IOException;

    public abstract BaseApiHandler makeApi();

    public void setContentType(String s) {
    }

    public Map<String, String[]> getParameterMap() {
        return new HashMap<String, String[]>();
    }

    public PrintWriter getWriter() throws IOException {
        return new PrintWriter(this.sw);
    }

    public String getResponseBody() {
        return this.sw.toString();
    }

    public String getPathInfo() {
        String msg = "apparently this method should not be called during this test";
        Assert.fail((String)"apparently this method should not be called during this test");
        throw new RuntimeException("apparently this method should not be called during this test");
    }

    public String getParameter(String name) {
        String msg = "apparently this method should not be called during this test";
        Assert.fail((String)"apparently this method should not be called during this test");
        throw new RuntimeException("apparently this method should not be called during this test");
    }

    public BufferedReader getReader() throws IOException {
        String msg = "apparently this method should not be called during this test";
        Assert.fail((String)"apparently this method should not be called during this test");
        throw new RuntimeException("apparently this method should not be called during this test");
    }

    public UserLogin checkAuth(String authString) throws DbException {
        if (this.lastAuthToken == null) {
            return null;
        }
        if (authString.equals(this.lastAuthToken)) {
            return this.lastAuthLogin;
        }
        return null;
    }

    public UserLogin getUser() {
        return null;
    }

    public LoginResult login(String username, String password) throws DbException {
        this.clearAuthInfo();
        this.lastAuthUser = username;
        this.lastAuthPassword = password;
        if ("matt".equals(username) && "m4tt".equals(password)) {
            String rnd = "" + new Random().nextLong();
            LoginCookie cookie = LoginCookie.createRememberMeCookie((FecruUser)new FecruUser(username), (String)rnd);
            cookie.setLoginId(Long.valueOf(100L));
            this.lastAuthLogin = UserTestHelper.createPrincipal(username);
            this.lastAuthToken = cookie.getLoginCookieToken().encode();
            return LoginResult.token((String)this.lastAuthToken);
        }
        return LoginResult.error((String)"authentication failed");
    }

    public void logout(UserLogin user) throws DbException {
        this.clearAuthInfo();
    }

    private void clearAuthInfo() {
        this.lastAuthToken = null;
        this.lastAuthLogin = null;
        this.lastAuthUser = null;
        this.lastAuthPassword = null;
    }
}

