/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.it.api;

import com.atlassian.fisheye.it.api.MockContext;
import com.atlassian.fisheye.it.api.RestMockContext;
import com.atlassian.fisheye.it.api.XmlRpcMockContext;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.api.ApiImplementation;
import com.cenqua.fisheye.api.BaseApiHandler;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.util.DateHelper;
import com.cenqua.fisheye.util.Disposer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import junit.framework.Assert;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.ParsingException;
import nu.xom.Serializer;
import org.eclipse.jetty.io.WriterOutputStream;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class ApiSanity1Test {
    @Before
    public void setUp() throws Exception {
        Disposer.pushThreadInstance();
        TestFishEyeInstances.loadSanity1();
    }

    @After
    public void tearDown() throws Exception {
        Disposer.popThreadInstance();
        TestFishEyeInstances.stop();
    }

    @Test
    public void testXmlApi() throws Exception {
        this.subtestAPI(new XmlRpcMockContext(true), "xmlrpc");
        this.subtestAPI(new XmlRpcMockContext(false), "xmlrpc");
    }

    @Test
    public void testRestApi() throws Exception {
        this.subtestAPI(new RestMockContext(), "rest");
    }

    private void subtestAPI(MockContext ctx, String resultPrefix) throws Exception {
        String auth = "";
        this.subtestAPI(auth, ctx, resultPrefix);
        ctx.setupCall("listRepositories");
        ctx.addStringParam("auth", auth);
        this.assertCall(resultPrefix, "-listAnonReps", ctx);
        ctx.setupCall("login");
        ctx.addStringParam("username", "matt");
        ctx.addStringParam("password", "blah");
        this.assertCall(resultPrefix, "-login1", ctx);
        Assert.assertEquals((String)"matt", (String)ctx.lastAuthUser);
        Assert.assertEquals((String)"blah", (String)ctx.lastAuthPassword);
        Assert.assertNull((Object)ctx.lastAuthToken);
        ctx.setupCall("login");
        ctx.addStringParam("username", "matt");
        ctx.addStringParam("password", "m4tt");
        this.doCall(ctx);
        Assert.assertEquals((String)"matt", (String)ctx.lastAuthUser);
        Assert.assertEquals((String)"m4tt", (String)ctx.lastAuthPassword);
        Assert.assertNotNull((Object)ctx.lastAuthToken);
        auth = ctx.lastAuthToken;
        this.subtestAPI(auth, ctx, resultPrefix);
        ctx.setupCall("listRepositories");
        ctx.addStringParam("auth", auth);
        this.assertCall(resultPrefix, "-listReps", ctx);
        ctx.setupCall("logout");
        ctx.addStringParam("auth", auth);
        this.doCall(ctx);
        Assert.assertNull((Object)ctx.lastAuthUser);
        Assert.assertNull((Object)ctx.lastAuthPassword);
        Assert.assertNull((Object)ctx.lastAuthToken);
    }

    private void subtestAPI(String auth, MockContext ctx, String resultPrefix) throws Exception {
        ctx.setupCall("listPaths");
        ctx.addStringParam("auth", auth);
        ctx.addStringParam("rep", "cvs");
        ctx.addStringParam("path", "test");
        this.assertCall(resultPrefix, "-listPaths", ctx);
        ctx.setupCall("listPathHistory");
        ctx.addStringParam("auth", auth);
        ctx.addStringParam("rep", "cvs");
        ctx.addStringParam("path", "test/b.txt");
        this.assertCall(resultPrefix, "-getHistory", ctx);
        ctx.setupCall("getRevision");
        ctx.addStringParam("auth", auth);
        ctx.addStringParam("rep", "cvs");
        ctx.addStringParam("path", "test/b.txt");
        ctx.addStringParam("rev", "1.1");
        this.assertCall(resultPrefix, "-getRevision", ctx);
        ctx.setupCall("listTagsForRevision");
        ctx.addStringParam("auth", auth);
        ctx.addStringParam("rep", "cvs");
        ctx.addStringParam("path", "test/Buil_List.txt");
        ctx.addStringParam("rev", "1.1");
        this.assertCall(resultPrefix, "-listTagsForRevision", ctx);
        ctx.setupCall("getChangeset");
        ctx.addStringParam("auth", auth);
        ctx.addStringParam("rep", "cvs");
        ctx.addStringParam("csid", "MAIN:matt:20040505045207");
        this.assertCall(resultPrefix, "-getChangeset", ctx);
        ctx.setupCall("listChangesets");
        ctx.addStringParam("auth", auth);
        ctx.addStringParam("rep", "cvs");
        ctx.addStringParam("path", "/");
        ctx.addDateParam("start", DateHelper.componentsToTime((int)2004, (int)4, (int)23, (int)10, (int)3, (int)49));
        ctx.addDateParam("end", DateHelper.componentsToTime((int)2004, (int)5, (int)5, (int)4, (int)52, (int)7));
        this.assertCall(resultPrefix, "-getChangesets", ctx);
        ctx.setupCall("listChangesets");
        ctx.addStringParam("auth", auth);
        ctx.addStringParam("rep", "cvs");
        ctx.addStringParam("path", "/");
        ctx.addDateParam("start", DateHelper.componentsToTime((int)2004, (int)11, (int)16, (int)0, (int)0, (int)0));
        ctx.addDateParam("end", DateHelper.componentsToTime((int)2004, (int)11, (int)18, (int)0, (int)0, (int)0));
        ctx.addIntParam("maxReturn", 5);
        this.assertCall(resultPrefix, "-getChangesets-limited", ctx);
        ctx.setupCall("query");
        ctx.addStringParam("auth", auth);
        ctx.addStringParam("rep", "cvs");
        ctx.addStringParam("query", "select revisions from dir / where path like b.txt order by date");
        this.assertCall(resultPrefix, "-query", ctx);
        ctx.setupCall("query");
        ctx.addStringParam("auth", auth);
        ctx.addStringParam("rep", "cvs");
        ctx.addStringParam("query", "select revisions from dir / where path like b.txt order by date return csid, path, revision");
        this.assertCall(resultPrefix, "-query2", ctx);
        ctx.setupCall("query");
        ctx.addStringParam("auth", auth);
        ctx.addStringParam("rep", "cvs");
        ctx.addStringParam("query", "select revisions where tagged T1 return path, revision, tags");
        this.assertCall(resultPrefix, "-query3", ctx);
        ctx.setupCall("query");
        ctx.addStringParam("auth", auth);
        ctx.addStringParam("rep", "cvs");
        ctx.addStringParam("query", "select revisions where tagged CHALK_t1 return path, revision, tags");
        this.assertCall(resultPrefix, "-query4", ctx);
        ctx.setupCall("listPaths");
        ctx.addStringParam("auth", auth);
        ctx.addStringParam("rep", "UnlikelyToEverExist");
        ctx.addStringParam("path", "test");
        this.assertCall(resultPrefix, "-listPaths-err-norep", ctx);
        this.versionMethodSubtest(resultPrefix, "fisheyeVersion", "4.0.4", ctx);
        String expectedCruVersion = AppConfig.isCrucible() ? "4.0.4" : "";
        this.versionMethodSubtest(resultPrefix, "crucibleVersion", expectedCruVersion, ctx);
    }

    private void versionMethodSubtest(String resultPrefix, String apiMethod, String releaseNumber, MockContext ctx) throws Exception {
        Document expectedCruVersionDom = ApiSanity1Test.parseDocument(resultPrefix + "-version.xml");
        Element cruVersion = resultPrefix.equals("xmlrpc") ? (Element)expectedCruVersionDom.query("/methodResponse/params/param/value/string").get(0) : (Element)expectedCruVersionDom.query("/response/string").get(0);
        cruVersion.removeChildren();
        cruVersion.appendChild(releaseNumber);
        ctx.setupCall(apiMethod);
        this.assertCall(expectedCruVersionDom, ctx);
    }

    private void assertCall(String resultPrefix, String responseFile, MockContext ctx) throws Exception {
        Document expectedDom = ApiSanity1Test.parseDocument(resultPrefix + responseFile + ".xml");
        Document actualDom = this.doCall(ctx);
        ApiSanity1Test.assertXmlDocumentEqual(expectedDom, actualDom);
    }

    private void assertCall(Document expectedDom, MockContext ctx) throws Exception {
        Document actualDom = this.doCall(ctx);
        ApiSanity1Test.assertXmlDocumentEqual(expectedDom, actualDom);
    }

    private Document doCall(MockContext ctx) throws IOException, ParsingException {
        Document actualDom;
        BaseApiHandler api = ctx.makeApi();
        api.setup((BaseApiHandler.Context)ctx);
        ApiImplementation h = new ApiImplementation(api);
        h.handle();
        String responseXml = ctx.getResponseBody();
        try {
            Builder builder = new Builder();
            actualDom = builder.build((Reader)new StringReader(responseXml));
        }
        catch (ParsingException e) {
            System.out.println("response was:\n" + responseXml);
            throw e;
        }
        return actualDom;
    }

    private static void assertXmlDocumentEqual(Document expectedDom, Document actualDom) throws Exception {
        Assert.assertEquals((String)("Actual:\n" + ApiSanity1Test.canonicalize(actualDom) + "\n Expected:\n" + ApiSanity1Test.canonicalize(expectedDom)), (String)ApiSanity1Test.canonicalize(expectedDom), (String)ApiSanity1Test.canonicalize(actualDom));
    }

    private static Document parseDocument(String xmlFile) throws ParsingException, IOException {
        Builder builder = new Builder();
        InputStream expectedIn = ApiSanity1Test.class.getResourceAsStream(xmlFile);
        Assert.assertNotNull((Object)expectedIn);
        Document expectedDom = builder.build(expectedIn);
        expectedIn.close();
        return expectedDom;
    }

    private static String canonicalize(Document dom) throws Exception {
        StringWriter sw = new StringWriter();
        WriterOutputStream out = new WriterOutputStream((Writer)sw);
        Serializer c = new Serializer((OutputStream)out);
        c.setIndent(4);
        c.write(dom);
        out.flush();
        return sw.toString();
    }
}

