/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.infinitydb;

import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.infinitydb.EavEntityCu;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.infinitydb.UniqueStringTable;
import com.cenqua.fisheye.infinitydb.UniqueStringTableImpl;
import com.cenqua.fisheye.rep.DbException;
import com.infinitydb.Attribute;
import com.infinitydb.Cu;
import com.infinitydb.EntityClass;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EavEntityCuTest {
    private InfinityDbHandle dbh;
    private UniqueStringTable stringTable;
    private EavEntityCu eav;
    private Attribute attr = new Attribute(1L);

    @Before
    public void createTestDB() throws DbException, IOException {
        this.dbh = FisheyeTestUtil.createTempDBHandleForWrite();
        this.stringTable = new UniqueStringTableImpl(this.dbh, new EntityClass(10L));
        this.eav = new EavEntityCu(this.dbh.get(), new EntityClass(20L), Cu.alloc().append("pk"));
    }

    @After
    public void cleanupTestDB() throws DbException, IOException {
        this.dbh.close();
    }

    @Test
    public void testStringOrdered() throws DbException, IOException {
        List<String> values = Arrays.asList("c", "a", "b", "d", "d", "a");
        this.eav.updateStringsOrdered(this.stringTable, this.attr, values);
        this.dbh.commit();
        List loaded = this.eav.getStringsOrdered(this.stringTable, this.attr);
        Assert.assertEquals(values, (Object)loaded);
    }
}

