/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg.testutil;

import com.atlassian.fisheye.dvcs.DvcsRepoValidation;
import com.atlassian.fisheye.hg.HgIncrementalTestCase;
import com.atlassian.fisheye.hg.testutil.HgTestManifest;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Set;

public class HgTestChangeLog {
    public LinkedList<HgTestManifest> manifestRevs = new LinkedList();

    protected void insertRevs(DvcsRepoValidation.FileRevs revs) {
        ListIterator it = this.manifestRevs.listIterator();
        for (DvcsRepoValidation.Revision revision : revs.revisions) {
            HgTestManifest mf = null;
            while ((mf == null || !mf.revision.equals(revision.rev)) && it.hasNext()) {
                mf = (HgTestManifest)it.next();
            }
            mf.add(revision);
        }
    }

    public HgTestManifest findManifest(String revision) {
        for (HgTestManifest mf : this.manifestRevs) {
            if (!mf.revision.equals(revision)) continue;
            return mf;
        }
        return null;
    }

    public Set<String> getTags(String path, String revision) {
        HashSet<String> tags = new HashSet<String>();
        for (HgTestManifest mf : this.manifestRevs) {
            DvcsRepoValidation.Revision rev = mf.get(path);
            if (rev == null || !revision.equals(rev.rev)) continue;
            tags.addAll(mf.tags);
        }
        return tags;
    }

    protected void applyTagAction(HgIncrementalTestCase.TagAction ta) {
        HgTestManifest mf = this.findManifest(ta.getRevision());
        if (mf == null) {
            throw new IllegalStateException("No version " + ta.getRevision() + " found");
        }
        switch (ta.getAction()) {
            case ADDED: {
                mf.tags.add(ta.getTag());
                break;
            }
            case REMOVED: {
                if (mf.tags.remove(ta.getTag())) break;
                throw new IllegalStateException("Cannot remove tag " + ta.getTag() + " from rev " + ta.getRevision() + "; tag not present");
            }
        }
    }

    protected void fillManifests() {
        for (HgTestManifest mf : this.manifestRevs) {
            HgTestManifest parent;
            if (mf.parents == null || mf.parents.isEmpty() || (parent = this.findManifest(mf.parents.get(0))) == null) continue;
            HashMap<String, DvcsRepoValidation.Revision> parentRevs = new HashMap<String, DvcsRepoValidation.Revision>();
            parentRevs.putAll(parent.revisions);
            for (String name : mf.revisions.keySet()) {
                parentRevs.remove(name);
            }
            mf.revisions.putAll(parentRevs);
        }
    }

    public HgTestChangeLog(Collection<DvcsRepoValidation.Commit> commits, Collection<DvcsRepoValidation.FileRevs> allRevs, Collection<HgIncrementalTestCase.TagAction> tags) {
        for (DvcsRepoValidation.Commit commit : commits) {
            HgTestManifest mf = new HgTestManifest(commit.hash, commit.parents, commit.branches.iterator().next());
            this.manifestRevs.add(mf);
        }
        for (DvcsRepoValidation.FileRevs revs : allRevs) {
            this.insertRevs(revs);
        }
        this.fillManifests();
        for (HgIncrementalTestCase.TagAction tagAction : tags) {
            this.applyTagAction(tagAction);
        }
    }
}

