/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg.db;

import com.atlassian.fisheye.hg.db.HgChangeSetDAO;
import com.atlassian.fisheye.hg.db.HgRevInfoDAO;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.infinitydb.UniqueStringTableFactory;
import com.cenqua.fisheye.rep.ChangeSetImpl;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.Tag;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import java.io.File;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class HgChangeSetDAOTest {
    private static final String CSID = "991fac7b539fc1f26be12bffea3f2ea3653bb2e6";
    @Rule
    public TemporaryFolder infDbDir = new TemporaryFolder();
    @Mock
    HgRevInfoDAO hgRevInfoDAO;
    @Mock
    LicenseEnforcer licenseEnforcer;
    HgChangeSetDAO dao;
    InfinityDbHandle infDb;

    @Before
    public void setUp() throws Exception {
        File infDbFile = new File(this.infDbDir.newFolder(), "data.bin");
        this.infDb = new InfinityDbHandle(infDbFile);
        this.dao = new HgChangeSetDAO(new RepositoryStatus(""), this.infDb, new CommonStringTables((UniqueStringTableFactory)this.infDb), this.hgRevInfoDAO, this.licenseEnforcer);
    }

    @Test
    public void getAllTagsShouldExcludeTip() throws Exception {
        this.dao.store((ChangeSetImpl)this.dao.createChangeSet(CSID));
        Tag tag1 = new Tag("nottip", CSID);
        Tag tag2 = new Tag("alsonottip", CSID);
        this.dao.addTag(new Tag("tip", CSID));
        this.dao.addTag(tag1);
        this.dao.addTag(tag2);
        Set notAllTags = this.dao.getAllTags();
        Assert.assertThat((Object)notAllTags, (Matcher)Matchers.containsInAnyOrder((Object[])new Tag[]{tag1, tag2}));
    }

    @Test
    public void getTagShouldReturnTipIfRequested() throws Exception {
        this.dao.store((ChangeSetImpl)this.dao.createChangeSet(CSID));
        Tag tip = new Tag("tip", CSID);
        this.dao.addTag(tip);
        Tag storedTip = this.dao.getTag("tip");
        Assert.assertThat((Object)storedTip, (Matcher)Matchers.equalTo((Object)tip));
    }
}

