/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg.client;

import com.atlassian.fisheye.hg.client.HgContext;
import com.atlassian.utils.process.Watchdog;
import com.cenqua.fisheye.rep.VersionHandler;
import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class HgVersionTest {
    public static final String[] VERSION163 = new String[]{"Mercurial Distributed SCM (version 1.6.3)", "(see http://mercurial.selenic.com for more information)", "", "Copyright (C) 2005-2011 Matt Mackall and others", "This is free software; see the source for copying conditions. There is NO", "warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE."};
    public static final String[] VERSION181 = new String[]{"Mercurial Distributed SCM (version 1.8.1+20110310)", "(see http://mercurial.selenic.com for more information)", "", "Copyright (C) 2005-2011 Matt Mackall and others", "This is free software; see the source for copying conditions. There is NO", "warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE."};

    @Test
    public void testHGInPath() throws Exception {
        String hgExeProperty = System.getProperty("hg.exe");
        String hgPath = Strings.isNullOrEmpty((String)hgExeProperty) ? "hg" : hgExeProperty;
        HgContext.determineHgVersion((String)hgPath);
    }

    @Test
    public void testVersion163() throws Exception {
        VersionHandler handler = new VersionHandler("version\\s([\\d\\.\\+]+)");
        handler.setWatchdog((Watchdog)new DummyWatchdog());
        handler.process((InputStream)new ByteArrayInputStream(StringUtils.join((Object[])VERSION163, (String)"\n").getBytes("UTF-8")));
        Assert.assertEquals((Object)"1.6.3", (Object)handler.getVersionString());
    }

    @Test
    public void testVersion181() throws Exception {
        VersionHandler handler = new VersionHandler("version\\s([\\d\\.\\+]+)");
        handler.setWatchdog((Watchdog)new DummyWatchdog());
        handler.process((InputStream)new ByteArrayInputStream(StringUtils.join((Object[])VERSION181, (String)"\n").getBytes("UTF-8")));
        Assert.assertEquals((Object)"1.8.1+20110310", (Object)handler.getVersionString());
    }

    private static class DummyWatchdog
    implements Watchdog {
        private DummyWatchdog() {
        }

        public void cancel() {
        }

        public boolean isCanceled() {
            return false;
        }

        public void resetWatchdog() {
        }
    }
}

