/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg.client;

import com.atlassian.fisheye.hg.client.HgListBranchesOutputHandler;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.rep.BranchState;
import java.nio.charset.Charset;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HgListBranchesOutputHandlerTest {
    private HgListBranchesOutputHandler handler;

    @Before
    public void createHandler() {
        this.handler = new HgListBranchesOutputHandler(Charset.forName("UTF8"), "test");
    }

    protected void assertBranchEquals(Branch expected, Branch actual) {
        Assert.assertEquals((String)"branch name not equal", (Object)expected.getName(), (Object)actual.getName());
        Assert.assertEquals((String)"branch state not equal", (Object)expected.getState(), (Object)actual.getState());
        Assert.assertEquals((String)"branch head not equal", (Object)expected.getLatestChangeSetId(), (Object)actual.getLatestChangeSetId());
    }

    protected void testForLine(String line, Branch expected) {
        this.handler.processLine(1, line);
        Assert.assertEquals((long)1L, (long)this.handler.getBranches().size());
        this.assertBranchEquals(expected, (Branch)this.handler.getBranches().iterator().next());
    }

    @Test
    public void testActiveBranch() {
        this.testForLine("branch2                        2:12be836dacb8", new Branch("branch2", "12be836dacb8", BranchState.ACTIVE));
    }

    @Test
    public void testLongRevNumBranch() {
        this.testForLine("branch2                     1234:12be836dacb8", new Branch("branch2", "12be836dacb8", BranchState.ACTIVE));
    }

    @Test
    public void testInactiveBranch() {
        this.testForLine("default                        1:a8b9fb6c14a4 (inactive)", new Branch("default", "a8b9fb6c14a4", BranchState.INACTIVE));
    }

    @Test
    public void testClosedBranch() {
        this.testForLine("branch3                        5:3a7e412aa91c (closed)", new Branch("branch3", "3a7e412aa91c", BranchState.CLOSED));
    }

    @Test
    public void testActiveBranchWithLongBranchName() {
        this.testForLine("branchname with spaces         4:f055d3a84f0b", new Branch("branchname with spaces", "f055d3a84f0b", BranchState.ACTIVE));
    }

    @Test
    public void testEmptyBranchName() {
        String nullString = new String(new byte[]{0, 0, 0, 0, 0, 0, 0, 0});
        this.handler.processLine(1, nullString.trim() + "    4:f055d3a84f0b");
        Assert.assertEquals((long)0L, (long)this.handler.getBranches().size());
    }
}

