/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg.client;

import com.atlassian.fisheye.hg.client.HgCommandBuilder;
import com.atlassian.fisheye.util.ListAssert;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.RevInfoKey;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;

public class HgCommandBuilderTest
extends TestCase {
    private static final String REV_0 = "6befb7b0fa11";
    private static final Map<String, Boolean> GLOBAL_ARGS = new HashMap<String, Boolean>(){
        {
            this.put("-R", true);
            this.put("--repository", true);
            this.put("--cwd", true);
            this.put("-y", false);
            this.put("--noninteractive", false);
            this.put("-q", false);
            this.put("--quiet", false);
            this.put("-v", false);
            this.put("--verbose", false);
            this.put("--config", true);
            this.put("--debug", false);
            this.put("--debugger", false);
            this.put("--encoding", true);
            this.put("--encodingmode", true);
            this.put("--traceback", false);
            this.put("--time", false);
            this.put("--profile", false);
            this.put("--version", false);
            this.put("-h", false);
            this.put("--help", false);
        }
    };

    public void testCreateListFileRevsCommand() {
        this.checkForCommand("feparents", HgCommandBuilder.createListFileRevsCommand((String)REV_0).createCommand(), true).contains((String[])new String[]{"--config", "extensions.felog=" + HgCommandBuilder.getFeLogScriptPath()}).endsWith((String[])new String[]{REV_0}).andNothingElse();
    }

    public void testCreateListCommitsCommandNull() {
        this.checkForCommand("log", HgCommandBuilder.createListCommitsCommand(null).createCommand()).contains((String[])new String[]{"-r", "0:"}).contains((String[])new String[]{"--template", "{rev}\\t{node}\\t{parents}\\n"}).andNothingElse();
    }

    public void testCreateListCommitsCommand() {
        this.checkForCommand("log", HgCommandBuilder.createListCommitsCommand((String)"tagv1.0").createCommand()).contains((String[])new String[]{"-r", "tagv1.0:"}).contains((String[])new String[]{"--template", "{rev}\\t{node}\\t{parents}\\n"}).andNothingElse();
    }

    public void testCreateListBranchCommitCommandNull() {
        try {
            HgCommandBuilder.createListBranchCommitsCommand(null, null);
            HgCommandBuilderTest.fail((String)"NullpointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCreateListBranchCommitCommand() {
        this.checkForCommand("log", HgCommandBuilder.createListBranchCommitsCommand((String)"tagv1.0", (String)"mybranch").createCommand()).contains((String[])new String[]{"-r", "tagv1.0:"}).contains((String[])new String[]{"--template", "{rev}\\t{node}\\t{parents}\\n"}).contains((String[])new String[]{"-b", "mybranch"}).andNothingElse();
    }

    public void testCreateContentCommand() {
        this.checkForCommand("cat", HgCommandBuilder.createContentCommand((String)"path/to/file", (String)"changeset").createCommand()).contains((String[])new String[]{"-r", "changeset"}).endsWith((String[])new String[]{"path/to/file"}).andNothingElse();
    }

    public void testCreateBlameCommand() {
        RevInfoKey key = new RevInfoKey(new Path((CharSequence)"somefile.txt"), REV_0);
        this.checkForCommand("annotate", HgCommandBuilder.createBlameCommand((RevInfoKey)key).createCommand()).contains((String[])new String[]{"-r", REV_0}).contains((String[])new String[]{"-c"}).contains((String[])new String[]{"-f"}).contains((String[])new String[]{"-l"}).endsWith((String[])new String[]{"somefile.txt"}).andNothingElse();
    }

    public void testCreateLogTipCommand() {
        this.checkForCommand("log", HgCommandBuilder.createLogTipCommand().createCommand()).contains((String[])new String[]{"-r", "tip"}).contains((String[])new String[]{"--template", "{node}\\n"}).andNothingElse();
    }

    public void testCreateFeLogCommand() {
        this.checkForCommand("felog", HgCommandBuilder.createFeLogCommand((String)REV_0).createCommand()).contains((String[])new String[]{"-p"}).contains((String[])new String[]{REV_0}).contains((String[])new String[]{"--config", "extensions.felog=" + HgCommandBuilder.getFeLogScriptPath()}).contains((String[])new String[]{"-m"}).andNothingElse();
    }

    public void testCreatePullCommand() {
        String remoteLocation = "http://remote.org/repo";
        this.checkForCommand("pull", HgCommandBuilder.createPullCommand((String)"http://remote.org/repo").createCommand()).endsWith((String[])new String[]{"http://remote.org/repo"}).andNothingElse();
    }

    public void testCreatePullCommandWithSshLocation() {
        String remoteLocation = "http://remote.org/repo";
        String spaceEscapedSshPath = "\"/usr/bin/ssh\"";
        this.checkForCommand("pull", HgCommandBuilder.createPullCommand((String)"http://remote.org/repo").setSshCommand(spaceEscapedSshPath).createCommand()).contains((String[])new String[]{"-e", spaceEscapedSshPath}).endsWith((String[])new String[]{"http://remote.org/repo"}).andNothingElse();
    }

    public void testCreateListTagsCommand() {
        this.checkForCommand("tags", HgCommandBuilder.createListTagsCommand().createCommand()).contains((String[])new String[]{"--debug"}).andNothingElse();
    }

    public void testL() throws Exception {
        this.checkForCommand("log", HgCommandBuilder.createFilePredecessorsCommand((String)"a123404", (String)"pare'nt.txt").createCommand()).contains((String[])new String[]{"-r", "last(::p1(a123404) and file('pare\\'nt.txt')) or last(::p2(a123404) and file('pare\\'nt.txt'))"}).contains((String[])new String[]{"--template", "{node}\\n"}).andNothingElse();
    }

    private ListAssert<String> checkForCommand(String command, List<String> commandArgs) {
        return this.checkForCommand(command, commandArgs, false);
    }

    private ListAssert<String> checkForCommand(String command, List<String> commandArgs, boolean verbose) {
        ListAssert<String> listAssert = new ListAssert<String>(commandArgs);
        listAssert.contains((String[])new String[]{command});
        if (verbose) {
            listAssert.contains((String[])new String[]{"-v"});
        } else {
            listAssert.contains((String[])new String[]{"--config", "ui.verbose=false"});
        }
        for (int i = 0; i < commandArgs.size(); ++i) {
            String arg = commandArgs.get(i);
            if (arg.equals(command)) {
                return listAssert;
            }
            if (!GLOBAL_ARGS.containsKey(arg)) {
                HgCommandBuilderTest.fail((String)("Found non-global arg before command(\"" + command + "\"): \"" + arg + "\""));
            }
            if (!GLOBAL_ARGS.get(arg).booleanValue()) continue;
            ++i;
        }
        HgCommandBuilderTest.fail((String)"wtf");
        return listAssert;
    }
}

