/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg.client;

import com.atlassian.fisheye.hg.client.HgChangeParser;
import com.atlassian.fisheye.hg.client.HgCommitDetails;
import com.atlassian.utils.process.ProcessException;
import com.cenqua.fisheye.config.AllowRules;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.DiffTextCache;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.util.AntGlob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.mockito.Mockito;

public class HgChangeParserTest
extends TestCase {
    File dir = new File("test/testfiles/hg/parse");
    List<AntGlob> excludes = Collections.singletonList(new AntGlob("**/*.dat"));
    AllowRules allows = new AllowRules(Collections.emptyList(), this.excludes);
    private HgChangeParser parser = new HgChangeParser(Charset.forName("UTF8"), new RepositoryStatus("Test"), (DiffTextCache)Mockito.mock(DiffTextCache.class), this.allows){

        protected boolean processCommit(HgCommitDetails commitDetails) throws DbException {
            return true;
        }
    };

    public void testMergeParser() throws ProcessException, FileNotFoundException {
        this.parser.process((InputStream)new FileInputStream(new File(this.dir, "changeOutputLong.txt")));
        this.parser.process((InputStream)new FileInputStream(new File(this.dir, "changeOutputShort.txt")));
    }

    public void testNoCommitMsg() throws ProcessException, FileNotFoundException {
        this.parser.process((InputStream)new FileInputStream(new File(this.dir, "changeOutputNoDesc.txt")));
    }

    public void testBadDiff() throws FileNotFoundException, ProcessException {
        this.parser.process((InputStream)new FileInputStream(new File(this.dir, "fe3029ParserFail.txt")));
    }
}

