/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg.client;

import com.atlassian.fisheye.hg.client.HgBlameParser;
import com.cenqua.fisheye.rep.DbException;
import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Test;

public class HgBlameParserTest {
    String output = "2ced151e2c71 complex_copy.txt:1: Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut\n2ced151e2c71 complex_copy.txt:2: non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.\n8f4b8d1beed1      complex.txt:1: Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut \n5c4136d3382d      complex.txt:2: non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.\n8f4b8d1beed1      complex.txt:2: labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco \n8f4b8d1beed1      complex.txt:4: voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat \n8f4b8d1beed1      complex.txt:5: non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.\n5c4136d3382d      complex.txt:7: Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut\n5c4136d3382d      complex.txt:8: labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco\nc56ff8af1888      complex.txt:8: Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut\n19a377f0a5ef      complex.txt:9: non proident.\nc56ff8af1888     complex.txt:10: labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco\nc56ff8af1888     complex.txt:11: ";

    @Test
    public void testParser() throws DbException {
        String[] lines = this.output.split("\n");
        final int[] counter = new int[]{0};
        final LinkedList expectedList = new LinkedList(Arrays.asList({"2ced151e2c71", "complex_copy.txt", 1, 1, 2}, {"8f4b8d1beed1", "complex.txt", 1, 3, 1}, {"5c4136d3382d", "complex.txt", 2, 4, 1}, {"8f4b8d1beed1", "complex.txt", 2, 5, 1}, {"8f4b8d1beed1", "complex.txt", 4, 6, 2}, {"5c4136d3382d", "complex.txt", 7, 8, 2}, {"c56ff8af1888", "complex.txt", 8, 10, 1}, {"19a377f0a5ef", "complex.txt", 9, 11, 1}, {"c56ff8af1888", "complex.txt", 10, 12, 1}));
        HgBlameParser parser = new HgBlameParser(Charset.forName("UTF8")){

            protected void endChunk(String commit, String filename, int originalLine, int lineNum, int length) {
                if (expectedList.isEmpty()) {
                    Assert.fail();
                }
                Object[] expected = (Object[])expectedList.remove(0);
                System.out.println(Arrays.toString(expected));
                HgBlameParserTest.this.assertAllEqual(expected, new Object[]{commit, filename, originalLine, lineNum, length});
                counter[0] = counter[0] + 1;
            }
        };
        for (int i = 0; i < lines.length; ++i) {
            parser.processLine(i, lines[i]);
        }
    }

    @Test
    public void shouldHandleEmptyOuput() throws Exception {
        HgBlameParser parser = new HgBlameParser(Charsets.UTF_8){

            protected void endChunk(String commit, String filename, int originalLine, int lineNum, int length) throws DbException {
                Assert.fail((String)"Shouldn't be called for empty output");
            }
        };
        parser.process((InputStream)new ByteArrayInputStream(new byte[0]));
    }

    private void assertAllEqual(Object[] expected, Object[] values) {
        Assert.assertEquals((long)expected.length, (long)5L);
        Assert.assertEquals((long)values.length, (long)5L);
        for (int i = 0; i < 5; ++i) {
            Assert.assertEquals((Object)expected[i], (Object)values[i]);
        }
    }
}

