/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg;

import com.atlassian.fecru.upgrade.UpgradeManager;
import com.atlassian.fisheye.dvcs.DvcsTestHarness;
import com.atlassian.fisheye.hg.HgRepositoryEngine;
import com.atlassian.fisheye.hg.HgScanner;
import com.atlassian.fisheye.hg.HgScmConfig;
import com.atlassian.fisheye.hg.client.HgContext;
import com.atlassian.fisheye.hg.client.HgProcessFactory;
import com.atlassian.fisheye.scmapi.ScmConfig;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.HgConfigType;
import com.cenqua.fisheye.config1.HgRepType;
import com.cenqua.fisheye.config1.PasswordAuthenticationType;
import com.cenqua.fisheye.config1.RepositorySystemType;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.config1.SshKeyAuthenticationType;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.Version;
import com.cenqua.fisheye.rep.impl.DefaultLicenseEnforcer;
import com.jcraft.jsch.JSchException;
import java.io.IOException;
import java.math.BigInteger;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlException;

public class HgTestHarness
extends DvcsTestHarness<HgRepositoryEngine, HgScanner> {
    @Override
    protected HgRepositoryEngine createEngine() throws XmlException, IOException, DbException, ConfigException {
        RepositoryType repoDef;
        try {
            repoDef = this.createHgRepoDef();
        }
        catch (JSchException e) {
            throw new ConfigException((Throwable)e);
        }
        this.createHgServerConfig(this.getScmExecutable());
        HgScmConfig hgConfig = this.createHgScmConfig(repoDef);
        DefaultLicenseEnforcer licenseEnforcer = new DefaultLicenseEnforcer(this.getMaxCommitters());
        RepositoryConfig config = this.createRepositoryConfig(repoDef, hgConfig, licenseEnforcer);
        UpgradeManager upgradeManager = (UpgradeManager)SpringContext.getComponent((String)"upgradeManager");
        return (HgRepositoryEngine)config.createRepositoryEngine(upgradeManager, this.getIndexingContext());
    }

    protected HgScmConfig createHgScmConfig(RepositoryType repoDef) {
        return new HgScmConfig(repoDef.getName(), this.getRootConfig(), (RepositorySystemType)repoDef.getHg(), this.getSshKeyManager(), (HgProcessFactory)SpringContext.getComponentByClass(HgProcessFactory.class));
    }

    protected RepositoryConfig createRepositoryConfig(RepositoryType repoDef, HgScmConfig hgConfig, DefaultLicenseEnforcer licenseEnforcer) {
        return new RepositoryConfig(this.getRootConfig(), repoDef, (ScmConfig)hgConfig, (LicenseEnforcer)licenseEnforcer, null);
    }

    protected RepositoryType createHgRepoDef() throws IOException, XmlException, JSchException {
        PasswordAuthenticationType passwordAuth;
        RepositoryType repoDefinition = this.createRepoDefinition();
        HgRepType hg = repoDefinition.addNewHg();
        if (StringUtils.isNotBlank((String)this.getLocation())) {
            hg.setLocation(this.getLocation());
        } else {
            hg.setLocation(this.getRepoDir().getAbsolutePath());
        }
        if (this.getBlockSize() > 0L) {
            hg.setBlocksize(BigInteger.valueOf(this.getBlockSize()));
        }
        if ((passwordAuth = this.createPasswordAuthDef()) != null) {
            hg.setPasswordAuth(passwordAuth);
        } else {
            SshKeyAuthenticationType sshAuth = this.createSshAuthDef();
            if (sshAuth != null) {
                hg.setSshAuth(sshAuth);
            }
        }
        return repoDefinition;
    }

    private void createHgServerConfig(String hgExecutable) {
        ConfigDocument.Config serverConfig = this.getRootConfig().getConfig();
        serverConfig.setHgConfig(HgConfigType.Factory.newInstance());
        serverConfig.getHgConfig().setHgExecutable(hgExecutable);
    }

    public Version getVersion() throws ConfigException {
        return HgContext.determineHgVersion((String)this.getScmExecutable());
    }
}

