/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg;

import com.atlassian.fisheye.dvcs.DvcsTestBase;
import com.atlassian.fisheye.hg.HgCache;
import com.atlassian.fisheye.hg.HgRepositoryEngine;
import com.atlassian.fisheye.hg.HgScanner;
import com.atlassian.fisheye.hg.HgTestHarness;
import com.atlassian.fisheye.hg.client.HgContext;
import com.atlassian.fisheye.hg.db.HgChangeSet;
import com.atlassian.fisheye.hg.db.HgRevInfo;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.Version;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;

public abstract class HgTestBase
extends DvcsTestBase<HgTestHarness, HgRevInfo, HgChangeSet, HgCache, HgScanner, HgRepositoryEngine, CommonStringTables> {
    public HgTestBase() {
        super("test/testfiles/hg/dumps/");
    }

    @Override
    protected final HgTestHarness createTestHarness() throws IOException {
        HgTestHarness h = this.createHgTestHarness();
        String executable = this.findExecutable();
        h.setScmExecutable(executable);
        try {
            Version hgVersion = HgContext.determineHgVersion((String)executable);
            Logs.APP_LOG.info((Object)("HG version is " + hgVersion));
        }
        catch (ConfigException e) {
            Assert.fail((String)"Could not get Hg version");
        }
        return h;
    }

    protected HgTestHarness createHgTestHarness() {
        return new HgTestHarness();
    }

    @Override
    protected String findExecutable() throws IOException {
        String hgPathSysProp = System.getProperty("hg.exe");
        if (!Strings.isNullOrEmpty((String)hgPathSysProp)) {
            return hgPathSysProp;
        }
        if (AppConfig.getsConfig().getConfigDocument() != null && AppConfig.getsConfig().getConfig() != null && AppConfig.getsConfig().getConfig().isSetHgConfig() && AppConfig.getsConfig().getConfig().getHgConfig().getHgExecutable() != null) {
            return AppConfig.getsConfig().getConfig().getHgConfig().getHgExecutable();
        }
        File hgExecutable = this.fileSystemUtils.searchPath(new String[]{"hg", "hg.exe"});
        if (hgExecutable != null) {
            return hgExecutable.getCanonicalPath();
        }
        List<String> possibleLocations = Arrays.asList("/usr/local/bin/hg", "/opt/local/bin/hg");
        for (String l : possibleLocations) {
            File hg = new File(l);
            if (!hg.exists()) continue;
            return hg.getCanonicalPath();
        }
        Assert.fail((String)"Can't find hg: you need to install hg: http://mercurial.selenic.com");
        return null;
    }
}

