/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg;

import com.atlassian.fisheye.hg.HgCache;
import com.atlassian.fisheye.hg.HgSlurpTestBase;
import com.atlassian.fisheye.hg.HgTestHarness;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class HgTagTest
extends HgSlurpTestBase {
    public HgTagTest() {
        super("test_tag");
    }

    @Test
    public void testTagSlurp() throws Exception {
        List<String> tag = Arrays.asList("test_tag");
        FileHistory history = ((HgCache)this.getCache()).getFileHistory(new Path((CharSequence)"file1.txt"));
        this.assertTags(history, "8774e8ef15f60cfd3be6ce93fdc8b2488d078c08", tag);
        this.assertTags(history, "7fbe3e3371017492b5203963f3e90e32ff1cf0ac", Collections.emptyList());
        history = ((HgCache)this.getCache()).getFileHistory(new Path((CharSequence)"file2.txt"));
        this.assertTags(history, "65ce272d5552b7c3af8bab761a0f2dd27efdb11f", tag);
        this.assertTags(history, "3e863f34bc46081f1a1498e18f846ae49c185e6d", Collections.emptyList());
        ((HgTestHarness)this.testHarness).doIncSlurp(this.getDumpZipFile("test_tag-advanced"));
        history = ((HgCache)this.getCache()).getFileHistory(new Path((CharSequence)"file1.txt"));
        this.assertTags(history, "8774e8ef15f60cfd3be6ce93fdc8b2488d078c08", Collections.emptyList());
        this.assertTags(history, "7fbe3e3371017492b5203963f3e90e32ff1cf0ac", tag);
        history = ((HgCache)this.getCache()).getFileHistory(new Path((CharSequence)"file2.txt"));
        this.assertTags(history, "65ce272d5552b7c3af8bab761a0f2dd27efdb11f", Collections.emptyList());
        this.assertTags(history, "3e863f34bc46081f1a1498e18f846ae49c185e6d", tag);
        ((HgTestHarness)this.testHarness).doIncSlurp(this.getDumpZipFile("test_tag-advanced2"));
        history = ((HgCache)this.getCache()).getFileHistory(new Path((CharSequence)"file1.txt"));
        this.assertTags(history, "8774e8ef15f60cfd3be6ce93fdc8b2488d078c08", Collections.emptyList());
        this.assertTags(history, "7fbe3e3371017492b5203963f3e90e32ff1cf0ac", Arrays.asList("test_tag", "branch_tag"));
        this.assertTags(history, "001ff7008237285b75e7beb0f3a77d23cb65802b", Arrays.asList("default_tag"));
        this.assertTags(history, "a8aaf1487fcd481246c4e78ff63f53042e44cfb4", Collections.emptyList());
        history = ((HgCache)this.getCache()).getFileHistory(new Path((CharSequence)"file2.txt"));
        this.assertTags(history, "65ce272d5552b7c3af8bab761a0f2dd27efdb11f", Collections.emptyList());
        this.assertTags(history, "3e863f34bc46081f1a1498e18f846ae49c185e6d", Arrays.asList("test_tag", "default_tag"));
        this.assertTags(history, "a2c443c7ab12ce816584af4c6cec55b0be4c56ba", Arrays.asList("branch_tag"));
    }

    private void assertTags(FileHistory history, String commit, List<String> expectedTags) {
        FileRevision rev = history.getRevision(commit);
        Assert.assertEquals(expectedTags, (Object)rev.getTags());
    }
}

