/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg;

import com.atlassian.fisheye.hg.HgRepositoryEngine;
import com.atlassian.fisheye.hg.HgScanner;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.rep.BranchState;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class HgScannerTest {
    HgRepositoryEngine engine = (HgRepositoryEngine)Mockito.mock(HgRepositoryEngine.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    HgScanner scanner = new HgScanner(this.engine);

    @Test
    public void testOnBranchHeadUpdated_shouldReturnBranchUnchangedIfExists() throws Exception {
        Branch newBranch = new Branch("hgBranch", "foobarId", BranchState.ACTIVE);
        Branch updateResult = this.scanner.prepareBranchToBeStored(null, newBranch);
        Assert.assertThat((Object)updateResult, (Matcher)Matchers.sameInstance((Object)newBranch));
    }

    @Test
    public void testOnBranchHeadUpdated_shouldMarkAsClosed() throws Exception {
        Branch oldBranch = new Branch("hgBranch", "foobarId", BranchState.ACTIVE);
        Branch updateResult = this.scanner.prepareBranchToBeStored(oldBranch, null);
        Assert.assertThat((Object)updateResult, (Matcher)Matchers.equalTo((Object)new Branch(oldBranch.getName(), oldBranch.getLatestChangeSetId(), BranchState.CLOSED)));
    }
}

