/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg;

import com.atlassian.fisheye.hg.HgCache;
import com.atlassian.fisheye.hg.HgTestBase;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.FileRevision;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class HgRevisionResolutionTest
extends HgTestBase {
    @Test
    public void testHeadFindFileRevision() throws Exception {
        this.slurpDump("basic");
        FileRevision fileRevisionHead = ((HgCache)this.getCache()).findFileRevision(new Path((CharSequence)"file1.txt"), "HEAD");
        Assert.assertNotNull((Object)fileRevisionHead);
        FileRevision fileRevisionDefault = ((HgCache)this.getCache()).findFileRevision(new Path((CharSequence)"file1.txt"), "default");
        Assert.assertThat((Object)fileRevisionDefault.getRevision(), (Matcher)CoreMatchers.equalTo((Object)fileRevisionHead.getRevision()));
    }

    @Test
    public void testFindFileRevisionByRevisionFull() throws Exception {
        this.slurpDump("basic");
        Assert.assertThat((Object)"a8b9fb6c14a45fb2e60ad8b7faa253a7f1a07f23", (Matcher)CoreMatchers.equalTo((Object)((HgCache)this.getCache()).findFileRevision(new Path((CharSequence)"file1.txt"), "a8b9fb6c14a45fb2e60ad8b7faa253a7f1a07f23").getRevision()));
        Assert.assertThat((Object)"6befb7b0fa111bb49c4dec9f74f624992ae02fbe", (Matcher)CoreMatchers.equalTo((Object)((HgCache)this.getCache()).findFileRevision(new Path((CharSequence)"file1.txt"), "6befb7b0fa111bb49c4dec9f74f624992ae02fbe").getRevision()));
    }

    @Test
    public void testFindFileRevisionByRevisionPartial() throws Exception {
        this.slurpDump("basic");
        Assert.assertThat((Object)"a8b9fb6c14a45fb2e60ad8b7faa253a7f1a07f23", (Matcher)CoreMatchers.equalTo((Object)((HgCache)this.getCache()).findFileRevision(new Path((CharSequence)"file1.txt"), "a8b9f").getRevision()));
        Assert.assertThat((Object)"6befb7b0fa111bb49c4dec9f74f624992ae02fbe", (Matcher)CoreMatchers.equalTo((Object)((HgCache)this.getCache()).findFileRevision(new Path((CharSequence)"file1.txt"), "6befb").getRevision()));
    }

    @Test
    public void testFindFileRevisionByBranch() throws Exception {
        this.slurpDump("branch-merge-3");
        Assert.assertNotNull((Object)((HgCache)this.getCache()).findFileRevision(new Path((CharSequence)"file3"), "wow").getRevision());
    }
}

