/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg;

import com.atlassian.fisheye.event.DvcsCommitEventImpl;
import com.atlassian.fisheye.event.RepositoryScanProcessedEvent;
import com.atlassian.fisheye.hg.HgTestBase;
import com.atlassian.fisheye.hg.HgTestHarness;
import com.atlassian.fisheye.rep.RepositoryEventCollector;
import com.cenqua.fisheye.rep.BranchChange;
import com.cenqua.fisheye.rep.Version;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class HgRepositoryScanProcessedEventTest
extends HgTestBase {
    private RepositoryEventCollector eventCollector = new RepositoryEventCollector();

    @Override
    protected HgTestHarness createHgTestHarness() {
        return new HgTestHarness(){

            @Override
            protected void beforeEngineStarted() {
                super.beforeEngineStarted();
                this.registerCommitEventGenerator();
                this.getEventPublisher().register((Object)HgRepositoryScanProcessedEventTest.this.eventCollector);
            }
        };
    }

    @Test
    public void testScanProcessedEvent() throws Exception {
        if (((HgTestHarness)this.testHarness).getVersion().compareTo(new Version("1.7.5")) < 0) {
            return;
        }
        this.slurpDump("scanprocessed-step1");
        List<Object> eventsAfterInitial = this.eventCollector.getAndClearEvents();
        this.slurpIncremental("scanprocessed-step2");
        List<Object> eventsAfterIncremental = this.eventCollector.getAndClearEvents();
        this.slurpIncremental("scanprocessed-step2");
        List<Object> eventsAfterSubsequent = this.eventCollector.getAndClearEvents();
        Assert.assertThat(eventsAfterInitial, (Matcher)Matchers.empty());
        Assert.assertThat(eventsAfterIncremental, (Matcher)Matchers.contains((Object[])new Object[]{new DvcsCommitEventImpl(((HgTestHarness)this.testHarness).getRepoName(), "aefd7d126c9277e36ac720c6d1f797111cdf44d0", false), new DvcsCommitEventImpl(((HgTestHarness)this.testHarness).getRepoName(), "d11816f08146f18e9dc2a3069c08385d80cf837d", false), new DvcsCommitEventImpl(((HgTestHarness)this.testHarness).getRepoName(), "47e22867ae739eb7702df296c8fdcfdfb17b0252", false), new RepositoryScanProcessedEvent(((HgTestHarness)this.testHarness).getRepoName(), (Iterable)ImmutableSet.of((Object)"aefd7d126c9277e36ac720c6d1f797111cdf44d0", (Object)"d11816f08146f18e9dc2a3069c08385d80cf837d", (Object)"47e22867ae739eb7702df296c8fdcfdfb17b0252"), (Iterable)ImmutableSet.of((Object)new BranchChange("branch1", BranchChange.ChangeType.MODIFIED), (Object)new BranchChange("branch2", BranchChange.ChangeType.REMOVED), (Object)new BranchChange("branch3", BranchChange.ChangeType.ADDED)))}));
        Assert.assertThat(eventsAfterSubsequent, (Matcher)Matchers.empty());
    }
}

