/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg;

import com.atlassian.fisheye.hg.HgCache;
import com.atlassian.fisheye.hg.HgSlurpTestBase;
import com.atlassian.fisheye.hg.HgTestHarness;
import com.atlassian.fisheye.hg.db.HgRevInfo;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.jcraft.jsch.JSchException;
import java.io.IOException;
import java.math.BigInteger;
import org.apache.xmlbeans.XmlException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class HgOversizeLinecountsTest
extends HgSlurpTestBase {
    public HgOversizeLinecountsTest() {
        super("oversizelines");
    }

    @Override
    protected HgTestHarness createHgTestHarness() {
        return new HgTestHarness(){

            @Override
            protected RepositoryType createHgRepoDef() throws IOException, XmlException, JSchException {
                RepositoryType hgRepoDef = super.createHgRepoDef();
                hgRepoDef.setMaxIndexableSize(BigInteger.valueOf(50L));
                return hgRepoDef;
            }
        };
    }

    @Test
    public void shouldHandleOversizeLinecounts() throws Exception {
        this.assertLinecounts("test", "e5d4e8759b2f", 2, 1, 0);
        this.assertLinecounts("test", "d21378fc5dd9", 0, 0, 2);
        this.assertLinecounts("test", "91a6d29a12f1", 2, 2, 0);
        this.assertLinecounts("test2", "00087ea33298", 2, 2, 0);
        this.assertLinecounts("test3", "cbdc427e9bd8", 0, 0, 0);
    }

    protected void assertLinecounts(String path, String csid, int total, int added, int removed) {
        HgRevInfo rev = (HgRevInfo)((HgCache)this.getCache()).getFileRevision(new RevInfoKey(new Path((CharSequence)path), csid));
        Assert.assertThat((Object)rev.getLineCount(), (Matcher)Matchers.equalTo((Object)total));
        Assert.assertThat((Object)rev.getLinesAdded(), (Matcher)Matchers.equalTo((Object)added));
        Assert.assertThat((Object)rev.getLinesRemoved(), (Matcher)Matchers.equalTo((Object)removed));
    }
}

