/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg;

import com.atlassian.fisheye.dvcs.DvcsRepoValidation;
import com.atlassian.fisheye.hg.HgCache;
import com.atlassian.fisheye.hg.HgSlurpTestBase;
import com.atlassian.fisheye.hg.db.HgChangeSet;
import com.cenqua.fisheye.rep.DbException;
import java.util.ListIterator;
import junit.framework.TestCase;
import org.junit.Test;

public class HgNextHeadsTest
extends HgSlurpTestBase {
    private static final String HASH_0 = "d8f8432fa1a75e80e0bb975962550aaf37eab811";
    private static final String HASH_1 = "73d1fd039812c6f292d130c51abd968b5e4eca88";
    private static final String HASH_2 = "c95547459b16cc1ba04ff9a370b908d56795c19d";
    private static final String HASH_3 = "68316aa6d1c8e185901123eb9b40035c596b303c";
    private static final String HASH_4 = "ab6f7720cf850256a9705b0693f4457da1f7c6e5";
    private static final String HASH_5 = "9a19f196c4656abd9befa273a76c8e08711e7319";
    private static final String HASH_6 = "792c7e9e284272c486ba2032b9800da830ddb93d";
    private static final String HASH_7 = "8c8381847791718cf971abf249f524e77573c9a5";

    public HgNextHeadsTest() {
        super("hg-test-next-heads");
    }

    @Test
    public void runTest() throws DbException {
        ListIterator it = ((HgCache)this.getCache()).getChangeSetDAO().getChangeSets().iterator();
        TestCase.assertTrue((boolean)it.hasNext());
        TestCase.assertEquals((String)((HgChangeSet)it.next()).getId(), (String)HASH_0);
        TestCase.assertEquals((String)((HgChangeSet)it.next()).getId(), (String)HASH_1);
        TestCase.assertEquals((String)((HgChangeSet)it.next()).getId(), (String)HASH_2);
        TestCase.assertEquals((String)((HgChangeSet)it.next()).getId(), (String)HASH_3);
        TestCase.assertEquals((String)((HgChangeSet)it.next()).getId(), (String)HASH_4);
        TestCase.assertEquals((String)((HgChangeSet)it.next()).getId(), (String)HASH_5);
        TestCase.assertEquals((String)((HgChangeSet)it.next()).getId(), (String)HASH_6);
        TestCase.assertEquals((String)((HgChangeSet)it.next()).getId(), (String)HASH_7);
        TestCase.assertFalse((boolean)it.hasNext());
        this.assertCommitData(DvcsRepoValidation.Commits.first(this.defaultCommit(HASH_0).desc("Adding A.txt on default").date(1300244569000L)).next(this.defaultCommit(HASH_1).parents(HASH_0).desc("Adding B on default").date(1300244902000L).nextCrossBranchCommits(HASH_2, HASH_3)).next(this.branch1Commit(HASH_2).parents(HASH_0).desc("Adding C.txt on branch-1").date(1300244973000L).nextCrossBranchCommits(HASH_7, HASH_3)).next(this.branch2Commit(HASH_3).parents(HASH_0).desc("Adding D.txt on branch-2").date(1300245007000L).nextCrossBranchCommits(HASH_7, HASH_4)).next(this.branch1Commit(HASH_4).parents(HASH_2).desc("Adding E.txt on branch-1").date(1300245068000L).nextCrossBranchCommits(HASH_7, HASH_5)).next(this.branch2Commit(HASH_5).parents(HASH_3).desc("Adding F.txt on branch-2").date(1300245120000L).nextCrossBranchCommits(HASH_7)).next(this.branch1Commit(HASH_6).parents(HASH_4, HASH_5).desc("merging branch-2 to branch-1").date(1300245148000L).fileRevs(0)).next(this.defaultCommit(HASH_7).parents(HASH_1, HASH_6).desc("merging branch-1 to default").date(1300245172000L).fileRevs(0)).l());
    }

    private DvcsRepoValidation.Commit branch2Commit(String hash) {
        return this.commit(hash).branch("branch-2");
    }

    private DvcsRepoValidation.Commit branch1Commit(String hash) {
        return this.commit(hash).branch("branch-1");
    }

    private DvcsRepoValidation.Commit defaultCommit(String hash) {
        return this.commit(hash).branch("default");
    }

    private DvcsRepoValidation.Commit commit(String hash) {
        return new DvcsRepoValidation.Commit(hash).author("Anna Buttfield <abuttfield@atlassian.com>").fileRevs(1);
    }
}

