/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg;

import com.atlassian.fisheye.dvcs.DvcsRepoValidation;
import com.atlassian.fisheye.hg.HgCache;
import com.atlassian.fisheye.hg.HgSlurpTestBase;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.lucene.BranchIndexingChecker;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class HgNamedBranchesSlurpTest
extends HgSlurpTestBase {
    public HgNamedBranchesSlurpTest() {
        super("named-branches");
    }

    @Test
    public void testNamedBranchesSlurp() throws Exception {
        FileHistory history = ((HgCache)this.getCache()).getFileHistory(new Path((CharSequence)"foo3"));
        Assert.assertEquals((long)5L, (long)history.getRevisions().size());
        FileRevision rev = history.getRevision("d395f37b4da0fc7ff3228a343a0396bbac1dcabd");
        Assert.assertEquals((long)1L, (long)rev.getAncestors().size());
        Assert.assertEquals((Object)"ef447997aada82b428e26205a21adcfd72a7496f", (Object)((RevInfoKey)rev.getAncestors().get(0)).getRev());
        this.assertCommitData(DvcsRepoValidation.Commits.first("e9507ac4b2385873002d7945f7a560dff84666e3", "mwatson", "add foo1", "default", 1272339551000L, 1).next("7b4ad860302feaac0cb9a6e23b2ee19622aba7d2", "e9507ac4b2385873002d7945f7a560dff84666e3", "mwatson", "add foo2", "default", 1272339574000L, 1).next("d1928cfd395f3098402087b373060bf3abe28599", "e9507ac4b2385873002d7945f7a560dff84666e3", "mwatson", "add foo3", "default", 1272339614000L, 1).next("5e41cb31235429dbcd0f68d9f2b9162100d0aef2", "d1928cfd395f3098402087b373060bf3abe28599", "mwatson", "mod foo3", "foo3-branch", 1272339676000L, 1).next("cbb6930eac10745ac32960b3b6730e1f6d89a61f", "d1928cfd395f3098402087b373060bf3abe28599", "mwatson", "mod foo1", "default", 1272339734000L, 1).next("093ea7e79e451bb51ec773974430c5638e465906", Arrays.asList("cbb6930eac10745ac32960b3b6730e1f6d89a61f", "7b4ad860302feaac0cb9a6e23b2ee19622aba7d2"), "mwatson", "merge on default", "default", 1272339827000L, 0).next("50363bfba4d2679656f89c6823ba5420b1e9c2cf", "093ea7e79e451bb51ec773974430c5638e465906", "mwatson", "mod foo2", "default", 1272339851000L, 1).next("ef447997aada82b428e26205a21adcfd72a7496f", "5e41cb31235429dbcd0f68d9f2b9162100d0aef2", "mwatson", "mod foo3", "foo3-branch", 1272339890000L, 1).next("f18ee18dabfd1c5b70b174e110fbb65d0fa3045b", Arrays.asList("50363bfba4d2679656f89c6823ba5420b1e9c2cf", "ef447997aada82b428e26205a21adcfd72a7496f"), "mwatson", "merge foo3-branch onto default", "default", 1272340170000L, 0).next("70e9c87c0d096bd9273298ef2eff84ca5f3e9ad5", "ef447997aada82b428e26205a21adcfd72a7496f", "mwatson", "mod foo3", "foo3-branch", 1272340199000L, 1).next("d395f37b4da0fc7ff3228a343a0396bbac1dcabd", "f18ee18dabfd1c5b70b174e110fbb65d0fa3045b", "mwatson", "mod foo3", "default", 1272340978000L, 1).next("208d1ae72000669b459d4fe7be84be00da38bc7b", "ef447997aada82b428e26205a21adcfd72a7496f", "mwatson", "branch with no changes", "foo4-branch", 1273809381000L, 0).l());
        this.assertRevisionData(DvcsRepoValidation.FileRevs.file("foo1").rev("e9507ac4b2385873002d7945f7a560dff84666e3", null, null, "mwatson", "add foo1", 1272339551000L, "default", DvcsRepoValidation.RevState.Added, "foo1", false, 1, 1, 0).rev("cbb6930eac10745ac32960b3b6730e1f6d89a61f", "e9507ac4b2385873002d7945f7a560dff84666e3", null, "mwatson", "mod foo1", 1272339734000L, "default", DvcsRepoValidation.RevState.Modified, "foo1", false, 2, 1, 0));
        this.assertRevisionData(DvcsRepoValidation.FileRevs.file("foo2").rev("7b4ad860302feaac0cb9a6e23b2ee19622aba7d2", null, null, "mwatson", "add foo2", 1272339574000L, "default", DvcsRepoValidation.RevState.Added, "foo2", false, 1, 1, 0).rev("50363bfba4d2679656f89c6823ba5420b1e9c2cf", "7b4ad860302feaac0cb9a6e23b2ee19622aba7d2", null, "mwatson", "mod foo2", 1272339851000L, "default", DvcsRepoValidation.RevState.Modified, "foo2", false, 2, 1, 0));
        this.assertRevisionData(DvcsRepoValidation.FileRevs.file("foo3").rev("d1928cfd395f3098402087b373060bf3abe28599", null, null, "mwatson", "add foo3", 1272339614000L, "default", DvcsRepoValidation.RevState.Added, "foo3", false, 1, 1, 0).rev("5e41cb31235429dbcd0f68d9f2b9162100d0aef2", "d1928cfd395f3098402087b373060bf3abe28599", null, "mwatson", "mod foo3", 1272339676000L, "foo3-branch", DvcsRepoValidation.RevState.Modified, "foo3", false, 2, 1, 0).rev("ef447997aada82b428e26205a21adcfd72a7496f", "5e41cb31235429dbcd0f68d9f2b9162100d0aef2", null, "mwatson", "mod foo3", 1272339890000L, "foo3-branch", DvcsRepoValidation.RevState.Modified, "foo3", false, 3, 1, 0).rev("70e9c87c0d096bd9273298ef2eff84ca5f3e9ad5", "ef447997aada82b428e26205a21adcfd72a7496f", null, "mwatson", "mod foo3", 1272340199000L, "foo3-branch", DvcsRepoValidation.RevState.Modified, "foo3", false, 4, 1, 0).rev("d395f37b4da0fc7ff3228a343a0396bbac1dcabd", "ef447997aada82b428e26205a21adcfd72a7496f", null, "mwatson", "mod foo3", 1272340978000L, "default", DvcsRepoValidation.RevState.Modified, "foo3", false, 4, 1, 0));
    }

    @Test
    public void testBranchIndexing() {
        BranchIndexingChecker.verifyIndexedBranchesWithRevCache(this.getCache());
    }
}

