/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg;

import com.atlassian.fisheye.bucket.BucketDataCollectionTotalled;
import com.atlassian.fisheye.bucket.BucketDataElement;
import com.atlassian.fisheye.bucket.BucketGraph;
import com.atlassian.fisheye.bucket.ParameterSetQuery;
import com.atlassian.fisheye.hg.HgRepositoryEngine;
import com.atlassian.fisheye.hg.HgTestBase;
import com.atlassian.fisheye.hg.HgTestHarness;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.DbException;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import java.util.List;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HgMergeLocTest
extends HgTestBase {
    private BucketGraph dataCollector;
    private String[] files = new String[]{"", "FileA.txt", "FileB.txt", "FileC.txt", "FileD.txt", "FileE.txt"};

    @Before
    public void setUp() throws Exception {
        this.slurpDump("test-merge-loc");
        HgRepositoryEngine engine = (HgRepositoryEngine)((HgTestHarness)this.testHarness).getEngine();
        AppConfig.getsConfig().setTimezone(TimeZone.getTimeZone("Australia/Sydney"));
        this.dataCollector = engine.getBucketGraph();
        this.dataCollector.reindex(engine.getLinecountCalculator(), engine.getStatus());
    }

    @Test
    public void testBranchLoc() throws Exception {
        Assert.assertTrue((String)"disabled for the moment", (boolean)true);
    }

    private void assertNoData(List<Int2ObjectSortedMap<BucketDataElement>> data, int day) {
        for (Int2ObjectSortedMap<BucketDataElement> e : data) {
            Assert.assertTrue((!e.containsKey(day) || "[0,0]".equals(((BucketDataElement)e.get(day)).toString()) ? 1 : 0) != 0);
        }
    }

    private void assertBuckets(List<Int2ObjectSortedMap<BucketDataElement>> buckets, int bucket, String ... expectedValues) {
        for (int i = 0; i < this.files.length; ++i) {
            String expected = expectedValues[i] == null ? "[0,0]" : expectedValues[i];
            String actual = buckets.get(i) == null || buckets.get(i).get(bucket) == null ? "[0,0]" : ((BucketDataElement)buckets.get(i).get(bucket)).toString();
            Assert.assertEquals((Object)expected, (Object)actual);
        }
    }

    private BucketDataCollectionTotalled getBuckets(String branch, Path path) throws DbException {
        ParameterSetQuery params = new ParameterSetQuery();
        params.setBranch(branch);
        params.setPath(path);
        return this.dataCollector.getBuckets(params);
    }
}

