/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg;

import com.atlassian.fisheye.dvcs.DvcsRepoValidation;
import com.atlassian.fisheye.hg.HgCache;
import com.atlassian.fisheye.hg.HgTestBase;
import com.atlassian.fisheye.hg.HgTestHarness;
import com.atlassian.fisheye.hg.testutil.HgTestChangeLog;
import com.atlassian.fisheye.hg.testutil.HgTestManifest;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.FileRevision;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.junit.Assert;

public class HgIncrementalTestCase
extends HgTestBase {
    protected Logger logger = Logs.APP_LOG;
    protected Step initial = new Step.Builder("incremental-initial").commits(DvcsRepoValidation.Commits.first("828762473510069fa17ec7151d1c86205ff9b71d", "hguser", "Incremental test starting point", "default", 1278293268000L, 2).l()).revs(DvcsRepoValidation.FileRevs.file("file1.txt").rev("828762473510069fa17ec7151d1c86205ff9b71d", null, null, "hguser", "Incremental test starting point", 1278293268000L, "default", DvcsRepoValidation.RevState.Added, "file1.txt", false, 1, 1, 0)).revs(DvcsRepoValidation.FileRevs.file("sub/file2.txt").rev("828762473510069fa17ec7151d1c86205ff9b71d", null, null, "hguser", "Incremental test starting point", 1278293268000L, "default", DvcsRepoValidation.RevState.Added, "sub/file2.txt", false, 1, 1, 0)).build();

    private Step[] copySteps(Step[] original, int fromIndex, int toIndex) {
        Step[] copy = new Step[toIndex - fromIndex];
        for (int i = fromIndex; i < toIndex; ++i) {
            copy[i - fromIndex] = original[i];
        }
        return copy;
    }

    public void incrementalTest(Step ... steps) throws Exception {
        this.internalTestIncremental(steps);
    }

    private void internalTestIncremental(Step ... steps) throws Exception {
        if (this.logger.isDebugEnabled()) {
            StringBuilder scenario = new StringBuilder().append("testing scenario:");
            for (Step step : steps) {
                scenario.append(" ").append(step.target);
            }
            this.logger.debug((Object)scenario.toString());
        }
        if (steps.length > 0) {
            Step cumulativeStep = steps[0].clone();
            this.initialSlurp(steps[0].target);
            this.verify(cumulativeStep);
            for (int i = 1; i < steps.length; ++i) {
                cumulativeStep.add(steps[i]);
                this.incrementalSlurp(cumulativeStep.target);
                this.verify(cumulativeStep);
            }
        }
    }

    protected void initialSlurp(String target) throws Exception {
        this.slurpDump(target);
    }

    protected void incrementalSlurp(String target) throws Exception {
        ((HgTestHarness)this.testHarness).doIncSlurp(this.getDumpZipFile(target));
    }

    protected void verify(Step step) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("verifying step " + step.target));
        }
        this.assertCommitData(step.commits);
        for (DvcsRepoValidation.FileRevs revs : step.revs.values()) {
            this.assertRevisionData(revs);
        }
        HgTestChangeLog changeLog = new HgTestChangeLog(step.commits, step.revs.values(), step.tagActions);
        for (HgTestManifest mf : changeLog.manifestRevs) {
            for (DvcsRepoValidation.Revision expected : mf.revisions.values()) {
                FileRevision actual = ((HgCache)this.getCache()).getFileHistory(new Path((CharSequence)expected.name)).getRevision(expected.rev);
                if (actual == null) continue;
                Set<String> expectedTags = changeLog.getTags(expected.name, expected.rev);
                HashSet actualTags = new HashSet();
                actualTags.addAll(actual.getTags());
                Assert.assertEquals((String)(step.target + ":(MF " + mf.revision + ", file " + expected + ") tags for " + actual.getPath() + " do not match expected tags"), expectedTags, actualTags);
            }
        }
        for (Validator validator : step.validators) {
            validator.validate((HgCache)this.getCache(), step);
        }
    }

    public static class TagAction {
        private String revision;
        private String tag;
        private Action action;

        public TagAction(String tag, Action action, String revision) {
            this.revision = revision;
            this.action = action;
            this.tag = tag;
        }

        public String getTag() {
            return this.tag;
        }

        public Action getAction() {
            return this.action;
        }

        public String getRevision() {
            return this.revision;
        }

        public static enum Action {
            ADDED,
            REMOVED;

        }
    }

    public static class Step
    implements Cloneable {
        public String target;
        public List<DvcsRepoValidation.Commit> commits = new ArrayList<DvcsRepoValidation.Commit>();
        public Map<String, DvcsRepoValidation.FileRevs> revs = new HashMap<String, DvcsRepoValidation.FileRevs>();
        public List<TagAction> tagActions = new ArrayList<TagAction>();
        public List<Validator> validators = new ArrayList<Validator>();

        public Step clone() {
            Step clone = null;
            try {
                clone = (Step)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
            clone.commits = new ArrayList<DvcsRepoValidation.Commit>();
            clone.commits.addAll(this.commits);
            clone.revs = new HashMap<String, DvcsRepoValidation.FileRevs>();
            clone.revs.putAll(this.revs);
            return clone;
        }

        public void add(Step step) {
            this.target = step.target;
            this.commits.addAll(step.commits);
            for (Map.Entry<String, DvcsRepoValidation.FileRevs> entry : step.revs.entrySet()) {
                DvcsRepoValidation.FileRevs rev = this.revs.get(entry.getKey());
                if (rev != null) {
                    rev.revisions.addAll(entry.getValue().revisions);
                    continue;
                }
                this.revs.put(entry.getKey(), entry.getValue().clone());
            }
            this.tagActions.addAll(step.tagActions);
            this.validators.clear();
            this.validators.addAll(step.validators);
        }

        public static class Builder {
            private Step step = new Step();

            public Builder(String target) {
                this.step.target = target;
            }

            public Builder target(String target) {
                this.step.target = target;
                return this;
            }

            public Builder commits(List<DvcsRepoValidation.Commit> commits) {
                this.step.commits.addAll(commits);
                return this;
            }

            public Builder revs(DvcsRepoValidation.FileRevs revs) {
                this.step.revs.put(revs.name, revs);
                return this;
            }

            public Builder revs(Map<String, DvcsRepoValidation.FileRevs> revs) {
                this.step.revs.putAll(revs);
                return this;
            }

            public Builder tag(TagAction action) {
                this.step.tagActions.add(action);
                return this;
            }

            public Builder validator(Validator validator) {
                this.step.validators.add(validator);
                return this;
            }

            public Step build() {
                return this.step;
            }
        }
    }

    public static interface Validator {
        public void validate(HgCache var1, Step var2) throws Exception;
    }
}

