/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg;

import com.atlassian.fisheye.dvcs.DvcsRepoValidation;
import com.atlassian.fisheye.hg.HgCache;
import com.atlassian.fisheye.hg.HgIncrementalTestCase;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.svn.BlameChunkMatcher;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class HgIncrementalTest
extends HgIncrementalTestCase {
    @Override
    public boolean isFlagWarnings() {
        return true;
    }

    @Test
    public void testPlainModification() throws Exception {
        HgIncrementalTestCase.Step plain1 = new HgIncrementalTestCase.Step.Builder("plain-1").commits(DvcsRepoValidation.Commits.first("f70b3e8d40cd67b4da3c9c0a9e6a1d438f3a17b2", "828762473510069fa17ec7151d1c86205ff9b71d", "hguser", "added a line to file1.txt", "default", 1278293352000L, 1).l()).revs(DvcsRepoValidation.FileRevs.file("file1.txt").rev("f70b3e8d40cd67b4da3c9c0a9e6a1d438f3a17b2", "828762473510069fa17ec7151d1c86205ff9b71d", null, "hguser", "added a line to file1.txt", 1278293352000L, "default", DvcsRepoValidation.RevState.Modified, "file1.txt", false, 2, 1, 0)).build();
        HgIncrementalTestCase.Step plain2 = new HgIncrementalTestCase.Step.Builder("plain-2").commits(DvcsRepoValidation.Commits.first("94993fc41c9ee0dd1959b4312a48a65fba19a3ca", "f70b3e8d40cd67b4da3c9c0a9e6a1d438f3a17b2", "hguser", "moved file2.txt to file3.txt", "default", 1278293473000L, 2).l()).revs(DvcsRepoValidation.FileRevs.file("sub/file3.txt").rev("94993fc41c9ee0dd1959b4312a48a65fba19a3ca", "828762473510069fa17ec7151d1c86205ff9b71d", null, "hguser", "moved file2.txt to file3.txt", 1278293473000L, "default", DvcsRepoValidation.RevState.Renamed, "sub/file2.txt", false, 1, 0, 0)).revs(DvcsRepoValidation.FileRevs.file("sub/file2.txt").rev("94993fc41c9ee0dd1959b4312a48a65fba19a3ca", "828762473510069fa17ec7151d1c86205ff9b71d", null, "hguser", "moved file2.txt to file3.txt", 1278293473000L, "default", DvcsRepoValidation.RevState.Deleted, "sub/file2.txt", false, 0, 0, 1)).build();
        HgIncrementalTestCase.Step plain3 = new HgIncrementalTestCase.Step.Builder("plain-3").commits(DvcsRepoValidation.Commits.first("888d90f8bbf0ce03b1f555c021b0127beded714f", "94993fc41c9ee0dd1959b4312a48a65fba19a3ca", "hguser", "Added file4.bin", "default", 1278293718000L, 1).l()).revs(DvcsRepoValidation.FileRevs.file("sub/file4.bin").rev("888d90f8bbf0ce03b1f555c021b0127beded714f", null, null, "hguser", "Added file4.bin", 1278293718000L, "default", DvcsRepoValidation.RevState.Added, "sub/file4.bin", true, 0, 0, 0)).build();
        HgIncrementalTestCase.Step plain4 = new HgIncrementalTestCase.Step.Builder("plain-4").commits(DvcsRepoValidation.Commits.first("bb13eda6e02a1b5ae981f7839d2b32c42569b5a8", "888d90f8bbf0ce03b1f555c021b0127beded714f", "hguser", "deleted file1.txt", "default", 1278293772000L, 1).l()).revs(DvcsRepoValidation.FileRevs.file("file1.txt").rev("bb13eda6e02a1b5ae981f7839d2b32c42569b5a8", "f70b3e8d40cd67b4da3c9c0a9e6a1d438f3a17b2", null, "hguser", "deleted file1.txt", 1278293772000L, "default", DvcsRepoValidation.RevState.Deleted, "file1.txt", false, 0, 0, 2)).build();
        this.incrementalTest(this.initial, plain1, plain2, plain3, plain4);
    }

    @Test
    public void testAddAndRemoveFile() throws Exception {
        HgIncrementalTestCase.Step addRemove1 = new HgIncrementalTestCase.Step.Builder("add-remove-1").commits(DvcsRepoValidation.Commits.first("215642e5e46359554978137a6c941fcca256f4da", "828762473510069fa17ec7151d1c86205ff9b71d", "hguser", "added file sub/file3.java", "default", 1278298423000L, 1).l()).revs(DvcsRepoValidation.FileRevs.file("sub/file3.java").rev("215642e5e46359554978137a6c941fcca256f4da", null, null, "hguser", "added file sub/file3.java", 1278298423000L, "default", DvcsRepoValidation.RevState.Added, "sub/file3.java", false, 1, 1, 0)).build();
        HgIncrementalTestCase.Step addRemove2 = new HgIncrementalTestCase.Step.Builder("add-remove-2").commits(DvcsRepoValidation.Commits.first("f4a497b7b517f23983ab99d73841b60487cc4d8c", "215642e5e46359554978137a6c941fcca256f4da", "hguser", "removed sub/file3.java", "default", 1278298456000L, 1).l()).revs(DvcsRepoValidation.FileRevs.file("sub/file3.java").rev("f4a497b7b517f23983ab99d73841b60487cc4d8c", "215642e5e46359554978137a6c941fcca256f4da", null, "hguser", "removed sub/file3.java", 1278298456000L, "default", DvcsRepoValidation.RevState.Deleted, "sub/file3.java", false, 0, 0, 1)).build();
        HgIncrementalTestCase.Step addRemove3 = new HgIncrementalTestCase.Step.Builder("add-remove-3").commits(DvcsRepoValidation.Commits.first("9baa1b9f5916bd686ef21b535b8ca0f44ee8c0e3", "f4a497b7b517f23983ab99d73841b60487cc4d8c", "hguser", "Added a new file 'sub/file3.txt'", "default", 1278298545000L, 1).l()).revs(DvcsRepoValidation.FileRevs.file("sub/file3.java").rev("9baa1b9f5916bd686ef21b535b8ca0f44ee8c0e3", null, null, "hguser", "Added a new file 'sub/file3.txt'", 1278298545000L, "default", DvcsRepoValidation.RevState.Added, "sub/file3.java", false, 1, 1, 0)).build();
        this.incrementalTest(this.initial, addRemove1, addRemove2, addRemove3);
    }

    @Test
    public void testBranchAndMerge() throws Exception {
        HgIncrementalTestCase.Step branchAndMerge1 = new HgIncrementalTestCase.Step.Builder("inc-branch-merge-1").commits(DvcsRepoValidation.Commits.first("808bc0dcebbefa489f253de1ebe68f0686f48a1d", "828762473510069fa17ec7151d1c86205ff9b71d", "hguser", "created branch1", "branch1", 1278299306000L, 0).l()).build();
        HgIncrementalTestCase.Step branchAndMerge2 = new HgIncrementalTestCase.Step.Builder("inc-branch-merge-2").commits(DvcsRepoValidation.Commits.first("02e28770d1e332c31f837ce2af8baf1061edff98", "808bc0dcebbefa489f253de1ebe68f0686f48a1d", "hguser", "deleted file2.txt", "branch1", 1278299631000L, 1).l()).revs(DvcsRepoValidation.FileRevs.file("sub/file2.txt").rev("02e28770d1e332c31f837ce2af8baf1061edff98", "828762473510069fa17ec7151d1c86205ff9b71d", null, "hguser", "deleted file2.txt", 1278299631000L, "branch1", DvcsRepoValidation.RevState.Deleted, "sub/file2.txt", false, 0, 0, 1)).build();
        HgIncrementalTestCase.Step branchAndMerge3 = new HgIncrementalTestCase.Step.Builder("inc-branch-merge-3").commits(DvcsRepoValidation.Commits.first("aed9dcd805bc7edfa1776f73515db0b9e3763eda", "828762473510069fa17ec7151d1c86205ff9b71d", "hguser", "altered file2.txt", "default", 1278299697000L, 1).l()).revs(DvcsRepoValidation.FileRevs.file("sub/file2.txt").rev("aed9dcd805bc7edfa1776f73515db0b9e3763eda", "828762473510069fa17ec7151d1c86205ff9b71d", null, "hguser", "altered file2.txt", 1278299697000L, "default", DvcsRepoValidation.RevState.Modified, "sub/file2.txt", false, 2, 1, 0)).build();
        HgIncrementalTestCase.Step branchAndMerge4 = new HgIncrementalTestCase.Step.Builder("inc-branch-merge-4").commits(DvcsRepoValidation.Commits.first("f767f0106b3126d2a0de357fdeeb81dc6106deab", Arrays.asList("aed9dcd805bc7edfa1776f73515db0b9e3763eda", "02e28770d1e332c31f837ce2af8baf1061edff98"), "hguser", "merged branch1 to default", "default", 1278299827000L, 0).l()).build();
        HgIncrementalTestCase.Step branchAndMerge5 = new HgIncrementalTestCase.Step.Builder("inc-branch-merge-5").commits(DvcsRepoValidation.Commits.first("afcc494cbfb9094898ba02047e9bedf87c1999ef", "02e28770d1e332c31f837ce2af8baf1061edff98", "hguser", "added file3.zip", "branch1", 1278299890000L, 1).l()).revs(DvcsRepoValidation.FileRevs.file("file3.zip").rev("afcc494cbfb9094898ba02047e9bedf87c1999ef", null, null, "hguser", "added file3.zip", 1278299890000L, "branch1", DvcsRepoValidation.RevState.Added, "file3.zip", true, 0, 0, 0)).build();
        HgIncrementalTestCase.Step branchAndMerge6 = new HgIncrementalTestCase.Step.Builder("inc-branch-merge-6").commits(DvcsRepoValidation.Commits.first("2c923f0473d327a92aef74af45de5d91676e187c", Arrays.asList("afcc494cbfb9094898ba02047e9bedf87c1999ef", "f767f0106b3126d2a0de357fdeeb81dc6106deab"), "hguser", "merged branch1 --> default (again)", "default", 1278299934000L, 0).l()).build();
        this.incrementalTest(this.initial, branchAndMerge1, branchAndMerge2, branchAndMerge3, branchAndMerge4, branchAndMerge5, branchAndMerge6);
    }

    @Test
    public void testMultipleHeads() throws Exception {
        HgIncrementalTestCase.Step multiHead1 = new HgIncrementalTestCase.Step.Builder("multi-head-1").commits(DvcsRepoValidation.Commits.first("15d06f1289fab9b5a1eafe8d7921faa1b023d712", "828762473510069fa17ec7151d1c86205ff9b71d", "hguser", "a new line for file1.txt", "default", 1278382511000L, 1).l()).commits(DvcsRepoValidation.Commits.first("eaf5d3432e1df9d4b2270ee7cf44df500e3660ae", "828762473510069fa17ec7151d1c86205ff9b71d", "hguser", "a different new line for file1.txt", "default", 1278382533000L, 1).l()).revs(DvcsRepoValidation.FileRevs.file("file1.txt").rev("15d06f1289fab9b5a1eafe8d7921faa1b023d712", "828762473510069fa17ec7151d1c86205ff9b71d", null, "hguser", "a new line for file1.txt", 1278382511000L, "default", DvcsRepoValidation.RevState.Modified, "file1.txt", false, 2, 1, 0).rev("eaf5d3432e1df9d4b2270ee7cf44df500e3660ae", "828762473510069fa17ec7151d1c86205ff9b71d", null, "hguser", "a different new line for file1.txt", 1278382533000L, "default", DvcsRepoValidation.RevState.Modified, "file1.txt", false, 2, 1, 0)).build();
        HgIncrementalTestCase.Step multiHead2 = new HgIncrementalTestCase.Step.Builder("multi-head-2").commits(DvcsRepoValidation.Commits.first("d071c10bdfc215d904adf46027f1060e663a9723", "15d06f1289fab9b5a1eafe8d7921faa1b023d712", "hguser", "added file3.txt", "default", 1278382696000L, 1).l()).commits(DvcsRepoValidation.Commits.first("fd19d4fb804738488613813d909bb312202c11a7", "d071c10bdfc215d904adf46027f1060e663a9723", "hguser", "added another line to file1.txt", "default", 1278382948000L, 1).l()).commits(DvcsRepoValidation.Commits.first("d79073a6593f06bccb8d9edca8e96b22743ea0a8", "d071c10bdfc215d904adf46027f1060e663a9723", "hguser", "added another different line to file1.txt", "default", 1278382970000L, 1).l()).revs(DvcsRepoValidation.FileRevs.file("sub/file3.txt").rev("d071c10bdfc215d904adf46027f1060e663a9723", null, null, "hguser", "added file3.txt", 1278382696000L, "default", DvcsRepoValidation.RevState.Added, "sub/file3.txt", false, 2, 2, 0)).revs(DvcsRepoValidation.FileRevs.file("file1.txt").rev("fd19d4fb804738488613813d909bb312202c11a7", "15d06f1289fab9b5a1eafe8d7921faa1b023d712", null, "hguser", "added another line to file1.txt", 1278382948000L, "default", DvcsRepoValidation.RevState.Modified, "file1.txt", false, 3, 1, 0).rev("d79073a6593f06bccb8d9edca8e96b22743ea0a8", "15d06f1289fab9b5a1eafe8d7921faa1b023d712", null, "hguser", "added another different line to file1.txt", 1278382970000L, "default", DvcsRepoValidation.RevState.Modified, "file1.txt", false, 3, 1, 0)).build();
        HgIncrementalTestCase.Step multiHead3 = new HgIncrementalTestCase.Step.Builder("multi-head-3").commits(DvcsRepoValidation.Commits.first("336feaeb98fc26d9fad80e918c89c65c3786fedf", Arrays.asList("eaf5d3432e1df9d4b2270ee7cf44df500e3660ae", "d79073a6593f06bccb8d9edca8e96b22743ea0a8"), "hguser", "merged h2 to h1", "default", 1278383614000L, 1).l()).revs(DvcsRepoValidation.FileRevs.file("file1.txt").rev("336feaeb98fc26d9fad80e918c89c65c3786fedf", "d79073a6593f06bccb8d9edca8e96b22743ea0a8", "eaf5d3432e1df9d4b2270ee7cf44df500e3660ae", "hguser", "merged h2 to h1", 1278383614000L, "default", DvcsRepoValidation.RevState.Modified, "file1.txt", false, 4, 1, 0)).build();
        HgIncrementalTestCase.Step multiHead4 = new HgIncrementalTestCase.Step.Builder("multi-head-4").commits(DvcsRepoValidation.Commits.first("6c8b50d44907b2067bc08582c5c66c4466a00b6c", Arrays.asList("336feaeb98fc26d9fad80e918c89c65c3786fedf", "fd19d4fb804738488613813d909bb312202c11a7"), "hguser", "merged h3 to h1", "default", 1278383706000L, 1).l()).revs(DvcsRepoValidation.FileRevs.file("file1.txt").rev("6c8b50d44907b2067bc08582c5c66c4466a00b6c", "336feaeb98fc26d9fad80e918c89c65c3786fedf", "fd19d4fb804738488613813d909bb312202c11a7", "hguser", "merged h3 to h1", 1278383706000L, "default", DvcsRepoValidation.RevState.Modified, "file1.txt", false, 5, 1, 0)).build();
        this.incrementalTest(this.initial, multiHead1, multiHead2, multiHead3, multiHead4);
    }

    @Test
    public void testTags() throws Exception {
        HgIncrementalTestCase.Step tags1 = new HgIncrementalTestCase.Step.Builder("inc-tags-1").commits(DvcsRepoValidation.Commits.first("c8aa0567003d901db8413a2b59f9b06bdc26aec8", "828762473510069fa17ec7151d1c86205ff9b71d", "hguser", "Added tag stable for changeset 828762473510", "default", 1278552900000L, 1).l()).revs(DvcsRepoValidation.FileRevs.file(".hgtags").rev("c8aa0567003d901db8413a2b59f9b06bdc26aec8", null, null, "hguser", "Added tag stable for changeset 828762473510", 1278552900000L, "default", DvcsRepoValidation.RevState.Added, ".hgtags", false, 1, 1, 0)).tag(new HgIncrementalTestCase.TagAction("stable", HgIncrementalTestCase.TagAction.Action.ADDED, "828762473510069fa17ec7151d1c86205ff9b71d")).build();
        HgIncrementalTestCase.Step tags2 = new HgIncrementalTestCase.Step.Builder("inc-tags-2").commits(DvcsRepoValidation.Commits.first("8988511cb755db9651089fb04c11aad211d02acc", "c8aa0567003d901db8413a2b59f9b06bdc26aec8", "hguser", "modified file1.txt", "default", 1278553022000L, 1).next("6cc2af0663777c6554a505635c0e0b47932375e4", "8988511cb755db9651089fb04c11aad211d02acc", "hguser", "Added tag unstable for changeset 8988511cb755", "default", 1278553027000L, 1).l()).revs(DvcsRepoValidation.FileRevs.file("file1.txt").rev("8988511cb755db9651089fb04c11aad211d02acc", "828762473510069fa17ec7151d1c86205ff9b71d", null, "hguser", "modified file1.txt", 1278553022000L, "default", DvcsRepoValidation.RevState.Modified, "file1.txt", false, 2, 1, 0)).revs(DvcsRepoValidation.FileRevs.file(".hgtags").rev("6cc2af0663777c6554a505635c0e0b47932375e4", "c8aa0567003d901db8413a2b59f9b06bdc26aec8", null, "hguser", "Added tag unstable for changeset 8988511cb755", 1278553027000L, "default", DvcsRepoValidation.RevState.Modified, ".hgtags", false, 2, 1, 0)).tag(new HgIncrementalTestCase.TagAction("unstable", HgIncrementalTestCase.TagAction.Action.ADDED, "8988511cb755db9651089fb04c11aad211d02acc")).build();
        HgIncrementalTestCase.Step tags3 = new HgIncrementalTestCase.Step.Builder("inc-tags-3").commits(DvcsRepoValidation.Commits.first("06f2e048f7887232fe355f1a30157ef7f92d188f", "6cc2af0663777c6554a505635c0e0b47932375e4", "hguser", "Added tag stable for changeset 6cc2af066377", "default", 1278553087000L, 1).l()).revs(DvcsRepoValidation.FileRevs.file(".hgtags").rev("06f2e048f7887232fe355f1a30157ef7f92d188f", "6cc2af0663777c6554a505635c0e0b47932375e4", null, "hguser", "Added tag stable for changeset 6cc2af066377", 1278553087000L, "default", DvcsRepoValidation.RevState.Modified, ".hgtags", false, 4, 2, 0)).tag(new HgIncrementalTestCase.TagAction("stable", HgIncrementalTestCase.TagAction.Action.REMOVED, "828762473510069fa17ec7151d1c86205ff9b71d")).tag(new HgIncrementalTestCase.TagAction("stable", HgIncrementalTestCase.TagAction.Action.ADDED, "6cc2af0663777c6554a505635c0e0b47932375e4")).build();
        HgIncrementalTestCase.Step tags4 = new HgIncrementalTestCase.Step.Builder("inc-tags-4").commits(DvcsRepoValidation.Commits.first("ed49658d017e491b2940bce6ac1883dc44149a25", "06f2e048f7887232fe355f1a30157ef7f92d188f", "hguser", "Removed tag unstable", "default", 1278553420000L, 1).l()).revs(DvcsRepoValidation.FileRevs.file(".hgtags").rev("ed49658d017e491b2940bce6ac1883dc44149a25", "06f2e048f7887232fe355f1a30157ef7f92d188f", null, "hguser", "Removed tag unstable", 1278553420000L, "default", DvcsRepoValidation.RevState.Modified, ".hgtags", false, 6, 2, 0)).tag(new HgIncrementalTestCase.TagAction("unstable", HgIncrementalTestCase.TagAction.Action.REMOVED, "8988511cb755db9651089fb04c11aad211d02acc")).build();
        HgIncrementalTestCase.Step tags5 = new HgIncrementalTestCase.Step.Builder("inc-tags-5").commits(DvcsRepoValidation.Commits.first("d879d475a6515fe0ca9a87be23bb506e9d3c9eb9", "ed49658d017e491b2940bce6ac1883dc44149a25", "hguser", "another modification", "default", 1278553528000L, 1).l()).revs(DvcsRepoValidation.FileRevs.file("file1.txt").rev("d879d475a6515fe0ca9a87be23bb506e9d3c9eb9", "8988511cb755db9651089fb04c11aad211d02acc", null, "hguser", "another modification", 1278553528000L, "default", DvcsRepoValidation.RevState.Modified, "file1.txt", false, 3, 1, 0)).build();
        HgIncrementalTestCase.Step tags6 = new HgIncrementalTestCase.Step.Builder("inc-tags-6").commits(DvcsRepoValidation.Commits.first("73898273e9dabc70fc65c041b4fcbfd2323fcb87", "d879d475a6515fe0ca9a87be23bb506e9d3c9eb9", "hguser", "Added tag unstable for changeset d879d475a651", "default", 1278553564000L, 1).l()).revs(DvcsRepoValidation.FileRevs.file(".hgtags").rev("73898273e9dabc70fc65c041b4fcbfd2323fcb87", "ed49658d017e491b2940bce6ac1883dc44149a25", null, "hguser", "Added tag unstable for changeset d879d475a651", 1278553564000L, "default", DvcsRepoValidation.RevState.Modified, ".hgtags", false, 8, 2, 0)).tag(new HgIncrementalTestCase.TagAction("unstable", HgIncrementalTestCase.TagAction.Action.ADDED, "d879d475a6515fe0ca9a87be23bb506e9d3c9eb9")).build();
        this.incrementalTest(this.initial, tags1, tags2, tags3, tags4, tags5, tags6);
    }

    @Test
    public void testBinaryToTextAndBackFiles() throws Exception {
        HgIncrementalTestCase.Step binaryToText1 = new HgIncrementalTestCase.Step.Builder("binary-to-text-1").commits(DvcsRepoValidation.Commits.first("8193862bee0a3fa15b621dad67fc7c659bd50b00", "828762473510069fa17ec7151d1c86205ff9b71d", "hguser", "Added testfile as text file", "default", 1278395030000L, 1).l()).revs(DvcsRepoValidation.FileRevs.file("testfile").rev("8193862bee0a3fa15b621dad67fc7c659bd50b00", null, null, "hguser", "Added testfile as text file", 1278395030000L, "default", DvcsRepoValidation.RevState.Added, "testfile", false, 1, 1, 0)).build();
        HgIncrementalTestCase.Step binaryToText2 = new HgIncrementalTestCase.Step.Builder("binary-to-text-2").commits(DvcsRepoValidation.Commits.first("58eb27f7fc1c699ae27c78eb6171cb94dba7dede", "8193862bee0a3fa15b621dad67fc7c659bd50b00", "hguser", "changed testfile to binary", "default", 1278395081000L, 1).l()).revs(DvcsRepoValidation.FileRevs.file("testfile").rev("58eb27f7fc1c699ae27c78eb6171cb94dba7dede", "8193862bee0a3fa15b621dad67fc7c659bd50b00", null, "hguser", "changed testfile to binary", 1278395081000L, "default", DvcsRepoValidation.RevState.Modified, "testfile", true, 0, 0, 1)).build();
        HgIncrementalTestCase.Step binaryToText3 = new HgIncrementalTestCase.Step.Builder("binary-to-text-3").commits(DvcsRepoValidation.Commits.first("bd77465034c8a778148b64323ff863ea484a971e", "58eb27f7fc1c699ae27c78eb6171cb94dba7dede", "hguser", "Back to text again", "default", 1278395114000L, 1).l()).revs(DvcsRepoValidation.FileRevs.file("testfile").rev("bd77465034c8a778148b64323ff863ea484a971e", "58eb27f7fc1c699ae27c78eb6171cb94dba7dede", null, "hguser", "Back to text again", 1278395114000L, "default", DvcsRepoValidation.RevState.Modified, "testfile", false, 1, 1, 0)).build();
        this.incrementalTest(this.initial, binaryToText1, binaryToText2);
    }

    @Test
    public void testCopyFile() throws Exception {
        HgIncrementalTestCase.Step copy1 = new HgIncrementalTestCase.Step.Builder("inc-copy-1").commits(DvcsRepoValidation.Commits.first("8ae0c3230a4f74614074220f690ddeb315bfc824", "hguser", "copied file1.txt", "default", 1278563726000L, 1).l()).revs(DvcsRepoValidation.FileRevs.file("copy.txt").rev("8ae0c3230a4f74614074220f690ddeb315bfc824", "828762473510069fa17ec7151d1c86205ff9b71d", null, "hguser", "copied file1.txt", 1278563726000L, "default", DvcsRepoValidation.RevState.Copied, "file1.txt", false, 1, 0, 0)).build();
        HgIncrementalTestCase.Step copy2 = new HgIncrementalTestCase.Step.Builder("inc-copy-2").commits(DvcsRepoValidation.Commits.first("a4430f4c5d97e615baedb9c772ed23bcd5dfa2f0", "hguser", "added a line to file1", "default", 1278563769000L, 1).l()).revs(DvcsRepoValidation.FileRevs.file("file1.txt").rev("a4430f4c5d97e615baedb9c772ed23bcd5dfa2f0", "828762473510069fa17ec7151d1c86205ff9b71d", null, "hguser", "added a line to file1", 1278563769000L, "default", DvcsRepoValidation.RevState.Modified, "file1.txt", false, 2, 1, 0)).build();
        HgIncrementalTestCase.Step copy3 = new HgIncrementalTestCase.Step.Builder("inc-copy-3").commits(DvcsRepoValidation.Commits.first("8c6860c4d13de9ec2a5958cf71edce6688d87664", "hguser", "merged 2 to 1", "default", 1278563817000L, 1).l()).revs(DvcsRepoValidation.FileRevs.file("copy.txt").rev("8c6860c4d13de9ec2a5958cf71edce6688d87664", "a4430f4c5d97e615baedb9c772ed23bcd5dfa2f0", "8ae0c3230a4f74614074220f690ddeb315bfc824", "hguser", "merged 2 to 1", 1278563817000L, "default", DvcsRepoValidation.RevState.Copied, "file1.txt", false, 2, 1, 0)).build();
    }

    @Test
    public void testMoveFile() throws Exception {
        HgIncrementalTestCase.Step move1 = new HgIncrementalTestCase.Step.Builder("inc-move-1").commits(DvcsRepoValidation.Commits.first("9ccc264c87ca6142aa98a9f4176d36002a707525", "hguser", "moved file1", "default", 1278564840000L, 1).l()).revs(DvcsRepoValidation.FileRevs.file("moved.txt").rev("9ccc264c87ca6142aa98a9f4176d36002a707525", "828762473510069fa17ec7151d1c86205ff9b71d", null, "hguser", "moved file1", 1278564840000L, "default", DvcsRepoValidation.RevState.Renamed, "file1.txt", false, 1, 0, 0)).build();
        HgIncrementalTestCase.Step move2 = new HgIncrementalTestCase.Step.Builder("inc-move-2").commits(DvcsRepoValidation.Commits.first("31311c08fd6557a5235dd6207f0fc31bc047900b", "hguser", "added a line to file1", "default", 1278564886000L, 1).l()).revs(DvcsRepoValidation.FileRevs.file("file1.txt").rev("31311c08fd6557a5235dd6207f0fc31bc047900b", "828762473510069fa17ec7151d1c86205ff9b71d", null, "hguser", "added a line to file1", 1278564886000L, "default", DvcsRepoValidation.RevState.Modified, "file1.txt", false, 2, 1, 0)).build();
        HgIncrementalTestCase.Step move3 = new HgIncrementalTestCase.Step.Builder("inc-move-3").commits(DvcsRepoValidation.Commits.first("515c0155a26c43675735152f20b99890d6666ebb", "hguser", "merged", "default", 1278564920000L, 1).l()).revs(DvcsRepoValidation.FileRevs.file("moved.txt").rev("515c0155a26c43675735152f20b99890d6666ebb", "31311c08fd6557a5235dd6207f0fc31bc047900b", "9ccc264c87ca6142aa98a9f4176d36002a707525", "hguser", "merged", 1278564920000L, "default", DvcsRepoValidation.RevState.Renamed, "file1.txt", false, 2, 1, 0)).build();
    }

    @Test
    public void testCaseChangeFilename() throws Exception {
        HgIncrementalTestCase.Step case1 = new HgIncrementalTestCase.Step.Builder("inc-case-1").commits(DvcsRepoValidation.Commits.first("18d6c9fa224ac5314818c56e11d029db1c3a5e9d", "828762473510069fa17ec7151d1c86205ff9b71d", "hguser", "moved file1 to FIle1", "default", 1278565730000L, 2).l()).revs(DvcsRepoValidation.FileRevs.file("FIle1.txt").rev("18d6c9fa224ac5314818c56e11d029db1c3a5e9d", "828762473510069fa17ec7151d1c86205ff9b71d", null, "hguser", "moved file1 to FIle1", 1278565730000L, "default", DvcsRepoValidation.RevState.Renamed, "file1.txt", false, 1, 0, 0)).revs(DvcsRepoValidation.FileRevs.file("file1.txt").rev("18d6c9fa224ac5314818c56e11d029db1c3a5e9d", "828762473510069fa17ec7151d1c86205ff9b71d", null, "hguser", "moved file1 to FIle1", 1278565730000L, "default", DvcsRepoValidation.RevState.Deleted, "file1.txt", false, 0, 0, 1)).build();
        HgIncrementalTestCase.Step case2 = new HgIncrementalTestCase.Step.Builder("inc-case-2").commits(DvcsRepoValidation.Commits.first("27e723835b332b11d047583d0a9d599b385b2740", "18d6c9fa224ac5314818c56e11d029db1c3a5e9d", "hguser", "added file1.txt", "default", 1278565764000L, 1).l()).revs(DvcsRepoValidation.FileRevs.file("file1.txt").rev("27e723835b332b11d047583d0a9d599b385b2740", null, null, "hguser", "added file1.txt", 1278565764000L, "default", DvcsRepoValidation.RevState.Added, "file1.txt", false, 1, 1, 0)).build();
        HgIncrementalTestCase.Step case3 = new HgIncrementalTestCase.Step.Builder("inc-case-3").commits(DvcsRepoValidation.Commits.first("14b99995918f6a3ebc464c3a91abc6cc73dc88f5", "27e723835b332b11d047583d0a9d599b385b2740", "hguser", "removed file2.txt, added fiLE2.txt", "default", 1278565857000L, 2).l()).revs(DvcsRepoValidation.FileRevs.file("sub/file2.txt").rev("14b99995918f6a3ebc464c3a91abc6cc73dc88f5", "828762473510069fa17ec7151d1c86205ff9b71d", null, "hguser", "removed file2.txt, added fiLE2.txt", 1278565857000L, "default", DvcsRepoValidation.RevState.Deleted, "sub/file2.txt", false, 0, 0, 1)).revs(DvcsRepoValidation.FileRevs.file("sub/fiLE2.txt").rev("14b99995918f6a3ebc464c3a91abc6cc73dc88f5", null, null, "hguser", "removed file2.txt, added fiLE2.txt", 1278565857000L, "default", DvcsRepoValidation.RevState.Added, "sub/fiLE2.txt", false, 1, 1, 0)).build();
        HgIncrementalTestCase.Step case4 = new HgIncrementalTestCase.Step.Builder("inc-case-4").commits(DvcsRepoValidation.Commits.first("156590efecb19703b992e65c141f3ab3c92a6272", "14b99995918f6a3ebc464c3a91abc6cc73dc88f5", "hguser", "moved file2.txt, added a new version", "default", 1278565937000L, 2).l()).revs(DvcsRepoValidation.FileRevs.file("sub/moved.txt").rev("156590efecb19703b992e65c141f3ab3c92a6272", "14b99995918f6a3ebc464c3a91abc6cc73dc88f5", null, "hguser", "moved file2.txt, added a new version", 1278565937000L, "default", DvcsRepoValidation.RevState.Renamed, "sub/fiLE2.txt", false, 1, 0, 0)).revs(DvcsRepoValidation.FileRevs.file("sub/fiLE2.txt").rev("156590efecb19703b992e65c141f3ab3c92a6272", null, null, "hguser", "moved file2.txt, added a new version", 1278565937000L, "default", DvcsRepoValidation.RevState.Added, "sub/fiLE2.txt", false, 1, 1, 0)).build();
        this.incrementalTest(this.initial, case1, case2, case3);
    }

    @Test
    public void testLinesOfCode() throws Exception {
        HgIncrementalTestCase.Step loc1 = new HgIncrementalTestCase.Step.Builder("inc-loc-1").commits(DvcsRepoValidation.Commits.first("f131c5c116f4bec69422abb0557b5361279ef8fe", "828762473510069fa17ec7151d1c86205ff9b71d", "hguser", "LOC test 1", "default", 1278639384000L, 2).l()).revs(DvcsRepoValidation.FileRevs.file("file1.txt").rev("f131c5c116f4bec69422abb0557b5361279ef8fe", "828762473510069fa17ec7151d1c86205ff9b71d", null, "hguser", "LOC test 1", 1278639384000L, "default", DvcsRepoValidation.RevState.Modified, "file1.txt", false, 67, 67, 1)).revs(DvcsRepoValidation.FileRevs.file("sub/file2.txt").rev("f131c5c116f4bec69422abb0557b5361279ef8fe", "828762473510069fa17ec7151d1c86205ff9b71d", null, "hguser", "LOC test 1", 1278639384000L, "default", DvcsRepoValidation.RevState.Modified, "sub/file2.txt", false, 4, 3, 0)).build();
        HgIncrementalTestCase.Step loc2 = new HgIncrementalTestCase.Step.Builder("inc-loc-2").commits(DvcsRepoValidation.Commits.first("4448013bbc71720a4e4356e036ccef00e74d9d51", "828762473510069fa17ec7151d1c86205ff9b71d", "hguser", "LOC test 2a", "default", 1278639672000L, 2).l()).commits(DvcsRepoValidation.Commits.first("d8e1247496891a59e769a4b4c372dd2e74c1eee0", Arrays.asList("4448013bbc71720a4e4356e036ccef00e74d9d51", "f131c5c116f4bec69422abb0557b5361279ef8fe"), "hguser", "LOC 2b", "default", 1278639808000L, 2).l()).revs(DvcsRepoValidation.FileRevs.file("file1.txt").rev("4448013bbc71720a4e4356e036ccef00e74d9d51", "828762473510069fa17ec7151d1c86205ff9b71d", null, "hguser", "LOC test 2a", 1278639672000L, "default", DvcsRepoValidation.RevState.Modified, "file1.txt", false, 2, 1, 0).rev("d8e1247496891a59e769a4b4c372dd2e74c1eee0", "4448013bbc71720a4e4356e036ccef00e74d9d51", "f131c5c116f4bec69422abb0557b5361279ef8fe", "hguser", "LOC 2b", 1278639808000L, "default", DvcsRepoValidation.RevState.Modified, "file1.txt", false, 67, 66, 1)).revs(DvcsRepoValidation.FileRevs.file("sub/file2.txt").rev("4448013bbc71720a4e4356e036ccef00e74d9d51", "828762473510069fa17ec7151d1c86205ff9b71d", null, "hguser", "LOC test 2a", 1278639672000L, "default", DvcsRepoValidation.RevState.Modified, "sub/file2.txt", false, 4, 3, 0).rev("d8e1247496891a59e769a4b4c372dd2e74c1eee0", "4448013bbc71720a4e4356e036ccef00e74d9d51", "f131c5c116f4bec69422abb0557b5361279ef8fe", "hguser", "LOC 2b", 1278639808000L, "default", DvcsRepoValidation.RevState.Modified, "sub/file2.txt", false, 7, 4, 1)).build();
        this.incrementalTest(this.initial, loc1, loc2);
        Assert.assertThat((Object)((HgCache)this.getCache()).getBlameSpans(new RevInfoKey(new Path((CharSequence)"sub/file2.txt"), "d8e1247496891a59e769a4b4c372dd2e74c1eee0")), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{new BlameChunkMatcher(0, 1), new BlameChunkMatcher(1, 2), new BlameChunkMatcher(2, 5), new BlameChunkMatcher(5, 7)}));
    }

    @Test
    public void testPermissionChanges() throws Exception {
        HgIncrementalTestCase.Step perm1 = new HgIncrementalTestCase.Step.Builder("inc-perm-1").commits(DvcsRepoValidation.Commits.first("2034ef0e525ced6a4bc1eeeeffd56c9fdcbdc215", "828762473510069fa17ec7151d1c86205ff9b71d", "hguser", "u+x", "default", 1278567050000L, 1).l()).revs(DvcsRepoValidation.FileRevs.file("file1.txt").rev("2034ef0e525ced6a4bc1eeeeffd56c9fdcbdc215", null, null, "hguser", "u+x", 1278567050000L, "default", DvcsRepoValidation.RevState.MetaChange, "file1.txt", false, 1, 0, 0)).build();
        HgIncrementalTestCase.Step perm2 = new HgIncrementalTestCase.Step.Builder("inc-perm-2").commits(DvcsRepoValidation.Commits.first("6234c45fbb4d5b5e87979aee7a6fbb46062eb0fb", "2034ef0e525ced6a4bc1eeeeffd56c9fdcbdc215", "hguser", "u-x and extra line", "default", 1278567131000L, 1).l()).revs(DvcsRepoValidation.FileRevs.file("file1.txt").rev("6234c45fbb4d5b5e87979aee7a6fbb46062eb0fb", "828762473510069fa17ec7151d1c86205ff9b71d", null, "hguser", "u-x and extra line", 1278567131000L, "default", DvcsRepoValidation.RevState.Modified, "file1.txt", false, 2, 1, 0)).build();
        HgIncrementalTestCase.Step perm3 = new HgIncrementalTestCase.Step.Builder("inc-perm-3").commits(DvcsRepoValidation.Commits.first("aaae5efe049fd0d79d22d1129c1b921b8c388525", "6234c45fbb4d5b5e87979aee7a6fbb46062eb0fb", "hguser", "copied and a+w", "default", 1278567185000L, 1).l()).revs(DvcsRepoValidation.FileRevs.file("file1-copy.txt").rev("aaae5efe049fd0d79d22d1129c1b921b8c388525", "6234c45fbb4d5b5e87979aee7a6fbb46062eb0fb", null, "hguser", "copied and a+w", 1278567185000L, "default", DvcsRepoValidation.RevState.Copied, "file1.txt", false, 2, 0, 0)).build();
        HgIncrementalTestCase.Step perm4 = new HgIncrementalTestCase.Step.Builder("inc-perm-4").commits(DvcsRepoValidation.Commits.first("1d9fe11602469ff2e653b760bf3c860b6bd932be", "aaae5efe049fd0d79d22d1129c1b921b8c388525", "hguser", "bla", "default", 1278567882000L, 1).l()).revs(DvcsRepoValidation.FileRevs.file("file1.orig.txt").rev("1d9fe11602469ff2e653b760bf3c860b6bd932be", "6234c45fbb4d5b5e87979aee7a6fbb46062eb0fb", null, "hguser", "bla", 1278567882000L, "default", DvcsRepoValidation.RevState.Renamed, "file1.txt", false, 2, 0, 0)).build();
    }

    @Test
    public void testFileToDirectory() throws Exception {
        HgIncrementalTestCase.Step step = new HgIncrementalTestCase.Step.Builder("file-to-dir").commits(DvcsRepoValidation.Commits.first("8f66a2895c53e1331653ec0274b057f1018a6fae", "828762473510069fa17ec7151d1c86205ff9b71d", "hguser", "moved a file, created a dir to replace it", "default", 1278569457000L, 3).l()).revs(DvcsRepoValidation.FileRevs.file("file1-moved.txt").rev("8f66a2895c53e1331653ec0274b057f1018a6fae", "828762473510069fa17ec7151d1c86205ff9b71d", null, "hguser", "moved a file, created a dir to replace it", 1278569457000L, "default", DvcsRepoValidation.RevState.Renamed, "file1.txt", false, 1, 0, 0)).revs(DvcsRepoValidation.FileRevs.file("file1.txt").rev("8f66a2895c53e1331653ec0274b057f1018a6fae", "828762473510069fa17ec7151d1c86205ff9b71d", null, "hguser", "moved a file, created a dir to replace it", 1278569457000L, "default", DvcsRepoValidation.RevState.Deleted, "file1.txt", false, 0, 0, 1)).revs(DvcsRepoValidation.FileRevs.file("file1.txt/hi").rev("8f66a2895c53e1331653ec0274b057f1018a6fae", null, null, "hguser", "moved a file, created a dir to replace it", 1278569457000L, "default", DvcsRepoValidation.RevState.Added, "file1.txt/hi", false, 1, 1, 0)).build();
        this.incrementalTest(this.initial, step);
    }

    @Test
    public void testDirectoryToFile() throws Exception {
        HgIncrementalTestCase.Step step = new HgIncrementalTestCase.Step.Builder("dir-to-file").commits(DvcsRepoValidation.Commits.first("9e109c4f53d3a192a4a732ac21e3200e6557c2d7", "828762473510069fa17ec7151d1c86205ff9b71d", "hguser", "moved a dir and created a file to replace it", "default", 1278569389000L, 3).l()).revs(DvcsRepoValidation.FileRevs.file("sub-moved/file2.txt").rev("9e109c4f53d3a192a4a732ac21e3200e6557c2d7", "828762473510069fa17ec7151d1c86205ff9b71d", null, "hguser", "moved a dir and created a file to replace it", 1278569389000L, "default", DvcsRepoValidation.RevState.Renamed, "sub/file2.txt", false, 1, 0, 0)).revs(DvcsRepoValidation.FileRevs.file("sub/file2.txt").rev("9e109c4f53d3a192a4a732ac21e3200e6557c2d7", "828762473510069fa17ec7151d1c86205ff9b71d", null, "hguser", "moved a dir and created a file to replace it", 1278569389000L, "default", DvcsRepoValidation.RevState.Deleted, "sub/file2.txt", false, 0, 0, 1)).revs(DvcsRepoValidation.FileRevs.file("sub").rev("9e109c4f53d3a192a4a732ac21e3200e6557c2d7", null, null, "hguser", "moved a dir and created a file to replace it", 1278569389000L, "default", DvcsRepoValidation.RevState.Added, "sub", false, 1, 1, 0)).build();
        this.incrementalTest(this.initial, step);
    }
}

