/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg;

import com.atlassian.fisheye.dvcs.DvcsRepoValidation;
import com.atlassian.fisheye.hg.HgCache;
import com.atlassian.fisheye.hg.HgSlurpTestBase;
import com.atlassian.fisheye.hg.db.HgChangeSet;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config1.AllowType;
import com.cenqua.fisheye.rep.FileHistory;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class HgIncludeExcludeTest
extends HgSlurpTestBase {
    public HgIncludeExcludeTest() {
        super("inc-excl-test");
    }

    @Override
    protected AllowType getAllowRules() {
        AllowType allow = AllowType.Factory.newInstance();
        allow.addNewExclude().setPattern("excluded/**");
        return allow;
    }

    @Test
    public void testIncludeExcludeRules() throws Exception {
        this.verifyBasicIncludeExcludeRules();
        this.verifyFullyExcludedChangeSetIsNotIndexed();
        this.verifyMixedChangeSetIsIndexed();
        this.verifyBranchWithoutChangesInWatchedSpaceIsNotIndexed();
        this.verifyBranchWithLaterChangesInWatchedSpaceIsIndexed();
        this.verifyCopyIntoWatchedSpaceIsTreatedAsNewFile();
        this.verifyMoveIntoWatchedSpaceIsTreatedAsNewFile();
        this.verifyCopyOutOfWatchedSpaceIsIgnored();
        this.verifyMoveOutOfWatchedSpaceIsTreatedAsDelete();
        this.verifyCopyInsideWatchedSpaceIsIndexed();
        this.verifyMoveIntoWatchedSpaceIsTreatedAsNewFile();
        this.verifyChangeSetParentsAfterExcludedChangeSet();
    }

    public void verifyBasicIncludeExcludeRules() throws Exception {
        FileHistory excludedFile = ((HgCache)this.getCache()).getFileHistory(new Path((CharSequence)"excluded/excluded_file.txt"));
        Assert.assertTrue((String)"excluded/excluded_file should not be indexed", (boolean)excludedFile.getRevisions().isEmpty());
        FileHistory includedFile = ((HgCache)this.getCache()).getFileHistory(new Path((CharSequence)"included/included_file.txt"));
        Assert.assertFalse((String)"included/included_file  not be indexed", (boolean)includedFile.getRevisions().isEmpty());
        FileHistory rootFile = ((HgCache)this.getCache()).getFileHistory(new Path((CharSequence)"root_file.txt"));
        Assert.assertFalse((String)"root_file  not be indexed", (boolean)rootFile.getRevisions().isEmpty());
    }

    public void verifyFullyExcludedChangeSetIsNotIndexed() throws Exception {
        Assert.assertNull((String)"5eb95cf3fc67 should not be indexed", (Object)((HgCache)this.getCache()).getChangeSet("5eb95cf3fc67222ae76ccb3c50256ab5a9541709"));
    }

    public void verifyMixedChangeSetIsIndexed() throws Exception {
        HgChangeSet changeset = (HgChangeSet)((HgCache)this.getCache()).getChangeSet("cb7cc2e3e0940852a29c35316f04a0576fff7570");
        Assert.assertNotNull((String)"mixed changeset cb7cc2e3e094 should be indexed", (Object)changeset);
    }

    public void verifyBranchWithoutChangesInWatchedSpaceIsNotIndexed() throws Exception {
        Assert.assertFalse((boolean)((HgCache)this.getCache()).isBranchPointIndexed("excluded_only"));
    }

    public void verifyBranchWithLaterChangesInWatchedSpaceIsIndexed() throws Exception {
        HgChangeSet changeset = (HgChangeSet)((HgCache)this.getCache()).getChangeSet("902c93ed82ad37d98af7433bd8a0cebc4421e181");
        Assert.assertNotNull((String)"a changeset should be known for branch 'deferred_branch'", (Object)changeset);
        Assert.assertEquals((Object)"deferred_branch", (Object)changeset.getBranch());
        Assert.assertTrue((boolean)((HgCache)this.getCache()).isBranchPointIndexed("deferred_branch"));
    }

    public void verifyCopyIntoWatchedSpaceIsTreatedAsNewFile() throws Exception {
        DvcsRepoValidation.Revision expectedRev = new DvcsRepoValidation.Revision("included/copied_excluded_file.txt", "a1f511a7ff5211bfebda0beaf23d16a65f3e4b4c", (List<String>)NO_PARENTS, "hguser", "copied a file into watched area", 1281922855000L, "default", DvcsRepoValidation.RevState.Added, null, false, 3, 3, 0);
        this.assertRevisionEquals(expectedRev, this.getActualRevInfo(expectedRev));
    }

    public void verifyMoveIntoWatchedSpaceIsTreatedAsNewFile() throws Exception {
        DvcsRepoValidation.Revision expectedRev = new DvcsRepoValidation.Revision("included/moved_excluded_file.txt", "ca2bbef8073b99ce846e2159c10654657b78f41c", (List<String>)NO_PARENTS, "hguser", "moved file into watched area", 1281923035000L, "default", DvcsRepoValidation.RevState.Added, null, false, 3, 3, 0);
        this.assertRevisionEquals(expectedRev, this.getActualRevInfo(expectedRev));
    }

    public void verifyCopyOutOfWatchedSpaceIsIgnored() throws Exception {
        FileHistory fileHistory = ((HgCache)this.getCache()).getFileHistory(new Path((CharSequence)"excluded/copied_included_file.txt"));
        Assert.assertEquals((String)"no revisions expected", (long)0L, (long)fileHistory.getRevisions().size());
    }

    public void verifyMoveOutOfWatchedSpaceIsTreatedAsDelete() throws Exception {
        DvcsRepoValidation.Revision expectedRev = new DvcsRepoValidation.Revision("included/moved_excluded_file.txt", "38c7a7876ce61cab0b354748aa6c2e89132180c6", Arrays.asList("ca2bbef8073b99ce846e2159c10654657b78f41c"), "hguser", "moved a file from included to excluded", 1282004119000L, "default", DvcsRepoValidation.RevState.Deleted, "included/moved_excluded_file.txt", false, 0, 0, 3);
        this.assertRevisionEquals(expectedRev, this.getActualRevInfo(expectedRev));
    }

    public void verifyMoveAroundInsideWatchedSpaceIsIndexed() throws Exception {
        this.assertRevisionData(DvcsRepoValidation.FileRevs.file("included/moved_inside_watched_area.txt").rev("72449af188998d8cef8b8133568c98cb83d31fe1", "a1f511a7ff5211bfebda0beaf23d16a65f3e4b4c", null, "hguser", "moved a file around inside the watched area", 1282004203000L, "default", DvcsRepoValidation.RevState.Renamed, "included/copied_excluded_file.txt", false, 3, 0, 0));
    }

    public void verifyCopyInsideWatchedSpaceIsIndexed() throws Exception {
        this.assertRevisionData(DvcsRepoValidation.FileRevs.file("included/copied_inside_watched_area.txt").rev("573d087ac74a2562280431d3243a45c1a9fe624a", "cb7cc2e3e0940852a29c35316f04a0576fff7570", null, "hguser", "copied a file inside the watched area", 1282004234000L, "default", DvcsRepoValidation.RevState.Copied, "included/included_file.txt", false, 2, 0, 0));
    }

    public void verifyChangeSetParentsAfterExcludedChangeSet() throws Exception {
        HgChangeSet changeset7 = (HgChangeSet)((HgCache)this.getCache()).getChangeSet("38c7a7876ce61cab0b354748aa6c2e89132180c6");
        Assert.assertEquals((long)1L, (long)changeset7.getParents().size());
        Assert.assertEquals((String)"skipped changeset should not be set as a parent", (Object)"ca2bbef8073b99ce846e2159c10654657b78f41c", changeset7.getParents().get(0));
    }
}

