/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.hg;

import com.atlassian.fisheye.git.db.GitRevInfo;
import com.atlassian.fisheye.hg.HgCache;
import com.atlassian.fisheye.hg.HgSlurpTestBase;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileHistory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;

public class HgI18nPaths
extends HgSlurpTestBase {
    public HgI18nPaths() {
        super("hgi18npaths");
    }

    @Test
    public void testPaths() throws DbException, IOException {
        HgCache cache = (HgCache)this.getCache();
        FileHistory f1History = cache.getFileHistory(new Path((CharSequence)"filew\u00eeth\u00e0cc\u00e8nt.txt"));
        Assert.assertEquals((String)"Incorrect history size", (long)2L, (long)f1History.getRevisions().size());
        Iterator iter = f1History.getRevisions().iterator();
        GitRevInfo rev1 = (GitRevInfo)iter.next();
        GitRevInfo rev2 = (GitRevInfo)iter.next();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        cache.getTextRevision(rev1.getRevInfoKey(), (OutputStream)baos, null, null);
        baos.close();
        Assert.assertEquals((String)"Rev 1 content mismatch", (Object)"This file has \u00e0cc\u00e8nts\n", (Object)baos.toString("UTF-8"));
        baos = new ByteArrayOutputStream();
        cache.getTextRevision(rev2.getRevInfoKey(), (OutputStream)baos, null, null);
        baos.close();
        Assert.assertEquals((String)"Rev 2 content mismatch", (Object)"This file has \u00e0cc\u00e8nts\nNow it has a different acc\u00e8nt", (Object)baos.toString("UTF-8"));
    }
}

